/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.crypto.digest;

import java.io.File;
import java.io.InputStream;
import javax.crypto.SecretKey;
import org.gjgr.pig.chivalrous.core.crypto.digest.DigestType;
import org.gjgr.pig.chivalrous.core.crypto.digest.Digester;
import org.gjgr.pig.chivalrous.core.crypto.digest.HMac;
import org.gjgr.pig.chivalrous.core.crypto.digest.HmacAlgorithm;

public final class DigestUtil {
    private DigestUtil() {
    }

    public static byte[] md5(byte[] data) {
        return new Digester(DigestType.MD5).digest(data);
    }

    public static byte[] md5(String data, String charset) {
        return new Digester(DigestType.MD5).digest(data, charset);
    }

    public static byte[] md5(String data) {
        return DigestUtil.md5(data, "UTF-8");
    }

    public static byte[] md5(InputStream data) {
        return new Digester(DigestType.MD5).digest(data);
    }

    public static byte[] md5(File file) {
        return new Digester(DigestType.MD5).digest(file);
    }

    public static String md5Hex(byte[] data) {
        return new Digester(DigestType.MD5).digestHex(data);
    }

    public static String md5Hex(String data, String charset) {
        return new Digester(DigestType.MD5).digestHex(data, charset);
    }

    public static String md5Hex(String data) {
        return DigestUtil.md5Hex(data, "UTF-8");
    }

    public static String md5Hex(InputStream data) {
        return new Digester(DigestType.MD5).digestHex(data);
    }

    public static String md5Hex(File file) {
        return new Digester(DigestType.MD5).digestHex(file);
    }

    public static byte[] sha1(byte[] data) {
        return new Digester(DigestType.SHA1).digest(data);
    }

    public static byte[] sha1(String data, String charset) {
        return new Digester(DigestType.SHA1).digest(data, charset);
    }

    public static byte[] sha1(String data) {
        return DigestUtil.sha1(data, "UTF-8");
    }

    public static byte[] sha1(InputStream data) {
        return new Digester(DigestType.SHA1).digest(data);
    }

    public static byte[] sha1(File file) {
        return new Digester(DigestType.SHA1).digest(file);
    }

    public static String sha1Hex(byte[] data) {
        return new Digester(DigestType.SHA1).digestHex(data);
    }

    public static String sha1Hex(String data, String charset) {
        return new Digester(DigestType.SHA1).digestHex(data, charset);
    }

    public static String sha1Hex(String data) {
        return DigestUtil.sha1Hex(data, "UTF-8");
    }

    public static String sha1Hex(InputStream data) {
        return new Digester(DigestType.SHA1).digestHex(data);
    }

    public static String sha1Hex(File file) {
        return new Digester(DigestType.SHA1).digestHex(file);
    }

    public static HMac hmac(HmacAlgorithm algorithm, byte[] key) {
        return new HMac(algorithm, key);
    }

    public static HMac hmac(HmacAlgorithm algorithm, SecretKey key) {
        return new HMac(algorithm, key);
    }
}

