/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.crypto.digest;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.gjgr.pig.chivalrous.core.crypto.CryptoException;
import org.gjgr.pig.chivalrous.core.crypto.digest.DigestType;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.io.file.FileCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.math.HexCommand;

public class Digester {
    private MessageDigest digest;

    public Digester(DigestType algorithm) {
        this.init(algorithm.getValue());
    }

    public Digester init(String algorithm) {
        try {
            this.digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return this;
    }

    public byte[] digest(String data, String charset) {
        return this.digest(StringCommand.bytes(data, charset));
    }

    public byte[] digest(String data) {
        return this.digest(data, "UTF-8");
    }

    public String digestHex(String data, String charset) {
        return HexCommand.encodeHexStr(this.digest(data, charset));
    }

    public String digestHex(String data) {
        return this.digestHex(data, "UTF-8");
    }

    public byte[] digest(File file) {
        BufferedInputStream in = null;
        try {
            in = FileCommand.bufferedInputStream(file);
            byte[] byArray = this.digest(in);
            return byArray;
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        finally {
            IoCommand.close(in);
        }
    }

    public String digestHex(File file) {
        return HexCommand.encodeHexStr(this.digest(file));
    }

    public byte[] digest(byte[] data) {
        byte[] result;
        try {
            result = this.digest.digest(data);
        }
        finally {
            this.digest.reset();
        }
        return result;
    }

    public String digestHex(byte[] data) {
        return HexCommand.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data) {
        return this.digest(data, 1024);
    }

    public String digestHex(InputStream data) {
        return HexCommand.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data, int bufferLength) {
        if (bufferLength < 1) {
            bufferLength = 1024;
        }
        byte[] buffer = new byte[bufferLength];
        byte[] result = null;
        try {
            int read = data.read(buffer, 0, bufferLength);
            while (read > -1) {
                this.digest.update(buffer, 0, read);
                read = data.read(buffer, 0, bufferLength);
            }
            result = this.digest.digest();
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        finally {
            this.digest.reset();
        }
        return result;
    }

    public String digestHex(InputStream data, int bufferLength) {
        return HexCommand.encodeHexStr(this.digest(data, bufferLength));
    }

    public MessageDigest getDigest() {
        return this.digest;
    }
}

