/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.date;

import java.util.Date;
import org.gjgr.pig.chivalrous.core.date.BetweenFormater;
import org.gjgr.pig.chivalrous.core.date.DateTimeCommand;
import org.gjgr.pig.chivalrous.core.date.DateUnit;

public class DateBetween {
    private Date start;
    private Date end;

    public DateBetween(Date start, Date end) {
        if (start.before(end)) {
            this.start = start;
            this.end = end;
        } else {
            this.start = end;
            this.end = start;
        }
    }

    public long between(DateUnit unit) {
        long diff = this.end.getTime() - this.start.getTime();
        return diff / unit.getMillis();
    }

    public String toString(BetweenFormater.Level level) {
        return DateTimeCommand.formatBetween(this.between(DateUnit.MS), level);
    }

    public String toString() {
        return this.toString(BetweenFormater.Level.MILLSECOND);
    }
}

