/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.date;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.gjgr.pig.chivalrous.core.date.BetweenFormater;
import org.gjgr.pig.chivalrous.core.date.DateBetween;
import org.gjgr.pig.chivalrous.core.date.DateException;
import org.gjgr.pig.chivalrous.core.date.DateField;
import org.gjgr.pig.chivalrous.core.date.DateStyle;
import org.gjgr.pig.chivalrous.core.date.DateTimeCommand;
import org.gjgr.pig.chivalrous.core.date.DateUnit;
import org.gjgr.pig.chivalrous.core.date.PigMonth;
import org.gjgr.pig.chivalrous.core.date.PigSeason;
import org.gjgr.pig.chivalrous.core.date.PigWeek;
import org.gjgr.pig.chivalrous.core.date.format.DateTimeFormatter;
import org.gjgr.pig.chivalrous.core.date.format.DateTimeParser;
import org.gjgr.pig.chivalrous.core.date.format.DateTimePrinter;
import org.gjgr.pig.chivalrous.core.lang.ObjectCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;

public class DateTime
extends Date {
    private static final long serialVersionUID = -5395712593979185936L;
    private boolean mutable = true;

    public DateTime() {
    }

    public DateTime(Date date) {
        this(date.getTime());
    }

    public DateTime(Calendar calendar) {
        this(calendar.getTime());
    }

    public DateTime(long timeMillis) {
        super(timeMillis);
    }

    public DateTime(String dateStr, String format) {
        this(dateStr, DateTimeFormatter.getInstance(format));
    }

    public DateTime(String dateStr, DateFormat dateFormat) {
        this(DateTime.parse(dateStr, dateFormat));
    }

    public DateTime(String dateStr, DateTimeParser dateParser) {
        this(DateTime.parse(dateStr, dateParser));
    }

    public static DateTime of(Date date) {
        return new DateTime(date);
    }

    public static DateTime of(Calendar calendar) {
        return new DateTime(calendar);
    }

    public static DateTime of(String dateStr, String format) {
        return new DateTime(dateStr, format);
    }

    public static DateTime now() {
        return new DateTime();
    }

    private static Date parse(String dateStr, DateFormat dateFormat) {
        try {
            return dateFormat.parse(dateStr);
        }
        catch (Exception e) {
            String pattern = dateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)dateFormat).toPattern() : dateFormat.toString();
            throw new DateException(StringCommand.format("Parse [{}] with format [{}] error!", dateStr, pattern), e);
        }
    }

    private static Date parse(String dateStr, DateTimeParser parser) {
        try {
            return parser.parse(dateStr);
        }
        catch (Exception e) {
            throw new DateException(StringCommand.format("Parse [{}] with format [{}] error!", dateStr, parser.getPattern()), e);
        }
    }

    public DateTime offsite(DateField datePart, int offsite) {
        Calendar cal = this.toCalendar();
        cal.add(datePart.getValue(), offsite);
        DateTime dt = this;
        if (!this.mutable) {
            dt = ObjectCommand.clone(this);
        }
        return dt.setTimeInternal(cal.getTimeInMillis());
    }

    public int getField(DateField field) {
        return this.getField(field.getValue());
    }

    public int getField(int field) {
        return this.toCalendar().get(field);
    }

    public DateTime setField(DateField field, int value) {
        return this.setField(field.getValue(), value);
    }

    public DateTime setField(int field, int value) {
        Calendar calendar = this.toCalendar();
        calendar.set(field, value);
        DateTime dt = this;
        if (!this.mutable) {
            dt = ObjectCommand.clone(this);
        }
        return dt.setTimeInternal(calendar.getTimeInMillis());
    }

    @Override
    public void setTime(long time) {
        if (!this.mutable) {
            throw new DateException("This is not a mutable object !");
        }
        super.setTime(time);
    }

    @Override
    public String toString() {
        return this.toString(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
    }

    public int year() {
        return this.getField(DateField.YEAR);
    }

    public int season() {
        return this.monthStartFromOne() / 3 + 1;
    }

    public PigSeason seasonEnum() {
        return PigSeason.of(this.season());
    }

    public int month() {
        return this.getField(DateField.MONTH);
    }

    public int monthStartFromOne() {
        return this.month() + 1;
    }

    public PigMonth monthEnum() {
        return PigMonth.of(this.month());
    }

    public int weekOfYear() {
        return this.getField(DateField.WEEK_OF_YEAR);
    }

    public int weekOfMonth() {
        return this.getField(DateField.WEEK_OF_MONTH);
    }

    public int dayOfMonth() {
        return this.getField(DateField.DAY_OF_MONTH);
    }

    public int dayOfWeek() {
        return this.getField(DateField.DAY_OF_WEEK);
    }

    public int dayOfWeekInMonth() {
        return this.getField(DateField.DAY_OF_WEEK_IN_MONTH);
    }

    public PigWeek dayOfWeekEnum() {
        return PigWeek.of(this.dayOfWeek());
    }

    public int hour(boolean is24HourClock) {
        return this.getField(is24HourClock ? DateField.HOUR_OF_DAY : DateField.HOUR);
    }

    public int minute() {
        return this.getField(DateField.MINUTE);
    }

    public int second() {
        return this.getField(DateField.SECOND);
    }

    public int millsecond() {
        return this.getField(DateField.MILLISECOND);
    }

    public boolean isAM() {
        return 0 == this.getField(DateField.AM_PM);
    }

    public boolean isPM() {
        return 1 == this.getField(DateField.AM_PM);
    }

    public boolean isLeapYear() {
        return DateTimeCommand.isLeapYear(this.year());
    }

    public Calendar toCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this);
        return cal;
    }

    public Calendar toCalendar(Locale locale) {
        Calendar cal = Calendar.getInstance(locale);
        cal.setTime(this);
        return cal;
    }

    public Calendar toCalendar(TimeZone zone) {
        return this.toCalendar(zone, Locale.getDefault(Locale.Category.FORMAT));
    }

    public Calendar toCalendar(TimeZone zone, Locale locale) {
        Calendar cal = Calendar.getInstance(zone, locale);
        cal.setTime(this);
        return cal;
    }

    public DateBetween between(Date date) {
        return new DateBetween(this, date);
    }

    public long between(Date date, DateUnit unit) {
        return new DateBetween(this, date).between(unit);
    }

    public String between(Date date, DateUnit unit, BetweenFormater.Level formatLevel) {
        return new DateBetween(this, date).toString(formatLevel);
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public DateTime setMutable(boolean mutable) {
        this.mutable = mutable;
        return this;
    }

    public String toString(String format) {
        return this.toString(DateTimeFormatter.getInstance(format));
    }

    public String toString(DateTimePrinter format) {
        return format.format(this);
    }

    public String toString(DateFormat format) {
        return format.format(this);
    }

    public String toMsStr() {
        return this.toString(DateStyle.EN_YYYY_MM_DD_HH_MM_SS_SSS.getValue());
    }

    private DateTime setTimeInternal(long time) {
        super.setTime(time);
        return this;
    }
}

