/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.date;

import org.gjgr.pig.chivalrous.core.date.DateTimeCommand;
import org.gjgr.pig.chivalrous.core.date.DateUnit;

public class TimeInterval {
    private long time;
    private boolean isNano;

    public TimeInterval() {
        this(false);
    }

    public TimeInterval(boolean isNano) {
        this.isNano = isNano;
        this.start();
    }

    public long start() {
        this.time = DateTimeCommand.current(this.isNano);
        return this.time;
    }

    public long intervalRestart() {
        long now = DateTimeCommand.current(this.isNano);
        long d = now - this.time;
        this.time = now;
        return d;
    }

    public TimeInterval restart() {
        this.time = DateTimeCommand.current(this.isNano);
        return this;
    }

    public long interval() {
        return DateTimeCommand.current(this.isNano) - this.time;
    }

    public long intervalMs() {
        return this.isNano ? this.interval() / 1000000L : this.interval();
    }

    public long intervalSecond() {
        return this.intervalMs() / DateUnit.SECOND.getMillis();
    }

    public long intervalMinute() {
        return this.intervalMs() / DateUnit.MINUTE.getMillis();
    }

    public long intervalHour() {
        return this.intervalMs() / DateUnit.HOUR.getMillis();
    }

    public long intervalDay() {
        return this.intervalMs() / DateUnit.DAY.getMillis();
    }

    public long intervalWeek() {
        return this.intervalMs() / DateUnit.WEEK.getMillis();
    }
}

