/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.date.format;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.gjgr.pig.chivalrous.core.date.format.DateTimeParser;
import org.gjgr.pig.chivalrous.core.date.format.DateTimePrinter;
import org.gjgr.pig.chivalrous.core.date.format.FormatCache;
import org.gjgr.pig.chivalrous.core.date.format.SimpleDateTimeParser;
import org.gjgr.pig.chivalrous.core.date.format.SimpleDateTimePrinter;

public class DateTimeFormatter
extends Format
implements DateTimeParser,
DateTimePrinter {
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    private static final long serialVersionUID = 8097890768636183236L;
    private static final FormatCache<DateTimeFormatter> cache = new FormatCache<DateTimeFormatter>(){

        @Override
        protected DateTimeFormatter createInstance(String pattern, TimeZone timeZone, Locale locale) {
            return new DateTimeFormatter(pattern, timeZone, locale);
        }
    };
    private final SimpleDateTimePrinter printer;
    private final SimpleDateTimeParser parser;

    protected DateTimeFormatter(String pattern, TimeZone timeZone, Locale locale) {
        this(pattern, timeZone, locale, null);
    }

    protected DateTimeFormatter(String pattern, TimeZone timeZone, Locale locale, Date centuryStart) {
        this.printer = new SimpleDateTimePrinter(pattern, timeZone, locale);
        this.parser = new SimpleDateTimeParser(pattern, timeZone, locale, centuryStart);
    }

    public static DateTimeFormatter getInstance() {
        return cache.getInstance();
    }

    public static DateTimeFormatter getInstance(String pattern) {
        return cache.getInstance(pattern, null, null);
    }

    public static DateTimeFormatter getInstance(String pattern, TimeZone timeZone) {
        return cache.getInstance(pattern, timeZone, null);
    }

    public static DateTimeFormatter getInstance(String pattern, Locale locale) {
        return cache.getInstance(pattern, null, locale);
    }

    public static DateTimeFormatter getInstance(String pattern, TimeZone timeZone, Locale locale) {
        return cache.getInstance(pattern, timeZone, locale);
    }

    public static DateTimeFormatter getDateInstance(int style) {
        return cache.getDateInstance(style, null, null);
    }

    public static DateTimeFormatter getDateInstance(int style, Locale locale) {
        return cache.getDateInstance(style, null, locale);
    }

    public static DateTimeFormatter getDateInstance(int style, TimeZone timeZone) {
        return cache.getDateInstance(style, timeZone, null);
    }

    public static DateTimeFormatter getDateInstance(int style, TimeZone timeZone, Locale locale) {
        return cache.getDateInstance(style, timeZone, locale);
    }

    public static DateTimeFormatter getTimeInstance(int style) {
        return cache.getTimeInstance(style, null, null);
    }

    public static DateTimeFormatter getTimeInstance(int style, Locale locale) {
        return cache.getTimeInstance(style, null, locale);
    }

    public static DateTimeFormatter getTimeInstance(int style, TimeZone timeZone) {
        return cache.getTimeInstance(style, timeZone, null);
    }

    public static DateTimeFormatter getTimeInstance(int style, TimeZone timeZone, Locale locale) {
        return cache.getTimeInstance(style, timeZone, locale);
    }

    public static DateTimeFormatter getDateTimeInstance(int dateStyle, int timeStyle) {
        return cache.getDateTimeInstance(dateStyle, timeStyle, (TimeZone)null, (Locale)null);
    }

    public static DateTimeFormatter getDateTimeInstance(int dateStyle, int timeStyle, Locale locale) {
        return cache.getDateTimeInstance(dateStyle, timeStyle, (TimeZone)null, locale);
    }

    public static DateTimeFormatter getDateTimeInstance(int dateStyle, int timeStyle, TimeZone timeZone) {
        return DateTimeFormatter.getDateTimeInstance(dateStyle, timeStyle, timeZone, null);
    }

    public static DateTimeFormatter getDateTimeInstance(int dateStyle, int timeStyle, TimeZone timeZone, Locale locale) {
        return cache.getDateTimeInstance(dateStyle, timeStyle, timeZone, locale);
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        return toAppendTo.append(this.printer.format(obj));
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return this.parser.parseObject(source, pos);
    }

    @Override
    public String format(long millis) {
        return this.printer.format(millis);
    }

    @Override
    public String format(Date date) {
        return this.printer.format(date);
    }

    @Override
    public String format(Calendar calendar) {
        return this.printer.format(calendar);
    }

    @Override
    public <B extends Appendable> B format(long millis, B buf) {
        return this.printer.format(millis, buf);
    }

    @Override
    public <B extends Appendable> B format(Date date, B buf) {
        return this.printer.format(date, buf);
    }

    @Override
    public <B extends Appendable> B format(Calendar calendar, B buf) {
        return this.printer.format(calendar, buf);
    }

    @Override
    public Date parse(String source) throws ParseException {
        return this.parser.parse(source);
    }

    @Override
    public Date parse(String source, ParsePosition pos) {
        return this.parser.parse(source, pos);
    }

    @Override
    public boolean parse(String source, ParsePosition pos, Calendar calendar) {
        return this.parser.parse(source, pos, calendar);
    }

    @Override
    public String getPattern() {
        return this.printer.getPattern();
    }

    @Override
    public TimeZone getTimeZone() {
        return this.printer.getTimeZone();
    }

    @Override
    public Locale getLocale() {
        return this.printer.getLocale();
    }

    public int getMaxLengthEstimate() {
        return this.printer.getMaxLengthEstimate();
    }

    public int hashCode() {
        return this.printer.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DateTimeFormatter)) {
            return false;
        }
        DateTimeFormatter other = (DateTimeFormatter)obj;
        return this.printer.equals(other.printer);
    }

    public String toString() {
        return "DateTimeFormatter[" + this.printer.getPattern() + "," + this.printer.getLocale() + "," + this.printer.getTimeZone().getID() + "]";
    }
}

