/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.dfa;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.gjgr.pig.chivalrous.core.dfa.WordTree;
import org.gjgr.pig.chivalrous.core.json.JsonCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.util.ThreadUtil;

public final class SensitiveUtil {
    public static final char DEFAULT_SEPARATOR = ',';
    private static WordTree sensitiveTree = new WordTree();

    private SensitiveUtil() {
    }

    public static boolean isInited() {
        return !sensitiveTree.isEmpty();
    }

    public static void init(final Collection<String> sensitiveWords, boolean isAsync) {
        if (isAsync) {
            ThreadUtil.execAsync(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    SensitiveUtil.init(sensitiveWords);
                    return true;
                }
            });
        } else {
            SensitiveUtil.init(sensitiveWords);
        }
    }

    public static void init(Collection<String> sensitiveWords) {
        sensitiveTree.clear();
        sensitiveTree.addWords(sensitiveWords);
    }

    public static void init(String sensitiveWords, char separator, boolean isAsync) {
        if (StringCommand.isNotBlank(sensitiveWords)) {
            SensitiveUtil.init(StringCommand.split(sensitiveWords, separator), isAsync);
        }
    }

    public static void init(String sensitiveWords, boolean isAsync) {
        SensitiveUtil.init(sensitiveWords, ',', isAsync);
    }

    public static boolean containsSensitive(String text) {
        return sensitiveTree.isMatch(text);
    }

    public static boolean containsSensitive(Object obj) {
        return sensitiveTree.isMatch(JsonCommand.string(obj));
    }

    public static String getFindedFirstSensitive(String text) {
        return sensitiveTree.match(text);
    }

    public static String getFindedFirstSensitive(Object obj) {
        return sensitiveTree.match(JsonCommand.string(obj));
    }

    public static List<String> getFindedAllSensitive(String text) {
        return sensitiveTree.matchAll(text);
    }

    public static List<String> getFindedAllSensitive(String text, boolean isDensityMatch, boolean isGreedMatch) {
        return sensitiveTree.matchAll(text, -1, isDensityMatch, isGreedMatch);
    }

    public static List<String> getFindedAllSensitive(Object bean) {
        return sensitiveTree.matchAll(JsonCommand.string(bean));
    }

    public static List<String> getFindedAllSensitive(Object bean, boolean isDensityMatch, boolean isGreedMatch) {
        return SensitiveUtil.getFindedAllSensitive(JsonCommand.string(bean), isDensityMatch, isGreedMatch);
    }
}

