/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.entity;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gjgr.pig.chivalrous.core.crypto.CryptoCommand;
import org.gjgr.pig.chivalrous.core.json.JsonCommand;
import org.gjgr.pig.chivalrous.core.lang.ClassCommand;
import org.gjgr.pig.chivalrous.core.lang.ObjectCommand;
import org.gjgr.pig.chivalrous.log.SystemLogger;

public class Message
implements Serializable,
Cloneable {
    protected String version;
    protected Integer code;
    protected Integer status;
    protected String type;
    protected String message;
    protected Object data;
    protected Object datum;
    protected Long timestamp;
    protected HashMap<String, Object> info = new HashMap();

    public static <T> T stringCast(String string, Class<T> clazz) {
        T object = null;
        try {
            object = JsonCommand.fromJson(string, clazz);
        }
        catch (Exception e) {
            try {
                object = Message.deserialize(string, clazz);
            }
            catch (Exception eee) {
                SystemLogger.error((String)"cast object failed in data about {}", (Object[])new Object[]{string});
            }
        }
        return object;
    }

    public static <T> T stringCastObject(String string, Class<T> clazz) {
        T object = null;
        try {
            object = JsonCommand.fromJson(string, clazz);
        }
        catch (Exception e) {
            try {
                object = JsonCommand.fromJson(CryptoCommand.base64DecodeString(string), clazz);
            }
            catch (Exception ee) {
                try {
                    object = Message.deserialize(string, clazz);
                }
                catch (Exception eee) {
                    SystemLogger.error((String)"cast object failed in data about {}", (Object[])new Object[]{string});
                }
            }
        }
        return object;
    }

    public static <T> T caseObject(String json, Class<T> clazz) {
        Message message = null;
        try {
            message = JsonCommand.fromJson(json, Message.class);
        }
        catch (Exception e) {
            message = JsonCommand.fromJson(CryptoCommand.base64DecodeString(json), Message.class);
        }
        T object = message.castObject(clazz);
        return object;
    }

    public static Object serialize(Object object) {
        if (object == null) {
            return null;
        }
        if (ClassCommand.isPrimitiveOrWrapper(object.getClass()) || ClassCommand.isPrimitiveWrapper(object.getClass())) {
            return object;
        }
        if (object instanceof String) {
            return object;
        }
        if (object instanceof Map) {
            return JsonCommand.json(object);
        }
        if (object instanceof List) {
            return JsonCommand.json(object);
        }
        if (object instanceof JsonObject) {
            return JsonCommand.json(object);
        }
        if (object instanceof JsonArray) {
            return JsonCommand.json(object);
        }
        if (object instanceof JsonPrimitive) {
            return JsonCommand.json(object);
        }
        Map result = null;
        try {
            result = JsonCommand.to(JsonCommand.toJson(object), LinkedHashMap.class);
            if (result == null) {
                SystemLogger.warn((String)"unsuppport the type of the object:{} in message parse.", (Object[])new Object[]{object});
                return object;
            }
            return JsonCommand.json(result);
        }
        catch (Exception e) {
            SystemLogger.debug((String)"not covert to json type. in object:{} in message parse.", (Object[])new Object[]{object});
            return object;
        }
    }

    public static <T> T deserialize(Object data, Class<T> clazz) {
        if (data != null && !data.equals("")) {
            String[] strings;
            String stringData = null;
            stringData = data.getClass().isPrimitive() || data instanceof String ? data.toString() : Message.serialize(data) + "";
            String[] t = null;
            boolean status = false;
            try {
                t = (String[])JsonCommand.to(stringData, clazz);
                if (t == null) {
                    if (ClassCommand.isPrimitiveOrWrapper(clazz) && ClassCommand.isPrimitiveWrapperArray(clazz)) {
                        try {
                            t = ObjectCommand.cast(clazz, data);
                        }
                        catch (Exception e) {
                            status = true;
                        }
                    } else if (clazz.isAssignableFrom(String.class)) {
                        t = stringData;
                    } else if (clazz.getComponentType().isAssignableFrom(String.class)) {
                        strings = new String[]{stringData};
                        t = strings;
                    } else {
                        status = true;
                    }
                }
            }
            catch (Exception e) {
                try {
                    t = (String[])ObjectCommand.cast(clazz, data);
                }
                catch (Exception ee) {
                    status = true;
                }
            }
            if (status) {
                if (clazz.isAssignableFrom(String.class)) {
                    return (T)data.toString();
                }
                if (clazz.isAssignableFrom(Integer.class)) {
                    return (T)new Integer(Integer.parseInt(data.toString()));
                }
                if (clazz.isAssignableFrom(Double.class)) {
                    return (T)new Double(Double.parseDouble(data.toString()));
                }
                if (clazz.isAssignableFrom(Float.class)) {
                    return (T)new Float(Float.parseFloat(data.toString()));
                }
                if (clazz.isAssignableFrom(Boolean.class)) {
                    return (T)new Boolean(Boolean.parseBoolean(data.toString()));
                }
                if (clazz.isAssignableFrom(Long.class)) {
                    return (T)new Long(Long.parseLong(data.toString()));
                }
                if (clazz.isAssignableFrom(Byte.class)) {
                    return (T)new Byte(Byte.parseByte(data.toString()));
                }
                if (clazz.isAssignableFrom(Short.class)) {
                    return (T)new Short(Short.parseShort(data.toString()));
                }
                if (clazz.getComponentType() != null && clazz.getComponentType().isAssignableFrom(String.class)) {
                    strings = new String[]{data.toString()};
                    return (T)strings;
                }
                if (ClassCommand.isPrimitiveWrapperArray(clazz) || ClassCommand.isPrimitiveArray(clazz)) {
                    Class<Comparable<Character>> type = clazz.getComponentType();
                    if (type.isAssignableFrom(Character.TYPE)) {
                        return (T)data.toString().toCharArray();
                    }
                    if (type.isAssignableFrom(Integer.TYPE)) {
                        Integer[] integers = new Integer[]{new Integer(Integer.parseInt(data.toString()))};
                        return (T)integers;
                    }
                    if (type.isAssignableFrom(Double.TYPE)) {
                        Double[] doubles = new Double[]{new Double(Double.parseDouble(data.toString()))};
                        return (T)doubles;
                    }
                    if (type.isAssignableFrom(Float.TYPE)) {
                        Float[] floats = new Float[]{new Float(Float.parseFloat(data.toString()))};
                        return (T)floats;
                    }
                    if (type.isAssignableFrom(Boolean.TYPE)) {
                        Boolean[] booleans = new Boolean[]{new Boolean(Boolean.parseBoolean(data.toString()))};
                        return (T)booleans;
                    }
                    if (clazz.isAssignableFrom(Long.TYPE)) {
                        Long[] longs = new Long[]{new Long(Long.parseLong(data.toString()))};
                        return (T)longs;
                    }
                    if (clazz.isAssignableFrom(Byte.TYPE)) {
                        Byte[] bytes = new Byte[]{new Byte(Byte.parseByte(data.toString()))};
                        return (T)bytes;
                    }
                    if (clazz.isAssignableFrom(Short.TYPE)) {
                        Short[] shorts = new Short[]{new Short(Short.parseShort(data.toString()))};
                        return (T)shorts;
                    }
                    SystemLogger.error((String)"could not parse the type {} about data {} for in message parse", (Object[])new Object[]{clazz, data});
                    throw new RuntimeException("could not covert class " + clazz + " data:" + data);
                }
                SystemLogger.error((String)"could not parse the type {} about data {} in message parse", (Object[])new Object[]{clazz, data});
                throw new RuntimeException("could not covert class " + clazz + " data:" + data);
            }
            return (T)t;
        }
        return null;
    }

    public <T> T castObject(Class<T> clazz) {
        T object = null;
        if (this.getDatum() != null) {
            try {
                object = JsonCommand.fromJson(this.getDatum().toString(), clazz);
            }
            catch (Exception e) {
                SystemLogger.error((String)"cast object failed in datum about {}", (Object[])new Object[]{this});
            }
        } else if (this.getData() != null) {
            object = Message.stringCastObject(this.getData().toString(), clazz);
        }
        return object;
    }

    public <T> T serializeData() {
        return (T)Message.serialize(this.data);
    }

    public <T> T serializeDatum() {
        return (T)Message.serialize(this.datum);
    }

    public <T> T dataDeserialize(Class<T> clazz) {
        return Message.deserialize(this.data, clazz);
    }

    public <T> T datumDeserialize(Class<T> clazz) {
        return Message.deserialize(this.datum, clazz);
    }

    public <T> T deserializeData(Class<T> clazz) {
        try {
            return Message.deserialize(this.data, clazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> T deserializeDatum(Class<T> clazz) {
        try {
            return Message.deserialize(this.datum, clazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getVersion() {
        return this.version;
    }

    public Message setVersion(String version) {
        this.version = version;
        return this;
    }

    public String key(String prefix) {
        return prefix + ":" + this.key();
    }

    public String key(String prefix, String suffix) {
        return prefix + ":" + this.key() + ":" + suffix;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String key() {
        String key = null;
        if (this.getCode() != null) {
            if (this.getType() == null) throw new RuntimeException("did not define the code or type could not generate key.");
            if (this.getVersion() == null) return this.getCode() + ":" + this.getType();
            return this.getCode() + ":" + this.getType() + ":" + this.getVersion();
        }
        if (this.getType() == null) throw new RuntimeException("did not define the code or type could not generate key.");
        if (this.getVersion() == null) return this.getType();
        return this.getType() + ":" + this.getVersion();
    }

    public HashMap<String, Object> getInfo() {
        return this.info;
    }

    public Message setInfo(HashMap<String, Object> info) {
        this.info = info;
        return this;
    }

    public Integer getCode() {
        return this.code;
    }

    public Message setCode(Integer code) {
        this.code = code;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public Message setType(String type) {
        this.type = type;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public Message setMessage(String message) {
        this.message = message;
        return this;
    }

    public Object getDatum() {
        return this.datum;
    }

    public Message setDatum(Object datum) {
        this.datum = datum;
        return this;
    }

    public Object getData() {
        return this.data;
    }

    public Message setData(Object data) {
        this.data = data;
        return this;
    }

    public JsonObject dataOrDefault() {
        if (this.data == null) {
            this.data = new JsonObject();
            return (JsonObject)this.data;
        }
        if (this.data instanceof JsonObject) {
            return (JsonObject)this.data;
        }
        return null;
    }

    public JsonObject outData() {
        if (this.data == null) {
            this.data = new JsonObject();
        } else if (this.data instanceof JsonObject) {
            return (JsonObject)this.data;
        }
        return null;
    }

    public String json() {
        String string = JsonCommand.json(this);
        JsonObject jsonObject = JsonCommand.jsonObject(string);
        if (jsonObject.get("data").isJsonNull()) {
            jsonObject.remove("data");
        }
        if (jsonObject.get("message").isJsonNull()) {
            jsonObject.remove("message");
        }
        if (this.info.size() == 0 || jsonObject.get("info").isJsonNull()) {
            jsonObject.remove("info");
        }
        if (jsonObject.get("datum").isJsonNull()) {
            jsonObject.remove("datum");
        }
        if (jsonObject.get("version").isJsonNull()) {
            jsonObject.remove("version");
        }
        if (jsonObject.get("code").isJsonNull()) {
            jsonObject.remove("code");
        }
        if (jsonObject.get("type").isJsonNull()) {
            jsonObject.remove("type");
        }
        if (jsonObject.get("timestamp").isJsonNull()) {
            jsonObject.remove("timestamp");
        }
        if (jsonObject.get("status").isJsonNull()) {
            jsonObject.remove("status");
        }
        return jsonObject.toString();
    }

    public String toString() {
        String s = null;
        if (this.data != null) {
            s = this.data.toString();
        }
        String ss = this.datum != null && this.data != null ? "{\"code\":" + this.code + "\",\"type\":" + this.type + "\",\"message\":" + this.message + ",\"datum\":" + this.datum.toString() + ",\"data\":" + s + "}" : (this.data != null ? "{\"code\":" + this.code + "\",\"type\":" + this.type + "\",\"message\":" + this.message + ",\"data\":" + this.data.toString() + "}" : (this.data != null && this.datum != null ? "{\"code\":" + this.code + "\",\"type\":" + this.type + "\",\"message\":" + this.message + ",\"datum\":" + this.datum.toString() + "}" : "{\"code\":" + this.code + "\",\"type\":" + this.type + "\",\"message\":" + this.message + "}"));
        return ss;
    }

    public String toString(String data, String info) {
        String s = data != null && info != null ? "{\"code\":" + this.code + "\",\"type\":" + this.type + "\",\"message\":" + this.message + ",\"datum\":" + data + ",\"data\":" + info + "}" : (info != null ? "{\"code\":" + this.code + "\",\"type\":" + this.type + "\",\"message\":" + this.message + ",\"data\":" + info + "}" : "{\"code\":" + this.code + "\",\"type\":" + this.type + "\",\"message\":" + this.message + ",\"datum\":" + data + "}");
        return s;
    }
}

