/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.entity;

import java.util.HashMap;
import org.gjgr.pig.chivalrous.core.entity.Message;
import org.gjgr.pig.chivalrous.core.entity.MessageStatus;

public class MessageBuilder {
    public static Message build() {
        Message message = new Message();
        return message;
    }

    public static Message message(Message message, Object data, HashMap info, Object datum) {
        message.setData(data);
        if (info != null) {
            message.setInfo(info);
        }
        message.setDatum(datum);
        return message;
    }

    public static Message message(int code) {
        return MessageStatus.message(code);
    }

    public static Message message(int code, String type, String str, Object data, Object datum, HashMap info) {
        Message message = new Message();
        message.setCode(code);
        message.setType(type);
        if (type == null || str == null) {
            MessageStatus httpStatus;
            try {
                httpStatus = MessageStatus.valueOf(code);
            }
            catch (Exception e) {
                httpStatus = MessageStatus.valueOf(500);
            }
            if (type == null) {
                message.setType("notify");
            }
            message.setMessage(httpStatus.getReasonPhrase());
        } else {
            message.setMessage(str);
        }
        return MessageBuilder.message(message, data, info, datum);
    }

    public static Message message(int code, String type, String message, Object data, HashMap info) {
        return MessageBuilder.message(code, type, message, data, null, info);
    }

    public static Message message(int code, String type, String message, Object data, Object datum) {
        return MessageBuilder.message(code, type, message, data, datum, null);
    }

    public static Message message(int code, String type, String message, Object data) {
        return MessageBuilder.message(code, type, message, data, null, null);
    }

    public static Message message(int code, Object data) {
        String type = "info";
        String message = "success";
        if (code >= 300) {
            type = "debug";
        }
        return MessageBuilder.message(code, type, message, data, null, null);
    }

    public static Message message(int code, String type, String message) {
        return MessageBuilder.message(code, type, message, null, null, null);
    }

    public static Message message(int code, String type) {
        return MessageBuilder.message(code, type, null, null, null, null);
    }

    public static Message info(int code) {
        return MessageBuilder.message(code, "info");
    }

    public static Message warn(int code) {
        return MessageBuilder.message(code, "warn");
    }

    public static Message error(int code) {
        return MessageBuilder.message(code, "error");
    }

    public static Message info(int code, String message) {
        return MessageBuilder.message(code, "info", message);
    }

    public static Message warn(int code, String message) {
        return MessageBuilder.message(code, "warn", message);
    }

    public static Message error(int code, String message) {
        return MessageBuilder.message(code, "error", message);
    }

    public static Message exception(int code, String message) {
        return MessageBuilder.message(code, "exception", message);
    }

    public static Message message(MessageStatus messageStatus) {
        Message message = new Message();
        if (messageStatus == null) {
            message.setCode(0);
            message.setType("info");
            message.setMessage("^_^");
        } else {
            int i = messageStatus.value();
            message.setCode(i);
            message.setMessage(messageStatus.getReasonPhrase());
            message.setType(messageStatus.type());
        }
        return message;
    }
}

