/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.exceptions;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Map;
import org.gjgr.pig.chivalrous.core.io.stream.FastByteArrayOutputStream;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;

public final class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static String getMessage(Throwable e) {
        return StringCommand.format("{}: {}", e.getClass().getSimpleName(), e.getMessage());
    }

    public static RuntimeException wrapRuntime(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new RuntimeException(throwable);
    }

    public static Throwable unwrap(Throwable wrapped) {
        Throwable unwrapped = wrapped;
        while (true) {
            if (unwrapped instanceof InvocationTargetException) {
                unwrapped = ((InvocationTargetException)unwrapped).getTargetException();
                continue;
            }
            if (!(unwrapped instanceof UndeclaredThrowableException)) break;
            unwrapped = ((UndeclaredThrowableException)unwrapped).getUndeclaredThrowable();
        }
        return unwrapped;
    }

    public static StackTraceElement[] getStackElements() {
        return new Throwable().getStackTrace();
    }

    public static String stacktraceToOneLineString(Throwable throwable) {
        return ExceptionUtil.stacktraceToOneLineString(throwable, 3000);
    }

    public static String stacktraceToOneLineString(Throwable throwable, int limit) {
        HashMap<Character, String> replaceCharToStrMap = new HashMap<Character, String>();
        replaceCharToStrMap.put(Character.valueOf('\r'), " ");
        replaceCharToStrMap.put(Character.valueOf('\n'), " ");
        replaceCharToStrMap.put(Character.valueOf('\b'), " ");
        return ExceptionUtil.stacktraceToString(throwable, limit, replaceCharToStrMap);
    }

    public static String stacktraceToString(Throwable throwable) {
        return ExceptionUtil.stacktraceToString(throwable, 3000);
    }

    public static String stacktraceToString(Throwable throwable, int limit) {
        return ExceptionUtil.stacktraceToString(throwable, limit, null);
    }

    public static String stacktraceToString(Throwable throwable, int limit, Map<Character, String> replaceCharToStrMap) {
        FastByteArrayOutputStream baos = new FastByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(baos));
        String exceptionStr = baos.toString();
        int length = exceptionStr.length();
        if (limit > 0 && limit < length) {
            length = limit;
        }
        if (CollectionCommand.isNotEmpty(replaceCharToStrMap)) {
            StringBuilder sb = StringCommand.builder();
            for (int i = 0; i < length; ++i) {
                char c = exceptionStr.charAt(i);
                String value = replaceCharToStrMap.get(Character.valueOf(c));
                if (null != value) {
                    sb.append(value);
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return exceptionStr;
    }
}

