/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.io.file;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.net.ssl.HttpsURLConnection;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.io.exception.IORuntimeException;
import org.gjgr.pig.chivalrous.core.io.file.FileReader;
import org.gjgr.pig.chivalrous.core.io.file.FileTypeUtil;
import org.gjgr.pig.chivalrous.core.io.file.FileWriter;
import org.gjgr.pig.chivalrous.core.io.file.download.DirectDownloader;
import org.gjgr.pig.chivalrous.core.io.file.download.DownloadListener;
import org.gjgr.pig.chivalrous.core.io.file.download.DownloadTask;
import org.gjgr.pig.chivalrous.core.io.file.download.HttpConnector;
import org.gjgr.pig.chivalrous.core.io.resource.LocationCommand;
import org.gjgr.pig.chivalrous.core.io.stream.BOMInputStream;
import org.gjgr.pig.chivalrous.core.io.stream.StreamCommand;
import org.gjgr.pig.chivalrous.core.lang.ArrayCommand;
import org.gjgr.pig.chivalrous.core.lang.AssertCommand;
import org.gjgr.pig.chivalrous.core.lang.ClassCommand;
import org.gjgr.pig.chivalrous.core.lang.Nullable;
import org.gjgr.pig.chivalrous.core.lang.ObjectCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.net.UriBuilder;
import org.gjgr.pig.chivalrous.core.net.UriCommand;
import org.gjgr.pig.chivalrous.core.nio.CharsetCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileCommand {
    public static final String CLASS_EXT = ".class";
    public static final String JAR_FILE_EXT = ".jar";
    public static final String JAR_PATH_EXT = ".jar!";
    public static final String PATH_FILE_PRE = "file:";
    public static final int BUFFER_SIZE = 131072;
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String JAR_URL_PREFIX = "jar:";
    public static final String WAR_URL_PREFIX = "war:";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_WAR = "war";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String URL_PROTOCOL_VFSFILE = "vfsfile";
    public static final String URL_PROTOCOL_VFS = "vfs";
    public static final String JAR_FILE_EXTENSION = ".jar";
    public static final String JAR_URL_SEPARATOR = "!/";
    public static final String WAR_URL_SEPARATOR = "*/";
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final int RETRY_SLEEP_MILLIS = 10;
    private static final String USER_DIR_KEY = "user.dir";
    private static final File USER_DIR = new File(System.getProperty("user.dir"));
    private static final char EXTENSION_SEPARATOR = '.';
    private static final String FOLDER_SEPARATOR = "/";
    private static File defaultTempDir;
    private static Thread shutdownHook;
    private static boolean windowsOs;
    private static Logger logger;

    private FileCommand() {
    }

    public static boolean deleteRecursively(@Nullable File root) {
        if (root == null) {
            return false;
        }
        try {
            return FileCommand.deleteRecursively(root.toPath());
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean deleteRecursively(@Nullable Path root) throws IOException {
        if (root == null) {
            return false;
        }
        if (!Files.exists(root, new LinkOption[0])) {
            return false;
        }
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
        return true;
    }

    public static void copyRecursively(File src, File dest) throws IOException {
        AssertCommand.notNull(src, "Source File must not be null");
        AssertCommand.notNull(dest, "Destination File must not be null");
        FileCommand.copyRecursively(src.toPath(), dest.toPath());
    }

    public static void copyRecursively(final Path src, final Path dest) throws IOException {
        AssertCommand.notNull(src, "Source Path must not be null");
        AssertCommand.notNull(dest, "Destination Path must not be null");
        BasicFileAttributes srcAttr = Files.readAttributes(src, BasicFileAttributes.class, new LinkOption[0]);
        if (srcAttr.isDirectory()) {
            Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Files.createDirectories(dest.resolve(src.relativize(dir)), new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.copy(file, dest.resolve(src.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }
            });
        } else if (srcAttr.isRegularFile()) {
            Files.copy(src, dest, new CopyOption[0]);
        } else {
            throw new IllegalArgumentException("Source File must denote a directory or file");
        }
    }

    public static File[] ls(String path) {
        if (path == null) {
            return null;
        }
        File file = FileCommand.file(path = LocationCommand.getAbsolutePath(path));
        if (file.isDirectory()) {
            return file.listFiles();
        }
        throw new IORuntimeException(StringCommand.format("Path [{}] is not directory!", path));
    }

    public static InputStream file(Class clazz, String location) {
        InputStream inputStream = null;
        String path = location;
        boolean status = false;
        try {
            try {
                inputStream = FileCommand.bufferedInputStream(path);
            }
            catch (Exception e) {
                path = LocationCommand.userDir();
                path = path + File.separator + location;
                try {
                    inputStream = FileCommand.bufferedInputStream(path);
                }
                catch (Exception ee) {
                    path = LocationCommand.userDir();
                    path = path + location;
                    try {
                        inputStream = FileCommand.bufferedInputStream(path);
                    }
                    catch (Exception eee) {
                        inputStream = clazz.getResourceAsStream(location);
                        status = true;
                    }
                }
            }
            if (inputStream == null) {
                inputStream = clazz.getResourceAsStream(location);
                status = true;
            }
            if (inputStream == null && status && !location.startsWith(FOLDER_SEPARATOR)) {
                inputStream = clazz.getResourceAsStream(File.separator + location);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return inputStream;
    }

    public static List<File> lsFileList(String path) {
        List<File> files = null;
        files = FileCommand.isExist(path) ? Arrays.asList(FileCommand.lsFile(path)) : new ArrayList<File>();
        return files;
    }

    public static File[] dir(String path) {
        File[] files = FileCommand.ls(path);
        ArrayList<File> dirs = new ArrayList<File>();
        for (File file : files) {
            if (!FileCommand.isDirectory(file)) continue;
            dirs.add(file);
        }
        if (dirs.size() > 0) {
            return dirs.toArray(new File[dirs.size()]);
        }
        return null;
    }

    public static File[] lsFile(String path) {
        File[] files = FileCommand.ls(path);
        ArrayList<File> nodirs = new ArrayList<File>();
        for (File file : files) {
            if (!FileCommand.isFile(file)) continue;
            nodirs.add(file);
        }
        if (nodirs.size() > 0) {
            return nodirs.toArray(new File[nodirs.size()]);
        }
        return null;
    }

    public static boolean isEmpty(File file) {
        if (null == file) {
            return true;
        }
        if (file.isDirectory()) {
            String[] subFiles = file.list();
            if (ArrayCommand.isEmpty(subFiles)) {
                return true;
            }
        } else if (file.isFile()) {
            return file.length() <= 0L;
        }
        return false;
    }

    public static boolean isNotEmpty(File file) {
        return false == FileCommand.isEmpty(file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDirEmpty(Path dirPath) {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(dirPath);){
            boolean bl = false == dirStream.iterator().hasNext();
            return bl;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean isDirEmpty(File dir) {
        return FileCommand.isDirEmpty(dir.toPath());
    }

    public static List<File> loopFiles(File file, FileFilter fileFilter) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (file == null) {
            return fileList;
        }
        if (!file.exists()) {
            return fileList;
        }
        if (file.isDirectory()) {
            for (File tmp : file.listFiles()) {
                fileList.addAll(FileCommand.loopFiles(tmp, fileFilter));
            }
        } else if (null == fileFilter || fileFilter.accept(file)) {
            fileList.add(file);
        }
        return fileList;
    }

    public static List<File> loopFiles(File file) {
        return FileCommand.loopFiles(file, null);
    }

    public static List<String> listFileNames(String path) {
        if (path == null) {
            return null;
        }
        if (!(path = LocationCommand.getAbsolutePath(path)).endsWith(String.valueOf('/'))) {
            path = path + '/';
        }
        ArrayList<String> paths = new ArrayList<String>();
        int index = path.lastIndexOf(JAR_PATH_EXT);
        try {
            if (index == -1) {
                File[] files;
                for (File file : files = FileCommand.ls(path)) {
                    if (!file.isFile()) continue;
                    paths.add(file.getName());
                }
            } else {
                String jarPath = path.substring(0, index += ".jar".length());
                String subPath = path.substring(index + 2);
                for (JarEntry entry : Collections.list(new JarFile(jarPath).entries())) {
                    String nameSuffix;
                    String name = entry.getName();
                    if (!name.startsWith(subPath) || (nameSuffix = StringCommand.removePrefix(name, subPath)).contains(String.valueOf('/'))) continue;
                    paths.add(nameSuffix);
                }
            }
        }
        catch (Exception e) {
            throw new IORuntimeException(StringCommand.format("Can not read file path of [{}]", path), e);
        }
        return paths;
    }

    public static File file(String path) {
        if (StringCommand.isBlank(path)) {
            throw new NullPointerException("File path is blank!" + path);
        }
        return new File(LocationCommand.getAbsolutePath(path));
    }

    public static File file(String parent, String path) {
        if (StringCommand.isBlank(path)) {
            throw new NullPointerException("File path is blank!" + path);
        }
        return new File(parent, path);
    }

    public static File file(File parent, String path) {
        if (StringCommand.isBlank(path)) {
            throw new NullPointerException("File path is blank!" + path);
        }
        return new File(parent, path);
    }

    public static File file(URI uri) {
        if (uri == null) {
            throw new NullPointerException("File uri is null!");
        }
        return new File(uri);
    }

    public static File file(URL url) {
        return new File(UriCommand.toURI(url));
    }

    public static boolean isExist(String path) {
        return path == null ? false : new File(path).exists();
    }

    public static boolean isExist(File file) {
        return file == null ? false : file.exists();
    }

    public static boolean isExist(String directory, String regexp) {
        File file = new File(directory);
        if (!file.exists()) {
            return false;
        }
        String[] fileList = file.list();
        if (fileList == null) {
            return false;
        }
        for (String fileName : fileList) {
            if (!fileName.matches(regexp)) continue;
            return true;
        }
        return false;
    }

    public static Date lastModifiedTime(File file) {
        if (!FileCommand.isExist(file)) {
            return null;
        }
        return new Date(file.lastModified());
    }

    public static Date lastModifiedTime(String path) {
        return FileCommand.lastModifiedTime(new File(path));
    }

    public static long size(File file) {
        AssertCommand.notNull(file, "file argument is null !");
        if (!file.exists()) {
            throw new IllegalArgumentException(StringCommand.format("File [{}] not isExist !", file.getAbsolutePath()));
        }
        if (file.isDirectory()) {
            long size = 0L;
            File[] subFiles = file.listFiles();
            if (ArrayCommand.isEmpty(subFiles)) {
                return 0L;
            }
            for (int i = 0; i < subFiles.length; ++i) {
                size += FileCommand.size(subFiles[i]);
            }
            return size;
        }
        return file.length();
    }

    public static boolean newerThan(File file, File reference) {
        if (null == file || !reference.exists()) {
            return true;
        }
        return FileCommand.newerThan(file, reference.lastModified());
    }

    public static boolean newerThan(File file, long timeMillis) {
        if (null == file || !file.exists()) {
            return false;
        }
        return file.lastModified() > timeMillis;
    }

    public static File touch(String fullFilePath) throws IORuntimeException {
        if (fullFilePath == null) {
            return null;
        }
        return FileCommand.touch(FileCommand.file(fullFilePath));
    }

    public static File touch(File file) {
        if (null == file) {
            return null;
        }
        if (!file.exists()) {
            FileCommand.mkParentDirs(file);
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                throw new IORuntimeException(e);
            }
        }
        return file;
    }

    public static File touch(File parent, String path) throws IOException {
        return FileCommand.touch(FileCommand.file(parent, path));
    }

    public static File touch(String parent, String path) throws IOException {
        return FileCommand.touch(FileCommand.file(parent, path));
    }

    public static File mkParentDirs(File file) {
        File parentFile = file.getParentFile();
        if (null != parentFile && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        return parentFile;
    }

    public static File mkParentDirs(String path) {
        if (path == null) {
            return null;
        }
        return FileCommand.mkParentDirs(FileCommand.file(path));
    }

    public static boolean del(String fullFileOrDirPath) throws IOException {
        return FileCommand.del(FileCommand.file(fullFileOrDirPath));
    }

    public static boolean del(File file) throws IOException {
        if (file == null || !file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File childFile : files = file.listFiles()) {
                boolean isOk = FileCommand.del(childFile);
                if (isOk) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static File mkdir(String dirPath) {
        if (dirPath == null) {
            return null;
        }
        File dir = FileCommand.file(dirPath);
        return FileCommand.mkdir(dir);
    }

    public static File mkdir(File dir) {
        if (dir == null) {
            return null;
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static File createTempFile(File dir) throws IOException {
        return FileCommand.createTempFile("hutool", null, dir, true);
    }

    public static File createTempFile(File dir, boolean isReCreat) throws IOException {
        return FileCommand.createTempFile("hutool", null, dir, isReCreat);
    }

    public static File createTempFile(String prefix, String suffix, File dir, boolean isReCreat) throws IOException {
        int exceptionsCount = 0;
        while (true) {
            try {
                File file = File.createTempFile(prefix, suffix, dir).getCanonicalFile();
                if (isReCreat) {
                    file.delete();
                    file.createNewFile();
                }
                return file;
            }
            catch (IOException ioex) {
                if (++exceptionsCount < 50) continue;
                throw ioex;
            }
            break;
        }
    }

    public static File copyFile(String src, String dest, StandardCopyOption ... options) throws IOException {
        AssertCommand.notBlank(src, "Source File path is blank !");
        AssertCommand.notNull(src, "Destination File path is null !");
        return FileCommand.copyFile(Paths.get(src, new String[0]), Paths.get(dest, new String[0]), options).toFile();
    }

    public static File copyFile(File src, File dest, StandardCopyOption ... options) throws IOException {
        AssertCommand.notNull(src, "Source File is null !");
        if (!src.exists()) {
            throw new FileNotFoundException("File not isExist: " + src);
        }
        AssertCommand.notNull(dest, "Destination File or directiory is null !");
        if (FileCommand.equals(src, dest)) {
            throw new IOException("Files '" + src + "' and '" + dest + "' are equal");
        }
        Path srcPath = src.toPath();
        Path destPath = dest.isDirectory() ? dest.toPath().resolve(srcPath.getFileName()) : dest.toPath();
        return Files.copy(srcPath, destPath, (CopyOption[])options).toFile();
    }

    public static Path copyFile(Path src, Path dest, StandardCopyOption ... options) throws IOException {
        AssertCommand.notNull(src, "Source File is null !");
        AssertCommand.notNull(dest, "Destination File or directiory is null !");
        Path destPath = dest.toFile().isDirectory() ? dest.resolve(src.getFileName()) : dest;
        return Files.copy(src, destPath, (CopyOption[])options);
    }

    public static File copy(String srcPath, String destPath, boolean isOverride) throws IOException {
        return FileCommand.copy(FileCommand.file(srcPath), FileCommand.file(destPath), isOverride);
    }

    public static File copy(File src, File dest, boolean isOverride) throws IOException {
        AssertCommand.notNull(src, "Source File is null !");
        if (!src.exists()) {
            throw new FileNotFoundException("File not isExist: " + src);
        }
        AssertCommand.notNull(dest, "Destination File or directiory is null !");
        if (FileCommand.equals(src, dest)) {
            throw new IOException("Files '" + src + "' and '" + dest + "' are equal");
        }
        if (src.isDirectory()) {
            FileCommand.internalCopyDir(src, dest, isOverride);
        } else {
            FileCommand.internalCopyFile(src, dest, isOverride);
        }
        return dest;
    }

    private static void internalCopyDir(File src, File dest, boolean isOverride) throws IOException {
        if (!dest.exists()) {
            dest.mkdirs();
        } else if (dest.isFile()) {
            throw new IOException(StringCommand.format("Src [{}] is a directory but dest [{}] is a file!", src.getPath(), dest.getPath()));
        }
        String[] files = src.list();
        if (files != null) {
            for (String file : files) {
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                if (src.isDirectory()) {
                    FileCommand.internalCopyDir(srcFile, destFile, isOverride);
                    continue;
                }
                FileCommand.internalCopyFile(srcFile, destFile, isOverride);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void internalCopyFile(File src, File dest, boolean isOverride) throws IOException {
        if (!dest.exists()) {
            FileCommand.touch(dest);
        } else if (dest.isDirectory()) {
            dest = new File(dest, src.getName());
        } else if (!isOverride) {
            return;
        }
        FileInputStream input = new FileInputStream(src);
        FileOutputStream output = new FileOutputStream(dest);
        try {
            IoCommand.copy(input, output);
        }
        finally {
            IoCommand.close(output);
            IoCommand.close(input);
        }
        if (src.length() != dest.length()) {
            throw new IOException("Copy file failed of '" + src + "' to '" + dest + "' due to different sizes");
        }
    }

    public static void move(File src, File dest, boolean isOverride) throws IOException {
        if (!src.exists()) {
            throw new FileNotFoundException("File already isExist: " + src);
        }
        if (src.isDirectory() && dest.isFile()) {
            throw new IOException(StringCommand.format("Can not move directory [{}] to file [{}]", src, dest));
        }
        if (isOverride && dest.isFile()) {
            dest.delete();
        }
        if (src.isFile() && dest.isDirectory()) {
            dest = new File(dest, src.getName());
        }
        if (!src.renameTo(dest)) {
            try {
                FileCommand.copy(src, dest, isOverride);
                src.delete();
            }
            catch (Exception e) {
                throw new IOException(StringCommand.format("Move [{}] to [{}] failed!", src, dest), e);
            }
        }
    }

    public static boolean isDirectory(String path) {
        return path == null ? false : FileCommand.file(path).isDirectory();
    }

    public static boolean isDirectory(File file) {
        return file == null ? false : file.isDirectory();
    }

    public static boolean isFile(String path) {
        return path == null ? false : FileCommand.file(path).isFile();
    }

    public static boolean isFile(File file) {
        return file == null ? false : file.isFile();
    }

    public static boolean equals(File file1, File file2) {
        try {
            file1 = file1.getCanonicalFile();
            file2 = file2.getCanonicalFile();
        }
        catch (IOException ignore) {
            return false;
        }
        return file1.equals(file2);
    }

    public static int indexOfLastSeparator(String filePath) {
        int lastWindowsPos;
        if (filePath == null) {
            return -1;
        }
        int lastUnixPos = filePath.lastIndexOf(47);
        return lastUnixPos >= (lastWindowsPos = filePath.lastIndexOf(92)) ? lastUnixPos : lastWindowsPos;
    }

    public static boolean isModifed(File file, long lastModifyTime) {
        if (null == file || !file.exists()) {
            return true;
        }
        return file.lastModified() != lastModifyTime;
    }

    public static String subPath(String rootDir, String filePath) {
        return FileCommand.subPath(rootDir, FileCommand.file(filePath));
    }

    public static String subPath(String rootDir, File file) {
        if (StringCommand.isEmpty(rootDir)) {
            // empty if block
        }
        String subPath = null;
        try {
            subPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (StringCommand.isNotEmpty(rootDir) && StringCommand.isNotEmpty(subPath)) {
            rootDir = LocationCommand.normalize(rootDir);
            if ((subPath = LocationCommand.normalize(subPath)) != null && subPath.toLowerCase().startsWith(subPath.toLowerCase())) {
                subPath = subPath.substring(rootDir.length() + 1);
            }
        }
        return subPath;
    }

    public static String mainName(File file) {
        if (file.isDirectory()) {
            return file.getName();
        }
        return FileCommand.mainName(file.getName());
    }

    public static String mainName(String fileName) {
        if (StringCommand.isBlank(fileName) || !fileName.contains(".")) {
            return fileName;
        }
        return StringCommand.subPre(fileName, fileName.lastIndexOf("."));
    }

    public static String extName(File file) {
        if (null == file) {
            return null;
        }
        if (file.isDirectory()) {
            return null;
        }
        return FileCommand.extName(file.getName());
    }

    public static String extName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        String ext = fileName.substring(index + 1);
        return ext.contains(String.valueOf('/')) || ext.contains(String.valueOf('\\')) ? "" : ext;
    }

    @Nullable
    public static String filename(@Nullable String path) {
        if (path == null) {
            return null;
        }
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        return separatorIndex != -1 ? path.substring(separatorIndex + 1) : path;
    }

    @Nullable
    public static String fileExtension(@Nullable String path) {
        if (path == null) {
            return null;
        }
        int extIndex = path.lastIndexOf(46);
        if (extIndex == -1) {
            return null;
        }
        int folderIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (folderIndex > extIndex) {
            return null;
        }
        return path.substring(extIndex + 1);
    }

    public static String stripFilenameExtension(String path) {
        int extIndex = path.lastIndexOf(46);
        if (extIndex == -1) {
            return path;
        }
        int folderIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (folderIndex > extIndex) {
            return path;
        }
        return path.substring(0, extIndex);
    }

    public static boolean pathEndsWith(File file, String suffix) {
        return file.getPath().toLowerCase().endsWith(suffix);
    }

    public static String fileExtension(File file) {
        try {
            return FileTypeUtil.getType(file);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static InputStream inputStream(File file) throws FileNotFoundException {
        return FileCommand.bufferedInputStream(file);
    }

    public static InputStream inputStream(URL url) throws IOException {
        return url.openStream();
    }

    public static InputStream inputStream(String path) throws RuntimeException {
        try {
            return FileCommand.inputStream(new URL(path));
        }
        catch (Exception e) {
            try {
                return FileCommand.inputStream(FileCommand.file(path));
            }
            catch (FileNotFoundException e1) {
                throw new RuntimeException("unknown path exception, did not know path " + path);
            }
        }
    }

    public static BufferedInputStream bufferedInputStream(File file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    public static BufferedInputStream bufferedInputStream(String path) throws FileNotFoundException {
        return FileCommand.bufferedInputStream(FileCommand.file(path));
    }

    public static BOMInputStream bomInputStream(File file) throws FileNotFoundException {
        return new BOMInputStream(new FileInputStream(file));
    }

    public static BufferedReader bufferedReaderWithUTF8(File file) throws IOException {
        return FileCommand.bufferedReader(file, CharsetCommand.CHARSET_UTF_8);
    }

    public static BufferedReader bufferedReaderWithUTF8(String path) throws IOException {
        return FileCommand.bufferedReader(path, CharsetCommand.CHARSET_UTF_8);
    }

    public static BufferedReader bufferedReader(File file, String charsetName) throws IOException {
        return IoCommand.getReader((InputStream)FileCommand.bufferedInputStream(file), charsetName);
    }

    public static BufferedReader bufferedReader(File file, Charset charset) throws IOException {
        return IoCommand.getReader((InputStream)FileCommand.bufferedInputStream(file), charset);
    }

    public static BufferedReader bufferedReader(String path, String charsetName) throws IOException {
        return FileCommand.bufferedReader(FileCommand.file(path), charsetName);
    }

    public static BufferedReader bufferedReader(String path, Charset charset) throws IOException {
        return FileCommand.bufferedReader(FileCommand.file(path), charset);
    }

    public static byte[] readBytes(File file) throws IORuntimeException {
        return FileReader.create(file).readBytes();
    }

    public static String readUtf8String(File file) {
        return FileCommand.readString(file, CharsetCommand.CHARSET_UTF_8);
    }

    public static String readUtfResource(String name) {
        String data = null;
        try {
            data = FileCommand.readUtf8String(LocationCommand.pathValue(name));
        }
        catch (Exception e) {
            FileCommand.readUtfResource(name, ClassLoader.getSystemClassLoader());
        }
        return data;
    }

    public static String readUtfResource(String name, ClassLoader classLoader) {
        String data = null;
        try {
            data = FileCommand.readUtf8String(LocationCommand.pathValue(name));
        }
        catch (Exception e) {
            logger.warn("try to used class loader to find resource.");
        }
        if (data == null) {
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(name);
            try {
                data = StreamCommand.loadText(inputStream);
            }
            catch (Exception e) {
                try {
                    data = StringCommand.string(inputStream);
                }
                catch (Exception ee) {
                    URL url = Resources.getResource((String)name);
                    try {
                        data = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
                        return data;
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        logger.error("did not found " + name + " resource file.", (Throwable)ee);
                        return null;
                    }
                }
            }
        }
        return data;
    }

    public static String readUtf8String(String path) throws IORuntimeException {
        String data = FileCommand.readString(path, CharsetCommand.CHARSET_UTF_8);
        return data;
    }

    public static String readString(File file, String charsetName) throws IORuntimeException {
        return FileCommand.readString(file, CharsetCommand.charset(charsetName));
    }

    public static String readString(File file, Charset charset) throws IORuntimeException {
        String data = FileReader.create(file, charset).readString();
        return data;
    }

    public static String readString(String path, String charsetName) throws IORuntimeException {
        return FileCommand.readString(FileCommand.file(path), charsetName);
    }

    public static String readString(String path, Charset charset) throws IORuntimeException {
        return FileCommand.readString(FileCommand.file(path), charset);
    }

    public static String readString(URL url, String charset) throws IORuntimeException {
        if (url == null) {
            throw new RuntimeException("Empty url provided!");
        }
        InputStream in = null;
        try {
            in = url.openStream();
            String string = IoCommand.read(in, charset);
            return string;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IoCommand.close(in);
        }
    }

    public static <T extends Collection<String>> T readLines(String path, String charset, T collection) throws IORuntimeException {
        return FileCommand.readLines(FileCommand.file(path), charset, collection);
    }

    public static <T extends Collection<String>> T readLines(File file, String charset, T collection) throws IORuntimeException {
        return FileReader.create(file, CharsetCommand.charset(charset)).readLines(collection);
    }

    public static <T extends Collection<String>> T readLines(URL url, String charset, T collection) throws IORuntimeException {
        InputStream in = null;
        try {
            in = url.openStream();
            T t = IoCommand.readLines(in, charset, collection);
            return t;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IoCommand.close(in);
        }
    }

    public static List<String> readLines(URL url, String charset) throws IORuntimeException {
        return FileCommand.readLines(url, charset, new ArrayList());
    }

    public static List<String> readLines(String path, String charset) throws IORuntimeException {
        return FileCommand.readLines(path, charset, new ArrayList());
    }

    public static List<String> readLines(File file, String charset) throws IORuntimeException {
        return FileCommand.readLines(file, charset, new ArrayList());
    }

    public static <T> T load(FileReader.ReaderHandler<T> readerHandler, String path, String charset) throws IORuntimeException {
        return FileReader.create(FileCommand.file(path), CharsetCommand.charset(charset)).read(readerHandler);
    }

    public static BufferedOutputStream bufferedOutputStream(File file) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(FileCommand.touch(file)));
    }

    public static BufferedOutputStream bufferedOutputStream(String path) throws IOException {
        return FileCommand.bufferedOutputStream(FileCommand.touch(path));
    }

    public static BufferedWriter bufferedWriter(String path, String charsetName, boolean isAppend) throws IOException {
        return FileCommand.bufferedWriter(FileCommand.touch(path), Charset.forName(charsetName), isAppend);
    }

    public static BufferedWriter bufferedWriter(String path, Charset charset, boolean isAppend) throws IOException {
        return FileCommand.bufferedWriter(FileCommand.touch(path), charset, isAppend);
    }

    public static BufferedWriter bufferedWriter(File file, String charsetName, boolean isAppend) throws IOException {
        return FileCommand.bufferedWriter(file, Charset.forName(charsetName), isAppend);
    }

    public static BufferedWriter bufferedWriter(File file, Charset charset, boolean isAppend) throws IOException {
        return FileWriter.create(file, charset).getWriter(isAppend);
    }

    public static PrintWriter printWriter(String path, String charset, boolean isAppend) throws IOException {
        return new PrintWriter(FileCommand.bufferedWriter(path, charset, isAppend));
    }

    public static PrintWriter printWriter(File file, String charset, boolean isAppend) throws IOException {
        return new PrintWriter(FileCommand.bufferedWriter(file, charset, isAppend));
    }

    public static File writeUtf8String(String content, String path) throws IORuntimeException {
        return FileCommand.writeString(content, path, "UTF-8");
    }

    public static File writeUtf8String(String content, File file) throws IORuntimeException {
        return FileCommand.writeString(content, file, "UTF-8");
    }

    public static File writeString(String content, String path, String charset) throws IORuntimeException {
        return FileCommand.writeString(content, FileCommand.touch(path), charset);
    }

    public static File writeString(String content, File file, String charset) throws IORuntimeException {
        return FileWriter.create(file, CharsetCommand.charset(charset)).write(content);
    }

    public static File appendString(String content, String path, String charset) throws IORuntimeException {
        return FileCommand.appendString(content, FileCommand.touch(path), charset);
    }

    public static File appendString(String content, File file, String charset) throws IORuntimeException {
        return FileCommand.appendString(content, file, CharsetCommand.charset(charset));
    }

    public static File appendString(String content, File file, Charset charset) throws IORuntimeException {
        return FileWriter.create(file, charset).append(content);
    }

    public static <T> void appendLines(Collection<T> list, String path, String charset) throws IORuntimeException {
        FileCommand.writeLines(list, path, charset, true);
    }

    public static <T> void appendLines(Collection<T> list, String path, Charset charset) throws IORuntimeException {
        FileCommand.writeLines(list, FileCommand.file(path), charset, true);
    }

    public static File writeLine(String content, String path, String charset) throws IORuntimeException {
        return FileCommand.writeString(content, FileCommand.touch(path), charset);
    }

    public static File writeLine(String content, File file, String charset) throws IORuntimeException {
        return FileWriter.create(file, CharsetCommand.charset(charset)).writeLine(content);
    }

    public static <T> void writeLines(Collection<T> list, String path, String charset) throws IORuntimeException {
        FileCommand.writeLines(list, path, charset, false);
    }

    public static <T> File writeLines(Collection<T> list, String path, String charset, boolean isAppend) throws IORuntimeException {
        return FileCommand.writeLines(list, FileCommand.file(path), charset, isAppend);
    }

    public static <T> File writeLines(Collection<T> list, File file, String charset, boolean isAppend) throws IORuntimeException {
        return FileCommand.writeLines(list, file, CharsetCommand.charset(charset), isAppend);
    }

    public static <T> File writeLines(Collection<T> list, File file, Charset charset, boolean isAppend) throws IORuntimeException {
        FileWriter fileWriter = FileWriter.create(file, charset);
        if (isAppend) {
            return fileWriter.appendLines(list);
        }
        return fileWriter.writeLines(list);
    }

    public static File writeBytes(byte[] data, String path) throws IORuntimeException {
        return FileCommand.writeBytes(data, FileCommand.touch(path));
    }

    public static File writeBytes(byte[] data, File dest) throws IORuntimeException {
        return FileCommand.writeBytes(data, dest, 0, data.length, false);
    }

    public static File writeBytes(byte[] data, File dest, int off, int len, boolean append) throws IORuntimeException {
        return FileWriter.create(dest).write(data, off, len);
    }

    public static File appendLine(String content, String path, String charset) throws IORuntimeException {
        return FileCommand.appendString(content, FileCommand.touch(path), charset);
    }

    public static File appendLine(String content, File file, String charset) throws IORuntimeException {
        return FileCommand.appendString(content, file, CharsetCommand.charset(charset));
    }

    public static File appendLine(String content, File file, Charset charset) throws IORuntimeException {
        return FileWriter.create(file, charset).appendLine(content);
    }

    public static File writeFromStream(InputStream in, File dest) throws IORuntimeException {
        return FileWriter.create(dest).writeFromStream(in);
    }

    public static File writeFromStream(InputStream in, String fullFilePath) throws IORuntimeException {
        return FileCommand.writeFromStream(in, FileCommand.touch(fullFilePath));
    }

    public static File writeToStream(File file, OutputStream out) throws IORuntimeException {
        return FileReader.create(file).writeToStream(out);
    }

    public static void writeToStream(String fullFilePath, OutputStream out) throws IORuntimeException {
        FileCommand.writeToStream(FileCommand.touch(fullFilePath), out);
    }

    public static String readableFileSize(File file) {
        return FileCommand.readableFileSize(file.length());
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB", "EB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.##").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    private static boolean initWindowsOs() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        return osName.contains("windows");
    }

    public static File getUserDir() {
        return USER_DIR;
    }

    public static boolean isWindows() {
        return windowsOs;
    }

    public static String compactPath(String path) {
        return FileCommand.compactPath(path, "" + File.separatorChar);
    }

    public static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        if (FileCommand.isWindows()) {
            return path.replace('/', '\\');
        }
        return path.replace('\\', '/');
    }

    public static String compactPath(String path, char separator) {
        return FileCommand.compactPath(path, "" + separator);
    }

    public static String compactPath(String path, String separator) {
        String[] parts;
        if (path == null) {
            return null;
        }
        if (path.indexOf(47) == -1 && path.indexOf(92) == -1) {
            return path;
        }
        boolean endsWithSlash = (path = FileCommand.normalizePath(path)).endsWith(FOLDER_SEPARATOR) || path.endsWith("\\");
        boolean startsWithSlash = path.startsWith(FOLDER_SEPARATOR) || path.startsWith("\\");
        ArrayDeque<String> stack = new ArrayDeque<String>();
        String separatorRegex = "\\\\|/";
        for (String part : parts = path.split(separatorRegex)) {
            if (part.equals("..") && !stack.isEmpty() && !"..".equals(stack.peek())) {
                stack.pop();
                continue;
            }
            if (part.equals(".") || part.isEmpty()) continue;
            stack.push(part);
        }
        StringBuilder sb = new StringBuilder();
        if (startsWithSlash) {
            sb.append(separator);
        }
        Iterator it = stack.descendingIterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append(separator);
        }
        if (endsWithSlash && stack.size() > 0) {
            sb.append(separator);
        }
        return sb.toString();
    }

    private static File createNewTempDir() {
        String s = System.getProperty("java.io.tmpdir");
        File checkExists = new File(s);
        if (!checkExists.exists()) {
            throw new RuntimeException("The directory " + checkExists.getAbsolutePath() + " does not exist, please set java.io.tempdir to an existing directory");
        }
        if (!checkExists.canWrite()) {
            throw new RuntimeException("The directory " + checkExists.getAbsolutePath() + " is not writable, please set java.io.tempdir to a writable directory");
        }
        Random ran = new Random();
        int x = ran.nextInt(1000000);
        File f = new File(s, "camel-tmp-" + x);
        int count = 0;
        while (!f.mkdir()) {
            if (++count >= 100) {
                throw new RuntimeException("Camel cannot a temp directory from" + checkExists.getAbsolutePath() + " 100 times , please set java.io.tempdir to a writable directory");
            }
            x = ran.nextInt(1000000);
            f = new File(s, "camel-tmp-" + x);
        }
        return f;
    }

    private static synchronized File getDefaultTempDir() {
        if (defaultTempDir != null && defaultTempDir.exists()) {
            return defaultTempDir;
        }
        defaultTempDir = FileCommand.createNewTempDir();
        shutdownHook = new Thread(){

            @Override
            public void run() {
                FileCommand.removeDir(defaultTempDir);
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        return defaultTempDir;
    }

    public static File createTempFile(String prefix, String suffix, File parentDir) throws IOException {
        File parent;
        File file = parent = parentDir == null ? FileCommand.getDefaultTempDir() : parentDir;
        if (suffix == null) {
            suffix = ".tmp";
        }
        if (prefix == null) {
            prefix = "camel";
        } else if (prefix.length() < 3) {
            prefix = prefix + "camel";
        }
        parent.mkdirs();
        return File.createTempFile(prefix, suffix, parent);
    }

    public static String stripLeadingSeparator(String name) {
        if (name == null) {
            return null;
        }
        while (name.startsWith(FOLDER_SEPARATOR) || name.startsWith(File.separator)) {
            name = name.substring(1);
        }
        return name;
    }

    public static boolean hasLeadingSeparator(String name) {
        if (name == null) {
            return false;
        }
        return name.startsWith(FOLDER_SEPARATOR) || name.startsWith(File.separator);
    }

    public static String stripFirstLeadingSeparator(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith(FOLDER_SEPARATOR) || name.startsWith(File.separator)) {
            name = name.substring(1);
        }
        return name;
    }

    public static String stripTrailingSeparator(String name) {
        if (ObjectCommand.isEmpty(name)) {
            return name;
        }
        String s = name;
        while (s.endsWith(FOLDER_SEPARATOR) || s.endsWith(File.separator)) {
            s = s.substring(0, s.length() - 1);
        }
        if (ObjectCommand.isEmpty(s)) {
            return name;
        }
        return s;
    }

    public static String stripPath(String name) {
        int posWin;
        if (name == null) {
            return null;
        }
        int posUnix = name.lastIndexOf(47);
        int pos = Math.max(posUnix, posWin = name.lastIndexOf(92));
        if (pos != -1) {
            return name.substring(pos + 1);
        }
        return name;
    }

    public static String stripExt(String name) {
        return FileCommand.stripExt(name, false);
    }

    public static String stripExt(String name, boolean singleMode) {
        int posWin;
        if (name == null) {
            return null;
        }
        int posUnix = name.lastIndexOf(47);
        int pos = Math.max(posUnix, posWin = name.lastIndexOf(92));
        if (pos > 0) {
            int pos2;
            String onlyName = name.substring(pos + 1);
            int n = pos2 = singleMode ? onlyName.lastIndexOf(46) : onlyName.indexOf(46);
            if (pos2 > 0) {
                return name.substring(0, pos + pos2 + 1);
            }
        } else {
            int pos2;
            int n = pos2 = singleMode ? name.lastIndexOf(46) : name.indexOf(46);
            if (pos2 > 0) {
                return name.substring(0, pos2);
            }
        }
        return name;
    }

    public static String onlyExt(String name) {
        return FileCommand.onlyExt(name, false);
    }

    public static String onlyExt(String name, boolean singleMode) {
        int pos;
        if (name == null) {
            return null;
        }
        name = FileCommand.stripPath(name);
        int n = pos = singleMode ? name.lastIndexOf(46) : name.indexOf(46);
        if (pos != -1) {
            return name.substring(pos + 1);
        }
        return null;
    }

    public static String onlyPath(String name) {
        int posWin;
        if (name == null) {
            return null;
        }
        int posUnix = name.lastIndexOf(47);
        int pos = Math.max(posUnix, posWin = name.lastIndexOf(92));
        if (pos > 0) {
            return name.substring(0, pos);
        }
        if (pos == 0) {
            return name.substring(0, 1);
        }
        return null;
    }

    public static void removeDir(File d) {
        String[] list = d.list();
        if (list == null) {
            list = new String[]{};
        }
        for (String s : list) {
            File f = new File(d, s);
            if (f.isDirectory()) {
                FileCommand.removeDir(f);
                continue;
            }
            FileCommand.delete(f);
        }
        FileCommand.delete(d);
    }

    private static void delete(File f) {
        if (!f.delete()) {
            if (FileCommand.isWindows()) {
                System.gc();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!f.delete()) {
                f.deleteOnExit();
            }
        }
    }

    public static boolean renameFile(File from, File to, boolean copyAndDeleteOnRenameFail) throws IOException {
        if (!from.exists()) {
            return false;
        }
        boolean renamed = false;
        for (int count = 0; !renamed && count < 3; ++count) {
            renamed = from.renameTo(to);
            if (renamed || count <= 0) continue;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!renamed && copyAndDeleteOnRenameFail) {
            renamed = FileCommand.renameFileUsingCopy(from, to);
        }
        return renamed;
    }

    public static boolean renameFileUsingCopy(File from, File to) throws IOException {
        if (!from.exists()) {
            return false;
        }
        FileCommand.copyFile(from, to);
        if (!FileCommand.deleteFile(from)) {
            throw new IOException("Renaming file from '" + from + "' to '" + to + "' failed: Cannot delete file '" + from + "' after copy succeeded");
        }
        return true;
    }

    public static void copyFile(File from, File to) throws IOException {
        Files.copy(from.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static boolean deleteFile(File file) {
        if (!file.exists()) {
            return false;
        }
        boolean deleted = false;
        for (int count = 0; !deleted && count < 3; ++count) {
            deleted = file.delete();
            if (deleted || count <= 0) continue;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return deleted;
    }

    public static boolean isAbsolute(File file) {
        String path;
        if (FileCommand.isWindows() && (path = file.getPath()).startsWith(File.separator)) {
            return true;
        }
        return file.isAbsolute();
    }

    public static boolean createNewFile(File file) throws IOException {
        if (file.exists()) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            if (file.exists()) {
                return true;
            }
            throw e;
        }
    }

    public static boolean downloader(String url) {
        String path = LocationCommand.classPath() + File.separator + url.substring(url.lastIndexOf(47) + 1);
        return FileCommand.downloader(url, path);
    }

    public static boolean downloader(DirectDownloader directDownloader, DownloadTask downloadTask) {
        Thread t = new Thread(directDownloader);
        try {
            directDownloader.download(downloadTask);
            t.start();
        }
        catch (Exception e) {
            logger.error("did not download task:{}", (Object)downloadTask, (Object)e);
            if (t.isAlive()) {
                t.interrupt();
            }
            return false;
        }
        return true;
    }

    public static boolean downloaderWithOutListener(DirectDownloader directDownloader, String url, String path) {
        try {
            DownloadTask downloadTask = new DownloadTask(new URL(url), new FileOutputStream(path));
            FileCommand.downloader(directDownloader, downloadTask);
        }
        catch (Exception e) {
            logger.error("did not download file:{}, path:{}", new Object[]{url, path, e});
            return false;
        }
        return true;
    }

    public static boolean downloader(DirectDownloader directDownloader, DownloadListener downloadListener, String url, String path) {
        try {
            DownloadTask downloadTask = new DownloadTask(new URL(url), new FileOutputStream(path), downloadListener);
            directDownloader.download(downloadTask);
        }
        catch (Exception e) {
            logger.error("did not download url:{}, path:{}", new Object[]{url, path, e});
            return false;
        }
        return true;
    }

    public static boolean downloaderWithListener(final DirectDownloader directDownloader, String url, final String path) {
        try {
            DownloadTask downloadTask = new DownloadTask(new URL(url), new FileOutputStream(path)).addListener(new DownloadListener(){
                int size;

                @Override
                public void onStart(String fname, int size) {
                    logger.info("starting to downloading " + fname + " of size " + size);
                    this.size = size;
                    DirectDownloader.updateProgress(0.0);
                }

                @Override
                public void onUpdate(int bytes, int totalDownloaded) {
                    logger.debug(Thread.currentThread() + " downloader is downloading {} percent.", (Object)((double)totalDownloaded / (double)this.size));
                }

                @Override
                public void onComplete() {
                    logger.debug(Thread.currentThread() + " downloader downloaded {} success.", (Object)path);
                }

                @Override
                public void onCancel() {
                    logger.debug(Thread.currentThread() + " downloader undownloaded {} success.", (Object)path);
                }
            });
            return FileCommand.downloader(directDownloader, downloadTask);
        }
        catch (Exception e) {
            logger.error("did not download url:{}, path:{}", new Object[]{url, path, e});
            return false;
        }
    }

    public static boolean downloader(String url, String path) {
        DirectDownloader directDownloader = new DirectDownloader();
        return FileCommand.downloaderWithOutListener(directDownloader, url, path);
    }

    public static File getFile(String resourceLocation) throws FileNotFoundException {
        AssertCommand.notNull(resourceLocation, "Resource location must not be null");
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            URL url;
            String path = resourceLocation.substring(CLASSPATH_URL_PREFIX.length());
            String description = "class path resource [" + path + "]";
            ClassLoader cl = ClassCommand.getDefaultClassLoader();
            URL uRL = url = cl != null ? cl.getResource(path) : ClassLoader.getSystemResource(path);
            if (url == null) {
                throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not exist");
            }
            return FileCommand.getFile(url, description);
        }
        try {
            return FileCommand.getFile(new URL(resourceLocation));
        }
        catch (MalformedURLException ex) {
            return new File(resourceLocation);
        }
    }

    public static File getFile(URL resourceUrl) throws FileNotFoundException {
        return FileCommand.getFile(resourceUrl, "URL");
    }

    public static File getFile(URL resourceUrl, String description) throws FileNotFoundException {
        AssertCommand.notNull(resourceUrl, "Resource URL must not be null");
        if (!URL_PROTOCOL_FILE.equals(resourceUrl.getProtocol())) {
            throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not reside in the file system: " + resourceUrl);
        }
        try {
            return new File(FileCommand.toURI(resourceUrl).getSchemeSpecificPart());
        }
        catch (URISyntaxException ex) {
            return new File(resourceUrl.getFile());
        }
    }

    public static File getFile(URI resourceUri) throws FileNotFoundException {
        return FileCommand.getFile(resourceUri, "URI");
    }

    public static File getFile(URI resourceUri, String description) throws FileNotFoundException {
        AssertCommand.notNull(resourceUri, "Resource URI must not be null");
        if (!URL_PROTOCOL_FILE.equals(resourceUri.getScheme())) {
            throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not reside in the file system: " + resourceUri);
        }
        return new File(resourceUri.getSchemeSpecificPart());
    }

    public static boolean isFileURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_FILE.equals(protocol) || URL_PROTOCOL_VFSFILE.equals(protocol) || URL_PROTOCOL_VFS.equals(protocol);
    }

    public static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_JAR.equals(protocol) || URL_PROTOCOL_WAR.equals(protocol) || URL_PROTOCOL_ZIP.equals(protocol) || URL_PROTOCOL_VFSZIP.equals(protocol) || URL_PROTOCOL_WSJAR.equals(protocol);
    }

    public static boolean isJarFileURL(URL url) {
        return URL_PROTOCOL_FILE.equals(url.getProtocol()) && url.getPath().toLowerCase().endsWith(".jar");
    }

    public static URL extractJarFileURL(URL jarUrl) throws MalformedURLException {
        String urlFile = jarUrl.getFile();
        int separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR);
        if (separatorIndex != -1) {
            String jarFile = urlFile.substring(0, separatorIndex);
            try {
                return new URL(jarFile);
            }
            catch (MalformedURLException ex) {
                if (!jarFile.startsWith(FOLDER_SEPARATOR)) {
                    jarFile = FOLDER_SEPARATOR + jarFile;
                }
                return new URL("file:" + jarFile);
            }
        }
        return jarUrl;
    }

    public static URL extractArchiveURL(URL jarUrl) throws MalformedURLException {
        String urlFile = jarUrl.getFile();
        int endIndex = urlFile.indexOf(WAR_URL_SEPARATOR);
        if (endIndex != -1) {
            String warFile = urlFile.substring(0, endIndex);
            if (URL_PROTOCOL_WAR.equals(jarUrl.getProtocol())) {
                return new URL(warFile);
            }
            int startIndex = warFile.indexOf(WAR_URL_PREFIX);
            if (startIndex != -1) {
                return new URL(warFile.substring(startIndex + WAR_URL_PREFIX.length()));
            }
        }
        return FileCommand.extractJarFileURL(jarUrl);
    }

    public static URI toURI(URL url) throws URISyntaxException {
        return FileCommand.toURI(url.toString());
    }

    public static URI toURI(String location) throws URISyntaxException {
        return new URI(StringCommand.replace(location, " ", "%20"));
    }

    public static void useCachesIfNecessary(URLConnection con) {
        con.setUseCaches(con.getClass().getSimpleName().startsWith("JNLP"));
    }

    public static boolean downloadInDirectory(String src, String directory) {
        UriBuilder uriBuilder = UriCommand.uriBuilder(src);
        URL srcUrl = uriBuilder.buildURL();
        String filename = uriBuilder.fileName();
        String path = directory + File.separator + filename;
        FileCommand.mkdir(directory);
        try {
            FileOutputStream outputStream = new FileOutputStream(path);
            return FileCommand.download(srcUrl, outputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean download(String src, String dec) {
        dec = LocationCommand.pathValue(dec);
        return FileCommand.downloadWithDirectory(src, dec);
    }

    public static boolean downloadWithDirectory(String src, String dec) {
        UriBuilder uriBuilder = UriCommand.uriBuilder(src);
        URL srcUrl = uriBuilder.buildURL();
        if (srcUrl == null) {
            throw new UnsupportedOperationException("should not be null for src URL object url when download:{}" + src);
        }
        String realPath = LocationCommand.pathValue(dec);
        FileCommand.mkParentDirs(realPath);
        try {
            FileOutputStream outputStream = new FileOutputStream(realPath);
            return FileCommand.download(srcUrl, outputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean download(URL src, OutputStream dsc) {
        HttpConnector httpConnector = new HttpConnector();
        HttpsURLConnection conn = null;
        try {
            conn = httpConnector.getSecureConnection(src, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        conn.setReadTimeout(15000);
        conn.setDoOutput(true);
        InputStream is = null;
        try {
            conn.connect();
            is = conn.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        OutputStream os = dsc;
        byte[] buff = new byte[2048];
        try {
            int res;
            while ((res = is.read(buff)) != -1) {
                os.write(buff, 0, res);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        try {
            is.close();
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static InputStream tryUserSystemExternal(String filename) {
        InputStream inputStream;
        if (System.getenv(filename) != null) {
            if (FileCommand.isExist(System.getenv(filename))) {
                try {
                    inputStream = FileCommand.inputStream(System.getenv(filename));
                }
                catch (RuntimeException e) {
                    inputStream = null;
                    e.printStackTrace();
                }
            } else {
                inputStream = null;
            }
        } else {
            inputStream = null;
        }
        if (inputStream == null) {
            if (FileCommand.isExist(System.getProperty(filename))) {
                try {
                    inputStream = FileCommand.inputStream(System.getProperty(filename));
                }
                catch (RuntimeException e) {
                    inputStream = null;
                    e.printStackTrace();
                }
            } else {
                inputStream = null;
            }
        }
        return inputStream;
    }

    public static InputStream tryUserSystemDefault(String key, String filename) {
        InputStream inputStream;
        if (System.getProperty(key) != null) {
            if (FileCommand.isExist(System.getProperty(key) + File.separator + filename)) {
                try {
                    inputStream = FileCommand.inputStream(System.getProperty(key) + File.separator + filename);
                }
                catch (RuntimeException e) {
                    inputStream = null;
                    e.printStackTrace();
                }
            } else {
                inputStream = null;
            }
        } else {
            inputStream = null;
        }
        if (inputStream == null) {
            if (System.getenv(key) != null) {
                if (FileCommand.isExist(System.getenv(key) + File.separator + filename)) {
                    try {
                        inputStream = FileCommand.inputStream(System.getenv(key) + File.separator + filename);
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                        inputStream = null;
                    }
                } else {
                    inputStream = null;
                }
            } else {
                inputStream = null;
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getResource(String filename) {
        InputStream inputStream;
        if (FileCommand.isExist(filename)) {
            try {
                inputStream = FileCommand.inputStream(filename);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                inputStream = null;
            }
        } else {
            inputStream = FileCommand.tryUserSystemExternal(filename);
        }
        if (inputStream == null) {
            try {
                inputStream = FileCommand.inputStream(LocationCommand.pathValue(filename));
            }
            catch (RuntimeException e) {
                try {
                    inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream(filename);
                }
                catch (Exception eeeee) {
                }
                finally {
                    block20: {
                        if (inputStream == null) {
                            try {
                                inputStream = FileCommand.inputStream(new File(System.getProperty(filename)));
                            }
                            catch (Exception eeeee) {
                                inputStream = FileCommand.tryUserSystemDefault(USER_DIR_KEY, filename);
                                if (inputStream == null) {
                                    inputStream = FileCommand.tryUserSystemDefault("basedir", filename);
                                }
                                if (inputStream != null) break block20;
                                logger.warn("should define the {} file location.", (Object)filename);
                            }
                        }
                    }
                }
            }
        }
        return inputStream;
    }

    static {
        windowsOs = FileCommand.initWindowsOs();
        logger = LoggerFactory.getLogger((String)FileCommand.class.getName());
    }
}

