/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.io.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.io.exception.IORuntimeException;
import org.gjgr.pig.chivalrous.core.io.file.FileReader;
import org.gjgr.pig.chivalrous.core.io.file.FileTypeUtil;
import org.gjgr.pig.chivalrous.core.io.file.FileWriter;
import org.gjgr.pig.chivalrous.core.io.stream.BOMInputStream;
import org.gjgr.pig.chivalrous.core.lang.ArrayCommand;
import org.gjgr.pig.chivalrous.core.lang.AssertCommand;
import org.gjgr.pig.chivalrous.core.lang.ClassCommand;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.net.UriCommand;
import org.gjgr.pig.chivalrous.core.nio.CharsetCommand;

public class FileUtil {
    public static final String CLASS_EXT = ".class";
    public static final String JAR_FILE_EXT = ".jar";
    public static final String JAR_PATH_EXT = ".jar!";
    public static final String PATH_FILE_PRE = "file:";
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';

    private FileUtil() {
    }

    public static File[] ls(String path) {
        if (path == null) {
            return null;
        }
        File file = FileUtil.file(path = FileUtil.getAbsolutePath(path));
        if (file.isDirectory()) {
            return file.listFiles();
        }
        throw new IORuntimeException(StringCommand.format("Path [{}] is not directory!", path));
    }

    public static boolean isEmpty(File file) {
        if (null == file) {
            return true;
        }
        if (file.isDirectory()) {
            String[] subFiles = file.list();
            if (ArrayCommand.isEmpty(subFiles)) {
                return true;
            }
        } else if (file.isFile()) {
            return file.length() <= 0L;
        }
        return false;
    }

    public static boolean isNotEmpty(File file) {
        return false == FileUtil.isEmpty(file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDirEmpty(Path dirPath) {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(dirPath);){
            boolean bl = false == dirStream.iterator().hasNext();
            return bl;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean isDirEmpty(File dir) {
        return FileUtil.isDirEmpty(dir.toPath());
    }

    public static List<File> loopFiles(File file, FileFilter fileFilter) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (file == null) {
            return fileList;
        }
        if (!file.exists()) {
            return fileList;
        }
        if (file.isDirectory()) {
            for (File tmp : file.listFiles()) {
                fileList.addAll(FileUtil.loopFiles(tmp, fileFilter));
            }
        } else if (null == fileFilter || fileFilter.accept(file)) {
            fileList.add(file);
        }
        return fileList;
    }

    public static List<File> loopFiles(File file) {
        return FileUtil.loopFiles(file, null);
    }

    public static List<String> listFileNames(String path) {
        if (path == null) {
            return null;
        }
        if (!(path = FileUtil.getAbsolutePath(path)).endsWith(String.valueOf('/'))) {
            path = path + '/';
        }
        ArrayList<String> paths = new ArrayList<String>();
        int index = path.lastIndexOf(JAR_PATH_EXT);
        try {
            if (index == -1) {
                File[] files;
                for (File file : files = FileUtil.ls(path)) {
                    if (!file.isFile()) continue;
                    paths.add(file.getName());
                }
            } else {
                String jarPath = path.substring(0, index += JAR_FILE_EXT.length());
                String subPath = path.substring(index + 2);
                for (JarEntry entry : Collections.list(new JarFile(jarPath).entries())) {
                    String nameSuffix;
                    String name = entry.getName();
                    if (!name.startsWith(subPath) || (nameSuffix = StringCommand.removePrefix(name, subPath)).contains(String.valueOf('/'))) continue;
                    paths.add(nameSuffix);
                }
            }
        }
        catch (Exception e) {
            throw new IORuntimeException(StringCommand.format("Can not read file path of [{}]", path), e);
        }
        return paths;
    }

    public static File file(String path) {
        if (StringCommand.isBlank(path)) {
            throw new NullPointerException("File path is blank!");
        }
        return new File(FileUtil.getAbsolutePath(path));
    }

    public static File file(String parent, String path) {
        if (StringCommand.isBlank(path)) {
            throw new NullPointerException("File path is blank!");
        }
        return new File(parent, path);
    }

    public static File file(File parent, String path) {
        if (StringCommand.isBlank(path)) {
            throw new NullPointerException("File path is blank!");
        }
        return new File(parent, path);
    }

    public static File file(URI uri) {
        if (uri == null) {
            throw new NullPointerException("File uri is null!");
        }
        return new File(uri);
    }

    public static File file(URL url) {
        return new File(UriCommand.toURI(url));
    }

    public static boolean exist(String path) {
        return path == null ? false : FileUtil.file(path).exists();
    }

    public static boolean exist(File file) {
        return file == null ? false : file.exists();
    }

    public static boolean exist(String directory, String regexp) {
        File file = new File(directory);
        if (!file.exists()) {
            return false;
        }
        String[] fileList = file.list();
        if (fileList == null) {
            return false;
        }
        for (String fileName : fileList) {
            if (!fileName.matches(regexp)) continue;
            return true;
        }
        return false;
    }

    public static Date lastModifiedTime(File file) {
        if (!FileUtil.exist(file)) {
            return null;
        }
        return new Date(file.lastModified());
    }

    public static Date lastModifiedTime(String path) {
        return FileUtil.lastModifiedTime(new File(path));
    }

    public static long size(File file) {
        AssertCommand.notNull(file, "file argument is null !");
        if (!file.exists()) {
            throw new IllegalArgumentException(StringCommand.format("File [{}] not exist !", file.getAbsolutePath()));
        }
        if (file.isDirectory()) {
            long size = 0L;
            File[] subFiles = file.listFiles();
            if (ArrayCommand.isEmpty(subFiles)) {
                return 0L;
            }
            for (int i = 0; i < subFiles.length; ++i) {
                size += FileUtil.size(subFiles[i]);
            }
            return size;
        }
        return file.length();
    }

    public static boolean newerThan(File file, File reference) {
        if (null == file || !reference.exists()) {
            return true;
        }
        return FileUtil.newerThan(file, reference.lastModified());
    }

    public static boolean newerThan(File file, long timeMillis) {
        if (null == file || !file.exists()) {
            return false;
        }
        return file.lastModified() > timeMillis;
    }

    public static File touch(String fullFilePath) throws IORuntimeException {
        if (fullFilePath == null) {
            return null;
        }
        return FileUtil.touch(FileUtil.file(fullFilePath));
    }

    public static File touch(File file) {
        if (null == file) {
            return null;
        }
        if (!file.exists()) {
            FileUtil.mkParentDirs(file);
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                throw new IORuntimeException(e);
            }
        }
        return file;
    }

    public static File touch(File parent, String path) throws IOException {
        return FileUtil.touch(FileUtil.file(parent, path));
    }

    public static File touch(String parent, String path) throws IOException {
        return FileUtil.touch(FileUtil.file(parent, path));
    }

    public static File mkParentDirs(File file) {
        File parentFile = file.getParentFile();
        if (null != parentFile && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        return parentFile;
    }

    public static File mkParentDirs(String path) {
        if (path == null) {
            return null;
        }
        return FileUtil.mkParentDirs(FileUtil.file(path));
    }

    public static boolean del(String fullFileOrDirPath) throws IOException {
        return FileUtil.del(FileUtil.file(fullFileOrDirPath));
    }

    public static boolean del(File file) throws IOException {
        if (file == null || !file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File childFile : files = file.listFiles()) {
                boolean isOk = FileUtil.del(childFile);
                if (isOk) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static File mkdir(String dirPath) {
        if (dirPath == null) {
            return null;
        }
        File dir = FileUtil.file(dirPath);
        return FileUtil.mkdir(dir);
    }

    public static File mkdir(File dir) {
        if (dir == null) {
            return null;
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static File createTempFile(File dir) throws IOException {
        return FileUtil.createTempFile("hutool", null, dir, true);
    }

    public static File createTempFile(File dir, boolean isReCreat) throws IOException {
        return FileUtil.createTempFile("hutool", null, dir, isReCreat);
    }

    public static File createTempFile(String prefix, String suffix, File dir, boolean isReCreat) throws IOException {
        int exceptionsCount = 0;
        while (true) {
            try {
                File file = File.createTempFile(prefix, suffix, dir).getCanonicalFile();
                if (isReCreat) {
                    file.delete();
                    file.createNewFile();
                }
                return file;
            }
            catch (IOException ioex) {
                if (++exceptionsCount < 50) continue;
                throw ioex;
            }
            break;
        }
    }

    public static File copyFile(String src, String dest, StandardCopyOption ... options) throws IOException {
        AssertCommand.notBlank(src, "Source File path is blank !");
        AssertCommand.notNull(src, "Destination File path is null !");
        return FileUtil.copyFile(Paths.get(src, new String[0]), Paths.get(dest, new String[0]), options).toFile();
    }

    public static File copyFile(File src, File dest, StandardCopyOption ... options) throws IOException {
        AssertCommand.notNull(src, "Source File is null !");
        if (!src.exists()) {
            throw new FileNotFoundException("File not exist: " + src);
        }
        AssertCommand.notNull(dest, "Destination File or directiory is null !");
        if (FileUtil.equals(src, dest)) {
            throw new IOException("Files '" + src + "' and '" + dest + "' are equal");
        }
        Path srcPath = src.toPath();
        Path destPath = dest.isDirectory() ? dest.toPath().resolve(srcPath.getFileName()) : dest.toPath();
        return Files.copy(srcPath, destPath, (CopyOption[])options).toFile();
    }

    public static Path copyFile(Path src, Path dest, StandardCopyOption ... options) throws IOException {
        AssertCommand.notNull(src, "Source File is null !");
        AssertCommand.notNull(dest, "Destination File or directiory is null !");
        Path destPath = dest.toFile().isDirectory() ? dest.resolve(src.getFileName()) : dest;
        return Files.copy(src, destPath, (CopyOption[])options);
    }

    public static File copy(String srcPath, String destPath, boolean isOverride) throws IOException {
        return FileUtil.copy(FileUtil.file(srcPath), FileUtil.file(destPath), isOverride);
    }

    public static File copy(File src, File dest, boolean isOverride) throws IOException {
        AssertCommand.notNull(src, "Source File is null !");
        if (!src.exists()) {
            throw new FileNotFoundException("File not exist: " + src);
        }
        AssertCommand.notNull(dest, "Destination File or directiory is null !");
        if (FileUtil.equals(src, dest)) {
            throw new IOException("Files '" + src + "' and '" + dest + "' are equal");
        }
        if (src.isDirectory()) {
            FileUtil.internalCopyDir(src, dest, isOverride);
        } else {
            FileUtil.internalCopyFile(src, dest, isOverride);
        }
        return dest;
    }

    private static void internalCopyDir(File src, File dest, boolean isOverride) throws IOException {
        String[] files;
        if (!dest.exists()) {
            dest.mkdirs();
        } else if (dest.isFile()) {
            throw new IOException(StringCommand.format("Src [{}] is a directory but dest [{}] is a file!", src.getPath(), dest.getPath()));
        }
        for (String file : files = src.list()) {
            File srcFile = new File(src, file);
            File destFile = new File(dest, file);
            if (src.isDirectory()) {
                FileUtil.internalCopyDir(srcFile, destFile, isOverride);
                continue;
            }
            FileUtil.internalCopyFile(srcFile, destFile, isOverride);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void internalCopyFile(File src, File dest, boolean isOverride) throws IOException {
        if (!dest.exists()) {
            FileUtil.touch(dest);
        } else if (dest.isDirectory()) {
            dest = new File(dest, src.getName());
        } else if (!isOverride) {
            return;
        }
        FileInputStream input = new FileInputStream(src);
        FileOutputStream output = new FileOutputStream(dest);
        try {
            IoCommand.copy(input, output);
        }
        finally {
            IoCommand.close(output);
            IoCommand.close(input);
        }
        if (src.length() != dest.length()) {
            throw new IOException("Copy file failed of '" + src + "' to '" + dest + "' due to different sizes");
        }
    }

    public static void move(File src, File dest, boolean isOverride) throws IOException {
        if (!src.exists()) {
            throw new FileNotFoundException("File already exist: " + src);
        }
        if (src.isDirectory() && dest.isFile()) {
            throw new IOException(StringCommand.format("Can not move directory [{}] to file [{}]", src, dest));
        }
        if (isOverride && dest.isFile()) {
            dest.delete();
        }
        if (src.isFile() && dest.isDirectory()) {
            dest = new File(dest, src.getName());
        }
        if (!src.renameTo(dest)) {
            try {
                FileUtil.copy(src, dest, isOverride);
                src.delete();
            }
            catch (Exception e) {
                throw new IOException(StringCommand.format("Move [{}] to [{}] failed!", src, dest), e);
            }
        }
    }

    public static String getAbsolutePath(String path, Class<?> baseClass) {
        if (path == null) {
            path = "";
        }
        if (baseClass == null) {
            return FileUtil.getAbsolutePath(path);
        }
        return StringCommand.removePrefix(PATH_FILE_PRE, baseClass.getResource(path).getPath());
    }

    public static String getAbsolutePath(String path) {
        if (path == null) {
            path = "";
        } else if ('/' == (path = FileUtil.normalize(path)).charAt(0) || path.matches("^[a-zA-Z]:/.*")) {
            return path;
        }
        path = StringCommand.removePrefixIgnoreCase(path, "classpath:");
        path = StringCommand.removePrefix(path, "/");
        ClassLoader classLoader = ClassCommand.getClassLoader();
        URL url = classLoader.getResource(path);
        String reultPath = url != null ? url.getPath() : ClassCommand.getClassPath() + path;
        return reultPath;
    }

    public static String getAbsolutePath(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    public static boolean isDirectory(String path) {
        return path == null ? false : FileUtil.file(path).isDirectory();
    }

    public static boolean isDirectory(File file) {
        return file == null ? false : file.isDirectory();
    }

    public static boolean isFile(String path) {
        return path == null ? false : FileUtil.file(path).isFile();
    }

    public static boolean isFile(File file) {
        return file == null ? false : file.isFile();
    }

    public static boolean equals(File file1, File file2) {
        try {
            file1 = file1.getCanonicalFile();
            file2 = file2.getCanonicalFile();
        }
        catch (IOException ignore) {
            return false;
        }
        return file1.equals(file2);
    }

    public static int indexOfLastSeparator(String filePath) {
        int lastWindowsPos;
        if (filePath == null) {
            return -1;
        }
        int lastUnixPos = filePath.lastIndexOf(47);
        return lastUnixPos >= (lastWindowsPos = filePath.lastIndexOf(92)) ? lastUnixPos : lastWindowsPos;
    }

    public static boolean isModifed(File file, long lastModifyTime) {
        if (null == file || !file.exists()) {
            return true;
        }
        return file.lastModified() != lastModifyTime;
    }

    public static String normalize(String path) {
        int i;
        if (path == null) {
            return null;
        }
        String pathToUse = path.replaceAll("[/\\\\]{1,}", "/").trim();
        int prefixIndex = pathToUse.indexOf(":");
        String prefix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (prefix.contains("/")) {
                prefix = "";
            } else {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            }
        }
        if (pathToUse.startsWith("/")) {
            prefix = prefix + "/";
            pathToUse = pathToUse.substring(1);
        }
        List<String> pathList = StringCommand.split(pathToUse, '/');
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (i = pathList.size() - 1; i >= 0; --i) {
            String element = pathList.get(i);
            if (".".equals(element)) continue;
            if ("..".equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        for (i = 0; i < tops; ++i) {
            pathElements.add(0, "..");
        }
        return prefix + CollectionCommand.join(pathElements, "/");
    }

    public static String subPath(String rootDir, String filePath) {
        return FileUtil.subPath(rootDir, FileUtil.file(filePath));
    }

    public static String subPath(String rootDir, File file) {
        if (StringCommand.isEmpty(rootDir)) {
            // empty if block
        }
        String subPath = null;
        try {
            subPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (StringCommand.isNotEmpty(rootDir) && StringCommand.isNotEmpty(subPath)) {
            rootDir = FileUtil.normalize(rootDir);
            if ((subPath = FileUtil.normalize(subPath)) != null && subPath.toLowerCase().startsWith(subPath.toLowerCase())) {
                subPath = subPath.substring(rootDir.length() + 1);
            }
        }
        return subPath;
    }

    public static String mainName(File file) {
        if (file.isDirectory()) {
            return file.getName();
        }
        return FileUtil.mainName(file.getName());
    }

    public static String mainName(String fileName) {
        if (StringCommand.isBlank(fileName) || !fileName.contains(".")) {
            return fileName;
        }
        return StringCommand.subPre(fileName, fileName.lastIndexOf("."));
    }

    public static String extName(File file) {
        if (null == file) {
            return null;
        }
        if (file.isDirectory()) {
            return null;
        }
        return FileUtil.extName(file.getName());
    }

    public static String extName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        String ext = fileName.substring(index + 1);
        return ext.contains(String.valueOf('/')) || ext.contains(String.valueOf('\\')) ? "" : ext;
    }

    public static boolean pathEndsWith(File file, String suffix) {
        return file.getPath().toLowerCase().endsWith(suffix);
    }

    public static String getType(File file) {
        try {
            return FileTypeUtil.getType(file);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedInputStream getInputStream(File file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    public static BufferedInputStream getInputStream(String path) throws FileNotFoundException {
        return FileUtil.getInputStream(FileUtil.file(path));
    }

    public static BOMInputStream getBOMInputStream(File file) throws FileNotFoundException {
        return new BOMInputStream(new FileInputStream(file));
    }

    public static BufferedReader getUtf8Reader(File file) throws IOException {
        return FileUtil.getReader(file, CharsetCommand.CHARSET_UTF_8);
    }

    public static BufferedReader getUtf8Reader(String path) throws IOException {
        return FileUtil.getReader(path, CharsetCommand.CHARSET_UTF_8);
    }

    public static BufferedReader getReader(File file, String charsetName) throws IOException {
        return IoCommand.getReader((InputStream)FileUtil.getInputStream(file), charsetName);
    }

    public static BufferedReader getReader(File file, Charset charset) throws IOException {
        return IoCommand.getReader((InputStream)FileUtil.getInputStream(file), charset);
    }

    public static BufferedReader getReader(String path, String charsetName) throws IOException {
        return FileUtil.getReader(FileUtil.file(path), charsetName);
    }

    public static BufferedReader getReader(String path, Charset charset) throws IOException {
        return FileUtil.getReader(FileUtil.file(path), charset);
    }

    public static byte[] readBytes(File file) throws IORuntimeException {
        return FileReader.create(file).readBytes();
    }

    public static String readUtf8String(File file) throws IOException {
        return FileUtil.readString(file, CharsetCommand.CHARSET_UTF_8);
    }

    public static String readUtf8String(String path) throws IORuntimeException {
        return FileUtil.readString(path, CharsetCommand.CHARSET_UTF_8);
    }

    public static String readString(File file, String charsetName) throws IORuntimeException {
        return FileUtil.readString(file, CharsetCommand.charset(charsetName));
    }

    public static String readString(File file, Charset charset) throws IORuntimeException {
        return FileReader.create(file, charset).readString();
    }

    public static String readString(String path, String charsetName) throws IORuntimeException {
        return FileUtil.readString(FileUtil.file(path), charsetName);
    }

    public static String readString(String path, Charset charset) throws IORuntimeException {
        return FileUtil.readString(FileUtil.file(path), charset);
    }

    public static String readString(URL url, String charset) throws IORuntimeException {
        if (url == null) {
            throw new RuntimeException("Empty url provided!");
        }
        InputStream in = null;
        try {
            in = url.openStream();
            String string = IoCommand.read(in, charset);
            return string;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IoCommand.close(in);
        }
    }

    public static <T extends Collection<String>> T readLines(String path, String charset, T collection) throws IORuntimeException {
        return FileUtil.readLines(FileUtil.file(path), charset, collection);
    }

    public static <T extends Collection<String>> T readLines(File file, String charset, T collection) throws IORuntimeException {
        return FileReader.create(file, CharsetCommand.charset(charset)).readLines(collection);
    }

    public static <T extends Collection<String>> T readLines(URL url, String charset, T collection) throws IORuntimeException {
        InputStream in = null;
        try {
            in = url.openStream();
            T t = IoCommand.readLines(in, charset, collection);
            return t;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IoCommand.close(in);
        }
    }

    public static List<String> readLines(URL url, String charset) throws IORuntimeException {
        return FileUtil.readLines(url, charset, new ArrayList());
    }

    public static List<String> readLines(String path, String charset) throws IORuntimeException {
        return FileUtil.readLines(path, charset, new ArrayList());
    }

    public static List<String> readLines(File file, String charset) throws IORuntimeException {
        return FileUtil.readLines(file, charset, new ArrayList());
    }

    public static <T> T load(FileReader.ReaderHandler<T> readerHandler, String path, String charset) throws IORuntimeException {
        return FileReader.create(FileUtil.file(path), CharsetCommand.charset(charset)).read(readerHandler);
    }

    public static BufferedOutputStream getOutputStream(File file) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(FileUtil.touch(file)));
    }

    public static BufferedOutputStream getOutputStream(String path) throws IOException {
        return FileUtil.getOutputStream(FileUtil.touch(path));
    }

    public static BufferedWriter getWriter(String path, String charsetName, boolean isAppend) throws IOException {
        return FileUtil.getWriter(FileUtil.touch(path), Charset.forName(charsetName), isAppend);
    }

    public static BufferedWriter getWriter(String path, Charset charset, boolean isAppend) throws IOException {
        return FileUtil.getWriter(FileUtil.touch(path), charset, isAppend);
    }

    public static BufferedWriter getWriter(File file, String charsetName, boolean isAppend) throws IOException {
        return FileUtil.getWriter(file, Charset.forName(charsetName), isAppend);
    }

    public static BufferedWriter getWriter(File file, Charset charset, boolean isAppend) throws IOException {
        return FileWriter.create(file, charset).getWriter(isAppend);
    }

    public static PrintWriter getPrintWriter(String path, String charset, boolean isAppend) throws IOException {
        return new PrintWriter(FileUtil.getWriter(path, charset, isAppend));
    }

    public static PrintWriter getPrintWriter(File file, String charset, boolean isAppend) throws IOException {
        return new PrintWriter(FileUtil.getWriter(file, charset, isAppend));
    }

    public static File writeUtf8String(String content, String path) throws IORuntimeException {
        return FileUtil.writeString(content, path, "UTF-8");
    }

    public static File writeUtf8String(String content, File file) throws IORuntimeException {
        return FileUtil.writeString(content, file, "UTF-8");
    }

    public static File writeString(String content, String path, String charset) throws IORuntimeException {
        return FileUtil.writeString(content, FileUtil.touch(path), charset);
    }

    public static File writeString(String content, File file, String charset) throws IORuntimeException {
        return FileWriter.create(file, CharsetCommand.charset(charset)).write(content);
    }

    public static File appendString(String content, String path, String charset) throws IORuntimeException {
        return FileUtil.appendString(content, FileUtil.touch(path), charset);
    }

    public static File appendString(String content, File file, String charset) throws IORuntimeException {
        return FileWriter.create(file, CharsetCommand.charset(charset)).append(content);
    }

    public static <T> void writeLines(Collection<T> list, String path, String charset) throws IORuntimeException {
        FileUtil.writeLines(list, path, charset, false);
    }

    public static <T> void appendLines(Collection<T> list, String path, String charset) throws IORuntimeException {
        FileUtil.writeLines(list, path, charset, true);
    }

    public static <T> File writeLines(Collection<T> list, String path, String charset, boolean isAppend) throws IORuntimeException {
        return FileUtil.writeLines(list, FileUtil.file(path), charset, isAppend);
    }

    public static <T> File writeLines(Collection<T> list, File file, String charset, boolean isAppend) throws IORuntimeException {
        return FileWriter.create(file, CharsetCommand.charset(charset)).writeLines(list);
    }

    public static File writeBytes(byte[] data, String path) throws IORuntimeException {
        return FileUtil.writeBytes(data, FileUtil.touch(path));
    }

    public static File writeBytes(byte[] data, File dest) throws IORuntimeException {
        return FileUtil.writeBytes(data, dest, 0, data.length, false);
    }

    public static File writeBytes(byte[] data, File dest, int off, int len, boolean append) throws IORuntimeException {
        return FileWriter.create(dest).write(data, off, len);
    }

    public static File writeFromStream(InputStream in, File dest) throws IORuntimeException {
        return FileWriter.create(dest).writeFromStream(in);
    }

    public static File writeFromStream(InputStream in, String fullFilePath) throws IORuntimeException {
        return FileUtil.writeFromStream(in, FileUtil.touch(fullFilePath));
    }

    public static File writeToStream(File file, OutputStream out) throws IORuntimeException {
        return FileReader.create(file).writeToStream(out);
    }

    public static void writeToStream(String fullFilePath, OutputStream out) throws IORuntimeException {
        FileUtil.writeToStream(FileUtil.touch(fullFilePath), out);
    }

    public static String readableFileSize(File file) {
        return FileUtil.readableFileSize(file.length());
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB", "EB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.##").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }
}

