/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.io.file;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.io.exception.IORuntimeException;
import org.gjgr.pig.chivalrous.core.io.file.FileCommand;
import org.gjgr.pig.chivalrous.core.io.file.FileWrapper;
import org.gjgr.pig.chivalrous.core.lang.AssertCommand;
import org.gjgr.pig.chivalrous.core.nio.CharsetCommand;

public class FileWriter
extends FileWrapper {
    public FileWriter(File file, Charset charset) {
        super(file, charset);
        this.checkFile();
    }

    public FileWriter(File file, String charset) {
        this(file, CharsetCommand.charset(charset));
    }

    public FileWriter(String filePath, Charset charset) {
        this(FileCommand.file(filePath), charset);
    }

    public FileWriter(String filePath, String charset) {
        this(FileCommand.file(filePath), CharsetCommand.charset(charset));
    }

    public FileWriter(File file) {
        this(file, DEFAULT_CHARSET);
    }

    public FileWriter(String filePath) {
        this(filePath, DEFAULT_CHARSET);
    }

    public static FileWriter create(File file, Charset charset) {
        return new FileWriter(file, charset);
    }

    public static FileWriter create(File file) {
        return new FileWriter(file);
    }

    public File write(String content, boolean isAppend) throws IORuntimeException {
        BufferedWriter writer = null;
        try {
            writer = this.getWriter(isAppend);
            writer.write(content);
            writer.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IoCommand.close(writer);
        }
        return this.file;
    }

    public File write(String content) throws IORuntimeException {
        return this.write(content, false);
    }

    public File append(String content) throws IORuntimeException {
        return this.write(content, true);
    }

    public <T> File writeLines(Collection<T> list) throws IORuntimeException {
        return this.writeLines(list, false);
    }

    public <T> File appendLine(String data) throws IORuntimeException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(data);
        return this.appendLines(list);
    }

    public <T> File appendLines(Collection<T> list) throws IORuntimeException {
        return this.writeLines(list, true);
    }

    public <T> File writeLine(String data) throws IORuntimeException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(data);
        return this.writeLines(list);
    }

    public <T> File writeLines(Collection<T> list, boolean isAppend) throws IORuntimeException {
        PrintWriter writer = null;
        try {
            writer = this.getPrintWriter(isAppend);
            for (T t : list) {
                if (t == null) continue;
                writer.println(t.toString());
                writer.flush();
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IoCommand.close(writer);
        }
        return this.file;
    }

    public File write(byte[] data, int off, int len) throws IORuntimeException {
        return this.write(data, off, len, false);
    }

    public File append(byte[] data, int off, int len) throws IORuntimeException {
        return this.write(data, off, len, true);
    }

    public File write(byte[] data, int off, int len, boolean isAppend) throws IORuntimeException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(FileCommand.touch(this.file), isAppend);
            out.write(data, off, len);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IoCommand.close(out);
                throw throwable;
            }
        }
        IoCommand.close(out);
        return this.file;
    }

    public File writeFromStream(InputStream in) throws IORuntimeException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(FileCommand.touch(this.file));
            IoCommand.copy(in, (OutputStream)out);
        }
        catch (Exception e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IoCommand.close(out);
                throw throwable;
            }
        }
        IoCommand.close(out);
        return this.file;
    }

    public BufferedOutputStream getOutputStream() throws IORuntimeException {
        try {
            return new BufferedOutputStream(new FileOutputStream(FileCommand.touch(this.file)));
        }
        catch (Exception e) {
            throw new IORuntimeException(e);
        }
    }

    public BufferedWriter getWriter(boolean isAppend) throws IORuntimeException {
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileCommand.touch(this.file), isAppend), this.charset));
        }
        catch (Exception e) {
            throw new IORuntimeException(e);
        }
    }

    public PrintWriter getPrintWriter(boolean isAppend) throws IOException {
        return new PrintWriter(this.getWriter(isAppend));
    }

    private void checkFile() throws IORuntimeException {
        AssertCommand.notNull(this.file, "File to write content is null !");
        if (this.file.exists() && !this.file.isFile()) {
            throw new IORuntimeException("File [{}] is not a file !", this.file.getAbsoluteFile());
        }
    }
}

