/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.io.file;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;

public class SearchFiles {
    private Map<String, Boolean> map = new HashMap<String, Boolean>();
    private File root;

    public SearchFiles(File root) {
        this.root = root;
    }

    private String[] getTargetFiles(File directory) {
        if (directory == null) {
            return null;
        }
        String[] files = directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("Temp") && name.endsWith(".txt");
            }
        });
        return files;
    }

    private void printFiles(String[] targets) {
        for (String target : targets) {
            System.out.println(target);
        }
    }

    private void recursive(File path) {
        this.printFiles(this.getTargetFiles(path));
        for (File file : path.listFiles()) {
            if (!file.isDirectory()) continue;
            this.recursive(file);
        }
        if (path.isDirectory()) {
            this.printFiles(this.getTargetFiles(path));
        }
    }

    private void dfs() {
        if (this.root == null) {
            return;
        }
        Stack<File> stack = new Stack<File>();
        stack.push(this.root);
        this.map.put(this.root.getAbsolutePath(), true);
        while (!stack.isEmpty()) {
            File node = (File)stack.peek();
            File child = this.getUnvisitedChild(node);
            if (child != null) {
                stack.push(child);
                this.printFiles(this.getTargetFiles(child));
                this.map.put(child.getAbsolutePath(), true);
                continue;
            }
            stack.pop();
        }
    }

    private File getUnvisitedChild(File node) {
        File[] childs = node.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (childs == null) {
            return null;
        }
        for (File child : childs) {
            if (!this.map.containsKey(child.getAbsolutePath())) {
                this.map.put(child.getAbsolutePath(), false);
            }
            if (this.map.get(child.getAbsolutePath()).booleanValue()) continue;
            return child;
        }
        return null;
    }

    private void bfs() {
        if (this.root == null) {
            return;
        }
        LinkedList<File> queue = new LinkedList<File>();
        queue.add(this.root);
        while (!queue.isEmpty()) {
            File node = (File)queue.remove();
            this.printFiles(this.getTargetFiles(node));
            File[] childs = node.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            });
            if (childs == null) continue;
            for (File child : childs) {
                queue.add(child);
            }
        }
    }
}

