/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.io.file.download;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import org.gjgr.pig.chivalrous.core.io.file.download.Authentication;
import org.gjgr.pig.chivalrous.core.io.file.download.DownloadListener;
import org.gjgr.pig.chivalrous.core.io.file.download.DownloadTask;
import org.gjgr.pig.chivalrous.core.io.file.download.HttpConnector;
import org.gjgr.pig.chivalrous.core.lang.Base64;

public class DirectDownloader
extends HttpConnector
implements Runnable {
    private static Logger logger = Logger.getLogger(DirectDownloader.class.getName());
    private final BlockingQueue<DownloadTask> tasks = new LinkedBlockingQueue<DownloadTask>();
    private final BlockingQueue<DownloadTask> onWork = new LinkedBlockingQueue<DownloadTask>();
    private int poolSize = 4;
    private int bufferSize = 2048;
    private DirectDownloadThread[] dts;
    private Proxy proxy;

    public DirectDownloader() {
    }

    public DirectDownloader(int poolSize) {
        this.poolSize = poolSize;
    }

    public DirectDownloader(Proxy proxy) {
        this.proxy = proxy;
    }

    public DirectDownloader(Proxy proxy, int poolSize) {
        this.poolSize = poolSize;
        this.proxy = proxy;
    }

    public static void updateProgress(double progressPercentage) {
        int i;
        int width = 50;
        System.out.print("\r[");
        for (i = 0; i <= (int)(progressPercentage * 50.0); ++i) {
            System.out.print(".");
        }
        while (i < 50) {
            System.out.print(" ");
            ++i;
        }
        System.out.print("]");
    }

    public void download(DownloadTask dt) {
        this.tasks.add(dt);
    }

    public int size() {
        return this.tasks.size();
    }

    public int status() {
        return this.onWork.size();
    }

    @Override
    public void run() {
        logger.info("Initializing downloader...");
        this.dts = new DirectDownloadThread[this.poolSize];
        for (int i = 0; i < this.dts.length; ++i) {
            try {
                this.dts[i] = new DirectDownloadThread(this.tasks);
                this.dts[i].start();
                continue;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                logger.warning("pool size is big than task, not found any task" + this.dts.length + "/" + this.tasks.size());
            }
        }
        logger.info("Downloader started, waiting for tasks.");
    }

    public void shutdown() {
        for (int i = 0; i < this.dts.length; ++i) {
            if (this.dts[i] == null) continue;
            this.dts[i].shutdown();
        }
    }

    public void cancelAll() {
        for (int i = 0; i < this.dts.length; ++i) {
            if (this.dts[i] == null) continue;
            this.dts[i].cancel();
        }
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    protected class DirectDownloadThread
    extends Thread {
        private static final String CD_FNAME = "fname=";
        private static final String CONTENT_DISPOSITION = "Content-Disposition";
        private final BlockingQueue<DownloadTask> tasks;
        private boolean cancel = false;
        private boolean stop = false;

        public DirectDownloadThread(BlockingQueue<DownloadTask> tasks) {
            this.tasks = tasks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void download(DownloadTask dt) throws IOException, InterruptedException, KeyManagementException, NoSuchAlgorithmException {
            int res;
            String fname;
            HttpURLConnection conn = (HttpURLConnection)DirectDownloader.this.getConnection(dt.getUrl(), DirectDownloader.this.proxy);
            if (dt.getAuthentication() != null) {
                Authentication auth = dt.getAuthentication();
                String authString = auth.getUsername() + ":" + auth.getPassword();
                conn.setRequestProperty("Authorization", "Basic " + Base64.encodeBytes(authString.getBytes()));
            }
            conn.setReadTimeout(dt.getTimeout());
            conn.setDoOutput(true);
            conn.connect();
            int fsize = conn.getContentLength();
            String cd = conn.getHeaderField(CONTENT_DISPOSITION);
            if (cd != null) {
                fname = cd.substring(cd.indexOf(CD_FNAME) + 1, cd.length() - 1);
            } else {
                String url = dt.getUrl().toString();
                fname = url.substring(url.lastIndexOf(47) + 1);
            }
            InputStream is = conn.getInputStream();
            OutputStream os = dt.getOutputStream();
            List<DownloadListener> listeners = dt.getListeners();
            byte[] buff = new byte[DirectDownloader.this.bufferSize];
            for (DownloadListener listener : listeners) {
                listener.onStart(fname, fsize);
            }
            int total = 0;
            while ((res = is.read(buff)) != -1) {
                os.write(buff, 0, res);
                total += res;
                for (DownloadListener downloadListener : listeners) {
                    downloadListener.onUpdate(res, total);
                }
                DownloadTask downloadTask = dt;
                synchronized (downloadTask) {
                    if (this.cancel || dt.isCancelled()) {
                        this.close(is, os);
                        for (DownloadListener listener : listeners) {
                            listener.onCancel();
                        }
                        throw new RuntimeException("Cancelled download");
                    }
                    if (this.stop) {
                        this.close(is, os);
                        for (DownloadListener listener : listeners) {
                            listener.onCancel();
                        }
                        throw new InterruptedException("Shutdown");
                    }
                    while (dt.isPaused()) {
                        try {
                            this.wait();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            for (DownloadListener downloadListener : listeners) {
                downloadListener.onComplete();
            }
            this.close(is, os);
        }

        private void close(InputStream is, OutputStream os) {
            try {
                is.close();
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            while (true) {
                DownloadTask downloadTask = null;
                try {
                    downloadTask = this.tasks.take();
                    try {
                        DirectDownloader.this.onWork.put(downloadTask);
                        this.download(downloadTask);
                    }
                    catch (InterruptedException e) {
                        logger.info("Stopping download thread");
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        DirectDownloader.this.onWork.remove(downloadTask);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void cancel() {
            this.cancel = true;
        }

        public void shutdown() {
            this.stop = true;
        }
    }
}

