/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.io.file.properties;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.io.file.FileCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyCommand.class);

    public static Map<String, String> loadProperties(String ... paths) {
        HashMap<String, String> propertiesHolder = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : PropertyCommand.readProperties(paths).entrySet()) {
            propertiesHolder.put((String)entry.getKey(), (String)entry.getValue());
        }
        return propertiesHolder;
    }

    public static Properties readProperties(String ... paths) {
        Properties p = new Properties();
        for (String path : paths) {
            try {
                p.load(FileCommand.inputStream(path));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return p;
    }

    public boolean propertiesDiff(Properties first, String firstName, Properties second, String secondName) {
        Validate.notNull((Object)first, (String)"first", (Object[])new Object[0]);
        Validate.notNull((Object)second, (String)"second", (Object[])new Object[0]);
        boolean isDiff = false;
        Collection sub1 = CollectionUtils.subtract(first.entrySet(), second.entrySet());
        Collection sub2 = CollectionUtils.subtract(second.entrySet(), first.entrySet());
        if (!sub1.isEmpty()) {
            LOGGER.error("{}.properties is diff with {}.properties:\n{}", new Object[]{firstName, secondName, StringUtils.join((Iterable)sub1, (String)"\n")});
            isDiff = true;
        }
        if (!sub2.isEmpty()) {
            LOGGER.error("{}.properties is diff with {}.properties:\n{}", new Object[]{secondName, firstName, StringUtils.join((Iterable)sub2, (String)"\n")});
            isDiff = true;
        }
        return isDiff;
    }

    public boolean loadPropertiesFromResource(Class<?> clazz, String pathInResource) {
        return this.getPropertiesFromStream(clazz.getResourceAsStream(pathInResource), true) != null;
    }

    public Properties getPropertiesFromResource(Class<?> clazz, String pathInResource) {
        return this.getPropertiesFromStream(clazz.getResourceAsStream(pathInResource), false);
    }

    public Properties getPropertiesFromFile(String filePath) {
        try {
            return this.getPropertiesFromStream(new FileInputStream(filePath), false);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Could not open file: " + filePath, (Throwable)e);
            return null;
        }
    }

    public boolean isProperties(String filePath) {
        try {
            return this.getPropertiesFromStream(new FileInputStream(filePath), true) != null;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Could not open file: " + filePath, (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getPropertiesFromStream(InputStream stream, boolean putToSystemProperties) {
        try {
            Properties properties = new Properties();
            properties.load(stream);
            if (putToSystemProperties) {
                System.getProperties().putAll((Map<?, ?>)properties);
            }
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            LOGGER.error("Could not open properties.", (Throwable)e);
            Properties properties = null;
            return properties;
        }
        finally {
            IoCommand.closeIgnoreException(stream);
        }
    }

    public int getPropertyInt(Properties prop, String key, int defaultValue) {
        String value = prop.getProperty(key);
        return StringUtils.isEmpty((CharSequence)value) ? defaultValue : Integer.parseInt(value.trim());
    }

    public int getPropertyInt(String key, int defaultValue) {
        return this.getPropertyInt(System.getProperties(), key, defaultValue);
    }

    public long getPropertyLong(Properties prop, String key, long defaultValue) {
        String value = prop.getProperty(key);
        return StringUtils.isEmpty((CharSequence)value) ? defaultValue : Long.parseLong(value.trim());
    }

    public long getPropertyLong(String key, long defaultValue) {
        return this.getPropertyLong(System.getProperties(), key, defaultValue);
    }

    public boolean getPropertyBoolean(Properties prop, String key, boolean defaultValue) {
        String value = prop.getProperty(key);
        return StringUtils.isEmpty((CharSequence)value) ? defaultValue : Boolean.parseBoolean(value.trim());
    }

    public boolean getPropertyBoolean(String key, boolean defaultValue) {
        return this.getPropertyBoolean(System.getProperties(), key, defaultValue);
    }

    public String dumpProperties(Properties p, boolean sort) {
        return this.dumpProperties(p, "[[\n    ", "\n    ", "]]\n", sort);
    }

    public String dumpProperties(Properties p, String head, String separator, String tail, boolean sort) {
        Collection<Map.Entry<Object, Object>> entries = p.entrySet();
        if (sort) {
            ArrayList<Map.Entry<Object, Object>> list = new ArrayList<Map.Entry<Object, Object>>(p.entrySet());
            Collections.sort(list, new Comparator<Map.Entry<Object, Object>>(){

                @Override
                public int compare(Map.Entry<Object, Object> o1, Map.Entry<Object, Object> o2) {
                    return o1.getKey().toString().compareTo(o2.getKey().toString());
                }
            });
            entries = list;
        }
        return head + StringUtils.join(entries, (String)separator) + tail;
    }
}

