/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.io.resource;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.io.exception.IORuntimeException;
import org.gjgr.pig.chivalrous.core.io.file.FileCommand;
import org.gjgr.pig.chivalrous.core.net.UriCommand;

public class UrlResource {
    protected URL url;

    public UrlResource(URL url) {
        this.url = url;
    }

    public UrlResource(File file) {
        this.url = UriCommand.getURL(file);
    }

    public final URL getUrl() {
        return this.url;
    }

    public InputStream getStream() {
        if (null == this.url) {
            throw new IORuntimeException("Resource [{}] not isExist!", this.url);
        }
        try {
            return this.url.openStream();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public BufferedReader getReader(Charset charset) {
        return IoCommand.getReader(this.getStream(), charset);
    }

    public File getFile() {
        return FileCommand.file(this.url);
    }

    public String toString() {
        return null == this.url ? "null" : this.url.toString();
    }
}

