/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.json;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import org.gjgr.pig.chivalrous.core.convert.Convert;
import org.gjgr.pig.chivalrous.core.convert.ConvertException;
import org.gjgr.pig.chivalrous.core.convert.ConverterRegistry;
import org.gjgr.pig.chivalrous.core.json.JsonCommand;
import org.gjgr.pig.chivalrous.core.json.JsonException;
import org.gjgr.pig.chivalrous.core.json.bean.Json;
import org.gjgr.pig.chivalrous.core.json.bean.JsonArray;
import org.gjgr.pig.chivalrous.core.json.bean.JsonNull;
import org.gjgr.pig.chivalrous.core.json.bean.JsonObject;
import org.gjgr.pig.chivalrous.core.json.bean.JsonString;
import org.gjgr.pig.chivalrous.core.lang.BeanUtil;
import org.gjgr.pig.chivalrous.core.lang.ObjectCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.math.NumberCommand;

public final class InternalJsonUtil {
    private InternalJsonUtil() {
    }

    public static final Writer writeValue(Writer writer, Object value, int indentFactor, int indent) throws JsonException, IOException {
        if (value == null || value.equals(null)) {
            writer.write("null");
        } else if (value instanceof Json) {
            ((Json)value).write(writer, indentFactor, indent);
        } else if (value instanceof Map) {
            new JsonObject((Map)value).write(writer, indentFactor, indent);
        } else if (value instanceof Collection) {
            new JsonArray((Collection)value).write(writer, indentFactor, indent);
        } else if (value.getClass().isArray()) {
            new JsonArray(value).write(writer, indentFactor, indent);
        } else if (value instanceof Number) {
            writer.write(NumberCommand.toStr((Number)value));
        } else if (value instanceof Boolean) {
            writer.write(value.toString());
        } else if (value instanceof JsonString) {
            String o;
            try {
                o = ((JsonString)value).toJSONString();
            }
            catch (Exception e) {
                throw new JsonException(e);
            }
            writer.write(o != null ? o.toString() : JsonCommand.quote(value.toString()));
        } else {
            JsonCommand.quote(value.toString(), writer);
        }
        return writer;
    }

    public static final void indent(Writer writer, int indent) throws IOException {
        for (int i = 0; i < indent; ++i) {
            writer.write(32);
        }
    }

    public static void testValidity(Object obj) throws JsonException {
        if (!ObjectCommand.isValidIfNumber(obj)) {
            throw new JsonException("Json does not allow non-finite numbers.");
        }
    }

    public static String valueToString(Object value) throws JsonException {
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (value instanceof JsonString) {
            try {
                return ((JsonString)value).toJSONString();
            }
            catch (Exception e) {
                throw new JsonException(e);
            }
        }
        if (value instanceof Number) {
            return NumberCommand.toStr((Number)value);
        }
        if (value instanceof Boolean || value instanceof JsonObject || value instanceof JsonArray) {
            return value.toString();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return new JsonObject(map).toString();
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            return new JsonArray(coll).toString();
        }
        if (value.getClass().isArray()) {
            return new JsonArray(value).toString();
        }
        return JsonCommand.quote(value.toString());
    }

    public static Object stringToValue(String string) {
        if (null == string || "null".equalsIgnoreCase(string)) {
            return JsonNull.NULL;
        }
        if ("".equals(string)) {
            return string;
        }
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        char b = string.charAt(0);
        if (b >= '0' && b <= '9' || b == '-') {
            try {
                if (string.indexOf(46) > -1 || string.indexOf(101) > -1 || string.indexOf(69) > -1) {
                    Double d = Double.valueOf(string);
                    if (!d.isInfinite() && !d.isNaN()) {
                        return d;
                    }
                } else {
                    Long myLong = new Long(string);
                    if (string.equals(myLong.toString())) {
                        if (myLong == (long)myLong.intValue()) {
                            return myLong.intValue();
                        }
                        return myLong;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public static JsonObject propertyPut(JsonObject jsonObject, Object key, Object value) {
        String keyStr = Convert.toStr(key);
        String[] path = StringCommand.split(keyStr, ".");
        int last = path.length - 1;
        JsonObject target = jsonObject;
        for (int i = 0; i < last; ++i) {
            String segment = path[i];
            JsonObject nextTarget = target.getJSONObject(segment);
            if (nextTarget == null) {
                nextTarget = new JsonObject();
                target.put(segment, (Object)nextTarget);
            }
            target = nextTarget;
        }
        target.put(path[last], value);
        return jsonObject;
    }

    public static <T> T toBean(final JsonObject jsonObject, T bean, final boolean ignoreError) {
        return BeanUtil.fillBean(bean, new BeanUtil.ValueProvider<String>(){

            @Override
            public Object value(String key, Class<?> valueType) {
                return InternalJsonUtil.jsonConvert(valueType, jsonObject.get(key), ignoreError);
            }

            @Override
            public boolean containsKey(String key) {
                return jsonObject.containsKey(key);
            }
        }, BeanUtil.CopyOptions.create().setIgnoreError(ignoreError));
    }

    public static <T> T jsonConvert(Class<T> type, Object value, boolean ignoreError) throws ConvertException {
        if (null == value) {
            return null;
        }
        T targetValue = null;
        try {
            targetValue = ConverterRegistry.getInstance().convert(type, value);
        }
        catch (ConvertException convertException) {
            // empty catch block
        }
        if (null == targetValue && value instanceof JsonObject) {
            targetValue = JsonCommand.fromJson(value.toString(), type);
        }
        if (null == targetValue) {
            throw new ConvertException("Can not convert to type [{}]", type.getName());
        }
        return targetValue;
    }
}

