/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class JsonAdapter
implements JsonSerializer,
JsonDeserializer {
    private String CLASSNAME = "CLASSNAME";
    private String DATA = "DATA";

    public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonPrimitive prim = (JsonPrimitive)json.getAsJsonObject().get(this.CLASSNAME);
        String className = prim.getAsString();
        Class klass = this.getObjectClass(className);
        return context.deserialize(json.getAsJsonObject().get(this.DATA), (Type)klass);
    }

    public JsonElement serialize(Object src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(this.CLASSNAME, src.getClass().getName());
        jsonObject.add(this.DATA, context.serialize(src));
        return jsonObject;
    }

    public Class getObjectClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new JsonParseException(e.getMessage());
        }
    }
}

