/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.type.TypeVariable;
import org.gjgr.pig.chivalrous.core.io.exception.IORuntimeException;
import org.gjgr.pig.chivalrous.core.io.file.FileReader;
import org.gjgr.pig.chivalrous.core.io.file.yml.YmlNode;
import org.gjgr.pig.chivalrous.core.json.InternalJsonUtil;
import org.gjgr.pig.chivalrous.core.json.bean.Json;
import org.gjgr.pig.chivalrous.core.json.bean.JsonArray;
import org.gjgr.pig.chivalrous.core.json.bean.JsonNull;
import org.gjgr.pig.chivalrous.core.json.bean.JsonObject;
import org.gjgr.pig.chivalrous.core.json.bean.JsonString;
import org.gjgr.pig.chivalrous.core.lang.ArrayCommand;
import org.gjgr.pig.chivalrous.core.lang.ObjectCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.xml.XmlBetweenJsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonCommand {
    private static Gson gson = null;
    private static GsonBuilder gsonBuilder = new GsonBuilder();
    private static Logger logger = LoggerFactory.getLogger(JsonCommand.class);

    public static JsonElement parseJsonElement(String str) {
        return new JsonParser().parse(str);
    }

    public static <T> T parse(String str, TypeToken typeToken) {
        return (T)new Gson().fromJson(str, typeToken.getType());
    }

    public static <T> T parse(String str, Type type) {
        if (!(type instanceof ParameterizedType) && !(type instanceof TypeVariable)) {
            if (type instanceof GenericArrayType) {
                return (T)Arrays.asList((Object[])gson.fromJson(str, type));
            }
            if (type instanceof WildcardType) {
                // empty if block
            }
        }
        return null;
    }

    public static JsonElement convert(JsonObject jsonObject) {
        JsonElement jsonElement = jsonObject.gson();
        return jsonElement;
    }

    public static String toJson(Object obj) {
        if (gson == null) {
            gson = new Gson();
        }
        return gson.toJson(obj);
    }

    public static String json(Object object) {
        Gson gson = gsonBuilder.create();
        return gson.toJson(object);
    }

    public static JsonElement jsonElement(Object object) {
        String string = JsonCommand.json(object);
        JsonElement jsonElement = JsonCommand.jsonElement(string);
        return jsonElement;
    }

    public static JsonElement jsonElement(String str) {
        return new JsonParser().parse(str);
    }

    public static com.google.gson.JsonArray jsonArray(Object object) {
        String string = JsonCommand.json(object);
        com.google.gson.JsonArray jsonElement = JsonCommand.jsonArray(string);
        return jsonElement;
    }

    public static com.google.gson.JsonArray listStringJsonArray(List<String> strings) {
        com.google.gson.JsonArray jsonArray = new com.google.gson.JsonArray();
        if (strings != null) {
            for (String s : strings) {
                jsonArray.add((JsonElement)new JsonPrimitive(s));
            }
            return jsonArray;
        }
        return jsonArray;
    }

    public static com.google.gson.JsonArray listStringJsonArray(Set<String> strings) {
        return JsonCommand.listStringJsonArray(new LinkedList<String>(strings));
    }

    public static com.google.gson.JsonArray jsonArray(String str) {
        JsonElement jsonElement = JsonCommand.jsonElement(str);
        if (jsonElement.isJsonArray()) {
            return jsonElement.getAsJsonArray();
        }
        return new com.google.gson.JsonArray();
    }

    public static com.google.gson.JsonObject jsonObject(Object object) {
        String string = JsonCommand.json(object);
        com.google.gson.JsonObject jsonElement = JsonCommand.jsonObject(string);
        return jsonElement;
    }

    public static com.google.gson.JsonObject jsonObject(String str) {
        JsonElement jsonElement = JsonCommand.jsonElement(str);
        if (jsonElement.isJsonObject()) {
            return jsonElement.getAsJsonObject();
        }
        return new com.google.gson.JsonObject();
    }

    public static String serializer(Object ts, final String dateformat) {
        String jsonStr = null;
        gson = new GsonBuilder().registerTypeHierarchyAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                SimpleDateFormat format = new SimpleDateFormat(dateformat);
                return new JsonPrimitive(format.format(src));
            }
        }).setDateFormat(dateformat).create();
        if (gson != null) {
            jsonStr = gson.toJson(ts);
        }
        return jsonStr;
    }

    public static <T> T serializer(String jsonStr, Class<T> cl, final String pattern) {
        Object obj = null;
        gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                SimpleDateFormat format = new SimpleDateFormat(pattern);
                String dateStr = json.getAsString();
                try {
                    return format.parse(dateStr);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }).setDateFormat(pattern).create();
        if (gson != null) {
            obj = gson.fromJson(jsonStr, cl);
        }
        return (T)obj;
    }

    public static <T> T fromJson(String str, Class<T> type) {
        if (gson == null) {
            gson = new Gson();
        }
        if (type.getName().equalsIgnoreCase(com.google.gson.JsonObject.class.getName()) || type.getName().equalsIgnoreCase(com.google.gson.JsonArray.class.getName()) || type.getName().equalsIgnoreCase(JsonElement.class.getName())) {
            return type.cast(JsonCommand.fromJson(str));
        }
        return (T)gson.fromJson(str, type);
    }

    public static <T> T fromObject(Object object, Class<T> clazz) {
        String json = JsonCommand.toJson(object);
        return JsonCommand.to(json, clazz);
    }

    public static <T> List<T> toArrayList(String json, Class<T> clazz) {
        Object[] array = (Object[])Array.newInstance(clazz, 0);
        array = (Object[])gson.fromJson(json, array.getClass());
        ArrayList<T> list = new ArrayList<T>();
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                list.add(clazz.cast(array[i]));
            }
        }
        return list;
    }

    public static <T> List<T> toList(String json, Class<T> clazz) {
        return JsonCommand.toArrayList(json, clazz);
    }

    public static <T> T[] toArray(String json, Class<T> clazz) {
        Object[] array = (Object[])Array.newInstance(clazz, 0);
        array = (Object[])gson.fromJson(json, array.getClass());
        return array;
    }

    public static <T> List<T> toArrayList(JsonElement jsonElement, Class<T> clazz) {
        return JsonCommand.toArrayList(JsonCommand.toJson(jsonElement), clazz);
    }

    public static <T> T to(String str, Class<T> clazz) {
        if (clazz.isArray()) {
            // empty if block
        }
        return JsonCommand.fromJson(str, clazz);
    }

    public static <T> T to(JsonElement jsonElement, Class<T> clazz) {
        String string = JsonCommand.toJson(jsonElement);
        return JsonCommand.to(string, clazz);
    }

    public static JsonElement fromJson(String str) {
        JsonParser jsonParser = new JsonParser();
        return jsonParser.parse(str);
    }

    public static com.google.gson.JsonObject fromXml(String xmlStr) {
        JsonElement jsonElement = XmlBetweenJsonObject.toJSONObject(xmlStr).gson();
        if (jsonElement.isJsonObject()) {
            return jsonElement.getAsJsonObject();
        }
        return new com.google.gson.JsonObject();
    }

    public static com.google.gson.JsonObject fromMap(Map<?, ?> map) {
        JsonElement jsonElement = new JsonObject(map).gson();
        if (jsonElement.isJsonObject()) {
            return jsonElement.getAsJsonObject();
        }
        return new com.google.gson.JsonObject();
    }

    public static JsonObject fromResourceBundle(ResourceBundle bundle) {
        JsonObject jsonObject = new JsonObject();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key == null) continue;
            InternalJsonUtil.propertyPut(jsonObject, key, bundle.getString(key));
        }
        return jsonObject;
    }

    private static JsonObject newJsonObject() {
        return new JsonObject();
    }

    private static JsonArray newJsonArray() {
        return new JsonArray();
    }

    private static JsonObject newJsonObject(String jsonStr) {
        return new JsonObject(jsonStr);
    }

    private static JsonObject newJsonObject(Object obj) {
        return new JsonObject(obj);
    }

    public static JsonArray newJsonArray(String jsonStr) {
        return new JsonArray(jsonStr);
    }

    public static Json newJson(Object obj) {
        String jsonStr;
        if (null == obj) {
            return null;
        }
        Object json = null;
        json = obj instanceof Json ? (Json)obj : (obj instanceof String ? ((jsonStr = ((String)obj).trim()).startsWith("[") ? JsonCommand.newJsonArray(jsonStr) : JsonCommand.newJsonObject(jsonStr)) : (obj instanceof Collection || obj.getClass().isArray() ? new JsonArray(obj) : new JsonObject(obj)));
        return json;
    }

    public static Json readJSON(File file, Charset charset) throws IORuntimeException {
        return JsonCommand.newJson(FileReader.create(file, charset).readString());
    }

    public static JsonObject readJSONObject(File file, Charset charset) throws IORuntimeException {
        return JsonCommand.newJsonObject(FileReader.create(file, charset).readString());
    }

    public static JsonArray readJSONArray(File file, Charset charset) throws IORuntimeException {
        return JsonCommand.newJsonArray(FileReader.create(file, charset).readString());
    }

    public static String string(Json json, int indentFactor) {
        return json.toJSONString(indentFactor);
    }

    public static String string(Json json) {
        return json.toJSONString(0);
    }

    public static String stringPretty(Json json) {
        return json.toJSONString(4);
    }

    public static String string(Object obj) {
        String str = null;
        gson = new Gson();
        try {
            str = gson.toJson(obj);
        }
        catch (Exception e) {
            str = JsonCommand.string(JsonCommand.newJson(obj));
        }
        return str;
    }

    public static String stringPretty(Object obj) {
        return JsonCommand.stringPretty(JsonCommand.newJson(obj));
    }

    public static String stringXml(Json json) {
        return XmlBetweenJsonObject.toString(json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String quote(String string) {
        StringWriter sw = new StringWriter();
        StringBuffer stringBuffer = sw.getBuffer();
        synchronized (stringBuffer) {
            try {
                return JsonCommand.quote(string, sw).toString();
            }
            catch (IOException ignored) {
                return "";
            }
        }
    }

    public static Writer quote(String string, Writer writer) throws IOException {
        if (StringCommand.isEmpty(string)) {
            writer.write("\"\"");
            return writer;
        }
        char c = '\u0000';
        int len = string.length();
        writer.write(34);
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    writer.write(92);
                    writer.write(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        writer.write(92);
                    }
                    writer.write(c);
                    continue block9;
                }
                case '\b': {
                    writer.write("\\b");
                    continue block9;
                }
                case '\t': {
                    writer.write("\\t");
                    continue block9;
                }
                case '\n': {
                    writer.write("\\n");
                    continue block9;
                }
                case '\f': {
                    writer.write("\\f");
                    continue block9;
                }
                case '\r': {
                    writer.write("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        writer.write("\\u");
                        String hhhh = Integer.toHexString(c);
                        writer.write("0000", 0, 4 - hhhh.length());
                        writer.write(hhhh);
                        continue block9;
                    }
                    writer.write(c);
                }
            }
        }
        writer.write(34);
        return writer;
    }

    public static Object wrap(Object object) {
        try {
            String objectPackageName;
            if (object == null) {
                return JsonNull.NULL;
            }
            if (object instanceof Json || JsonNull.NULL.equals(object) || object instanceof JsonString || object instanceof CharSequence || object instanceof Number || ObjectCommand.isBasicType(object)) {
                return object;
            }
            if (object instanceof Collection) {
                Collection coll = (Collection)object;
                return new JsonArray(coll);
            }
            if (ArrayCommand.isArray(object)) {
                return new JsonArray(object);
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                return new JsonObject(map);
            }
            Package objectPackage = object.getClass().getPackage();
            String string = objectPackageName = objectPackage != null ? objectPackage.getName() : "";
            if (objectPackageName.startsWith("java.") || objectPackageName.startsWith("javax.") || object.getClass().getClassLoader() == null) {
                return object.toString();
            }
            return new JsonObject(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static JsonPrimitive replace(Map map, JsonPrimitive jsonPrimitive) {
        JsonPrimitive data = null;
        if (jsonPrimitive.isString()) {
            String key = jsonPrimitive.getAsString();
            if (map.containsKey(key)) {
                data = new JsonPrimitive(map.get(jsonPrimitive.getAsString()).toString());
            }
        } else {
            String key = jsonPrimitive.getAsString();
            if (map.containsKey(key)) {
                data = new JsonPrimitive(map.get(jsonPrimitive.toString()).toString());
            }
        }
        return data;
    }

    public static com.google.gson.JsonObject replace(YmlNode ymlNode, JsonElement jsonElement, String to, com.google.gson.JsonObject data) {
        block8: {
            try {
                Map map = ymlNode.map();
                if (jsonElement.isJsonPrimitive()) {
                    JsonPrimitive temp = jsonElement.getAsJsonPrimitive();
                    data.add(to, (JsonElement)JsonCommand.replace(map, temp));
                } else if (jsonElement.isJsonArray()) {
                    com.google.gson.JsonArray temp = jsonElement.getAsJsonArray();
                    com.google.gson.JsonArray newTemp = new com.google.gson.JsonArray();
                    temp.forEach(element -> {
                        if (element.isJsonPrimitive()) {
                            JsonPrimitive cache = element.getAsJsonPrimitive();
                            JsonPrimitive newCache = JsonCommand.replace(map, cache);
                            if (newCache != null) {
                                newTemp.add((JsonElement)newCache);
                            } else {
                                newTemp.add((JsonElement)cache);
                            }
                        }
                    });
                    data.add(to, (JsonElement)newTemp);
                } else if (jsonElement == null || jsonElement.isJsonNull()) {
                    logger.debug("skip null field about element", (Object)data);
                } else {
                    logger.error("could not hand replace operation. about:{}", (Object)jsonElement);
                }
            }
            catch (Exception e) {
                String string = ymlNode.string();
                if (string == null) break block8;
                data.addProperty(to, string);
            }
        }
        return data;
    }

    public static com.google.gson.JsonArray arrayFormat(YmlNode ymlNode, com.google.gson.JsonObject jsonObject) {
        com.google.gson.JsonArray jsonArray = new com.google.gson.JsonArray();
        if (ymlNode.get("source").list() != null) {
            List list = ymlNode.get("source").list();
            list.forEach(s -> {
                try {
                    com.google.gson.JsonArray array = (com.google.gson.JsonArray)jsonObject.get(s.toString());
                    array.forEach(element -> {
                        try {
                            com.google.gson.JsonObject data = JsonCommand.format(ymlNode, (com.google.gson.JsonObject)element);
                            jsonArray.add((JsonElement)data);
                        }
                        catch (Exception e) {
                            logger.error("should be a jsonObject in {} JsonArray", s, (Object)e);
                        }
                    });
                }
                catch (Exception e) {
                    logger.error("must be JsonArray format.", (Throwable)e);
                }
            });
            return jsonArray;
        }
        logger.error("should input a array refer about jsonobject");
        return null;
    }

    public static com.google.gson.JsonObject format(YmlNode ymlNode, com.google.gson.JsonObject jsonObject) {
        List listScheme;
        com.google.gson.JsonObject source;
        com.google.gson.JsonObject messageData = new com.google.gson.JsonObject();
        Map scheme = ymlNode.get("data").map();
        Map map = ymlNode.get("source").map();
        if (map != null && map.size() > 0) {
            source = new com.google.gson.JsonObject();
            map.forEach((key, value) -> {
                if (key.equals(value)) {
                    JsonElement tempSource = jsonObject.get(key.toString());
                    if (tempSource.isJsonObject()) {
                        com.google.gson.JsonObject referSource = (com.google.gson.JsonObject)tempSource;
                        referSource.entrySet().forEach(json -> source.add((String)json.getKey(), (JsonElement)json.getValue()));
                    }
                } else {
                    source.add(value.toString(), jsonObject.get(key.toString()));
                }
            });
        } else {
            source = jsonObject;
        }
        scheme.forEach((key, value) -> {
            if (value instanceof String) {
                Object oo = JsonCommand.getEntity(source, value.toString());
                if (oo != null) {
                    messageData.addProperty(key.toString(), oo.toString());
                } else {
                    messageData.add(key.toString(), (JsonElement)com.google.gson.JsonNull.INSTANCE);
                }
            } else if (value instanceof List) {
                com.google.gson.JsonArray array = (com.google.gson.JsonArray)JsonCommand.getEntity(source, value);
                if (array != null && array.size() > 0) {
                    messageData.add(key.toString(), (JsonElement)array);
                } else {
                    messageData.add(key.toString(), (JsonElement)com.google.gson.JsonNull.INSTANCE);
                }
            } else if (value instanceof Map) {
                com.google.gson.JsonObject object = (com.google.gson.JsonObject)JsonCommand.getEntity(source, value);
                if (object != null && object.size() > 0) {
                    messageData.add(key.toString(), (JsonElement)object);
                } else {
                    messageData.add(key.toString(), (JsonElement)com.google.gson.JsonNull.INSTANCE);
                }
            }
        });
        map = ymlNode.get("mapData").map();
        if (map != null && map.size() > 0) {
            List mapScheme = ymlNode.get("mapScheme").list();
            mapScheme.forEach(s -> {
                JsonElement jsonElement = messageData.get(s.toString());
                YmlNode newValue = ymlNode.get("mapData").get(s.toString());
                JsonCommand.replace(newValue, jsonElement, s.toString(), messageData);
            });
        }
        if ((listScheme = ymlNode.get("set").list()) != null && listScheme.size() > 0) {
            listScheme.forEach(l -> {
                JsonElement jsonElement = messageData.get(l.toString());
                if (jsonElement != null) {
                    HashSet data = new HashSet();
                    if (jsonElement.isJsonArray()) {
                        jsonElement.getAsJsonArray().forEach(e -> {
                            if (e.isJsonPrimitive()) {
                                data.add(e.getAsJsonPrimitive());
                            }
                        });
                        if (data.size() > 0) {
                            try {
                                messageData.remove(l.toString());
                                com.google.gson.JsonArray covert = new com.google.gson.JsonArray();
                                data.forEach(value -> covert.add((JsonElement)value));
                                messageData.add(l.toString(), (JsonElement)covert);
                            }
                            catch (Exception e2) {
                                messageData.add(l.toString(), jsonElement);
                                logger.debug("could not set the field. reset the value to default.");
                            }
                        }
                    }
                }
            });
        }
        return messageData;
    }

    private static JsonElement getJsonEntity(com.google.gson.JsonObject data, String key) {
        Object oo = null;
        oo = data.has(key) ? (data.get(key).isJsonPrimitive() ? data.get(key).getAsJsonPrimitive() : (data.get(key).isJsonArray() ? data.get(key).getAsJsonArray() : (data.get(key).isJsonObject() ? data.get(key).getAsJsonObject() : null))) : com.google.gson.JsonNull.INSTANCE;
        return oo;
    }

    private static Object getEntity(com.google.gson.JsonObject data, Object key) {
        Object oo;
        if (key instanceof String) {
            if (data.has(key.toString())) {
                if (data.get(key.toString()).isJsonPrimitive()) {
                    JsonPrimitive jsonPrimitive = data.get(key.toString()).getAsJsonPrimitive();
                    oo = jsonPrimitive.isString() ? jsonPrimitive.getAsString() : (jsonPrimitive.isBoolean() ? Boolean.valueOf(jsonPrimitive.getAsBoolean()) : (jsonPrimitive.isNumber() ? jsonPrimitive.getAsNumber() : jsonPrimitive.getAsString()));
                } else if (data.get(key.toString()).isJsonArray()) {
                    com.google.gson.JsonArray jsonElements = data.get(key.toString()).getAsJsonArray();
                    StringBuilder stringBuilder = new StringBuilder();
                    jsonElements.forEach(element -> stringBuilder.append(element.toString()));
                    oo = stringBuilder.toString();
                } else if (data.get(key.toString()).isJsonObject()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    com.google.gson.JsonObject jsonObject = data.get(key.toString()).getAsJsonObject();
                    jsonObject.entrySet().forEach(entry -> stringBuilder.append(JsonCommand.getEntity(data, entry.getKey())));
                    oo = stringBuilder.toString();
                } else {
                    oo = null;
                }
            } else {
                oo = null;
            }
        } else if (key instanceof List) {
            com.google.gson.JsonArray jsonArray = new com.google.gson.JsonArray();
            List list = (List)key;
            list.forEach(l -> {
                if (l instanceof String) {
                    JsonElement ooo = JsonCommand.getJsonEntity(data, l.toString());
                    if (ooo instanceof com.google.gson.JsonArray) {
                        jsonArray.addAll((com.google.gson.JsonArray)ooo);
                    } else {
                        jsonArray.add(ooo);
                    }
                } else {
                    Object ooo = JsonCommand.getEntity(data, l);
                    if (ooo != null) {
                        if (ooo instanceof JsonElement) {
                            jsonArray.add((JsonElement)ooo);
                        } else {
                            jsonArray.add(ooo.toString());
                        }
                    }
                }
            });
            oo = jsonArray;
        } else if (key instanceof Map) {
            com.google.gson.JsonObject jsonObject = new com.google.gson.JsonObject();
            Map map = (Map)key;
            map.forEach((k, v) -> {
                if (v instanceof String) {
                    JsonElement ooo = JsonCommand.getJsonEntity(data, v.toString());
                    jsonObject.add(k.toString(), ooo);
                } else {
                    Object ooo = JsonCommand.getEntity(data, v);
                    jsonObject.addProperty(k.toString(), ooo.toString());
                }
            });
            oo = jsonObject;
        } else {
            logger.warn("did not support this type:{} for yml config in the map config file.", key);
            return null;
        }
        return oo;
    }

    public static com.google.gson.JsonArray formatToArray(YmlNode ymlNode, com.google.gson.JsonObject jsonObject) {
        com.google.gson.JsonArray jsonArray = new com.google.gson.JsonArray();
        String index = ymlNode.get("index").string();
        if (index == null) {
            logger.error("config error could not covert the data to array.");
        } else {
            try {
                int size = jsonObject.get(index).getAsJsonArray().size();
                int i = 0;
                while (i < size) {
                    com.google.gson.JsonObject covert = new com.google.gson.JsonObject();
                    List scheme = ymlNode.get("scheme").list();
                    int[] j = new int[]{i++};
                    scheme.forEach(s -> {
                        if (jsonObject.has(s.toString()) && jsonObject.get(s.toString()) != null) {
                            if (jsonObject.get(s.toString()).isJsonArray()) {
                                covert.add(s.toString(), jsonObject.get(s.toString()).getAsJsonArray().get(j[0]));
                            } else if (jsonObject.get(s.toString()).isJsonPrimitive()) {
                                covert.add(s.toString(), (JsonElement)jsonObject.get(s.toString()).getAsJsonPrimitive());
                            } else if (jsonObject.get(s.toString()).isJsonObject()) {
                                covert.add(s.toString(), (JsonElement)jsonObject.get(s.toString()).getAsJsonObject());
                            } else {
                                covert.add(s.toString(), (JsonElement)com.google.gson.JsonNull.INSTANCE);
                            }
                        } else {
                            covert.add(s.toString(), null);
                        }
                    });
                    com.google.gson.JsonObject result = JsonCommand.format(ymlNode, covert);
                    jsonArray.add((JsonElement)result);
                }
            }
            catch (Exception e) {
                logger.error("type not correct {}. cause by {}", (Object)jsonObject, (Object)e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        return jsonArray;
    }

    public static com.google.gson.JsonObject merge(com.google.gson.JsonObject left, com.google.gson.JsonObject right) {
        Set ss = right.entrySet();
        for (Map.Entry sss : ss) {
            if (left.has((String)sss.getKey())) {
                throw new UnsupportedOperationException("left jsonObject and right jsonObject has conflict key:" + (String)sss.getKey());
            }
            left.add((String)sss.getKey(), (JsonElement)sss.getValue());
        }
        return left;
    }

    public static com.google.gson.JsonObject mergeInLeft(com.google.gson.JsonObject left, com.google.gson.JsonObject right) {
        Set ss = right.entrySet();
        for (Map.Entry sss : ss) {
            if (left.has((String)sss.getKey())) continue;
            left.add((String)sss.getKey(), (JsonElement)sss.getValue());
        }
        return left;
    }

    public static com.google.gson.JsonObject mergeInRight(com.google.gson.JsonObject left, com.google.gson.JsonObject right) {
        return JsonCommand.mergeInLeft(right, left);
    }

    static {
        gsonBuilder.serializeNulls();
        if (gson == null) {
            gson = new Gson();
        }
        if (gson == null) {
            gson = new Gson();
        }
    }
}

