/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.json.bean;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.gjgr.pig.chivalrous.core.json.InternalJsonUtil;
import org.gjgr.pig.chivalrous.core.json.JsonCommand;
import org.gjgr.pig.chivalrous.core.json.JsonException;
import org.gjgr.pig.chivalrous.core.json.JsonGetter;
import org.gjgr.pig.chivalrous.core.json.JsonTokener;
import org.gjgr.pig.chivalrous.core.json.bean.Json;
import org.gjgr.pig.chivalrous.core.json.bean.JsonNull;
import org.gjgr.pig.chivalrous.core.json.bean.JsonObject;

public class JsonArray
extends JsonGetter<Integer>
implements Json,
List<Object> {
    private final ArrayList<Object> rawArrayList = new ArrayList();

    public JsonArray() {
    }

    public JsonArray(JsonTokener x) throws JsonException {
        this();
        if (x.nextClean() != '[') {
            throw x.syntaxError("A JsonArray text must start with '['");
        }
        if (x.nextClean() != ']') {
            x.back();
            block4: while (true) {
                if (x.nextClean() == ',') {
                    x.back();
                    this.rawArrayList.add(JsonNull.NULL);
                } else {
                    x.back();
                    this.rawArrayList.add(x.nextValue());
                }
                switch (x.nextClean()) {
                    case ',': {
                        if (x.nextClean() == ']') {
                            return;
                        }
                        x.back();
                        continue block4;
                    }
                    case ']': {
                        return;
                    }
                }
                break;
            }
            throw x.syntaxError("Expected a ',' or ']'");
        }
    }

    public JsonArray(String source) throws JsonException {
        this(new JsonTokener(source));
    }

    public JsonArray(Object arrayOrCollection) throws JsonException {
        this();
        if (arrayOrCollection.getClass().isArray()) {
            int length = Array.getLength(arrayOrCollection);
            for (int i = 0; i < length; ++i) {
                this.put(JsonCommand.wrap(Array.get(arrayOrCollection, i)));
            }
        } else if (arrayOrCollection instanceof Iterable) {
            for (Object o : (Collection)arrayOrCollection) {
                this.add(o);
            }
        } else {
            throw new JsonException("JsonArray initial value should be a string or collection or array.");
        }
    }

    public boolean isNull(int index) {
        return JsonNull.NULL.equals(this.getObj(index));
    }

    public String join(String separator) throws JsonException {
        int len = this.rawArrayList.size();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(InternalJsonUtil.valueToString(this.rawArrayList.get(i)));
        }
        return sb.toString();
    }

    @Override
    public Object getObj(Integer index, Object defaultValue) {
        return index < 0 || index >= this.size() ? defaultValue : this.rawArrayList.get(index);
    }

    public JsonArray put(Object value) {
        this.add(value);
        return this;
    }

    public JsonArray put(int index, Object value) throws JsonException {
        this.add(index, value);
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof JsonArray)) {
            return false;
        }
        int len = this.size();
        if (len != ((JsonArray)other).size()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            Object valueThis = this.getObj(i);
            Object valueOther = ((JsonArray)other).getObj(i);
            if (!(valueThis instanceof JsonObject ? !((JsonObject)valueThis).equals(valueOther) : (valueThis instanceof JsonArray ? !((JsonArray)valueThis).equals(valueOther) : !valueThis.equals(valueOther)))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        try {
            return this.toJSONString(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public JsonObject toJSONObject(JsonArray names) throws JsonException {
        if (names == null || names.size() == 0 || this.size() == 0) {
            return null;
        }
        JsonObject jo = new JsonObject();
        for (int i = 0; i < names.size(); ++i) {
            jo.put(names.getStr(i), this.getObj(i));
        }
        return jo;
    }

    @Override
    public Writer write(Writer writer) throws JsonException {
        return this.write(writer, 0, 0);
    }

    @Override
    public Writer write(Writer writer, int indentFactor, int indent) throws JsonException {
        try {
            boolean commanate = false;
            int length = this.size();
            writer.write(91);
            if (length == 1) {
                InternalJsonUtil.writeValue(writer, this.rawArrayList.get(0), indentFactor, indent);
            } else if (length != 0) {
                int newindent = indent + indentFactor;
                for (int i = 0; i < length; ++i) {
                    if (commanate) {
                        writer.write(44);
                    }
                    if (indentFactor > 0) {
                        writer.write(10);
                    }
                    InternalJsonUtil.indent(writer, newindent);
                    InternalJsonUtil.writeValue(writer, this.rawArrayList.get(i), indentFactor, newindent);
                    commanate = true;
                }
                if (indentFactor > 0) {
                    writer.write(10);
                }
                InternalJsonUtil.indent(writer, indent);
            }
            writer.write(93);
            return writer;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toJSONString(int indentFactor) throws JsonException {
        StringWriter sw = new StringWriter();
        StringBuffer stringBuffer = sw.getBuffer();
        synchronized (stringBuffer) {
            return this.write(sw, indentFactor, 0).toString();
        }
    }

    @Override
    public int size() {
        return this.rawArrayList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rawArrayList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.rawArrayList.contains(o);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.rawArrayList.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.rawArrayList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.rawArrayList.toArray(a);
    }

    @Override
    public boolean add(Object e) {
        return this.rawArrayList.add(JsonCommand.wrap(e));
    }

    @Override
    public boolean remove(Object o) {
        return this.rawArrayList.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.rawArrayList.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        for (Object object : c) {
            this.add(object);
        }
        return this.rawArrayList.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Object> c) {
        return this.rawArrayList.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.rawArrayList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.rawArrayList.retainAll(c);
    }

    @Override
    public void clear() {
        this.rawArrayList.clear();
    }

    @Override
    public Object get(int index) {
        return this.rawArrayList.get(index);
    }

    @Override
    public Object set(int index, Object element) {
        return this.rawArrayList.set(index, JsonCommand.wrap(element));
    }

    @Override
    public void add(int index, Object element) {
        if (index < 0) {
            throw new JsonException("JsonArray[" + index + "] not found.");
        }
        if (index < this.size()) {
            InternalJsonUtil.testValidity(element);
            this.rawArrayList.set(index, JsonCommand.wrap(element));
        } else {
            while (index != this.size()) {
                this.add(JsonNull.NULL);
            }
            this.put(element);
        }
    }

    @Override
    public Object remove(int index) {
        return index >= 0 && index < this.size() ? this.rawArrayList.remove(index) : null;
    }

    @Override
    public int indexOf(Object o) {
        return this.rawArrayList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.rawArrayList.lastIndexOf(o);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.rawArrayList.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return this.rawArrayList.listIterator(index);
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        return this.rawArrayList.subList(fromIndex, toIndex);
    }
}

