/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.json.bean;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gjgr.pig.chivalrous.core.convert.Convert;
import org.gjgr.pig.chivalrous.core.json.InternalJsonUtil;
import org.gjgr.pig.chivalrous.core.json.JsonCommand;
import org.gjgr.pig.chivalrous.core.json.JsonException;
import org.gjgr.pig.chivalrous.core.json.JsonGetter;
import org.gjgr.pig.chivalrous.core.json.JsonTokener;
import org.gjgr.pig.chivalrous.core.json.bean.Json;
import org.gjgr.pig.chivalrous.core.json.bean.JsonArray;
import org.gjgr.pig.chivalrous.core.json.bean.JsonNull;
import org.gjgr.pig.chivalrous.core.lang.ClassCommand;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;

public class JsonObject
extends JsonGetter<String>
implements Json,
Map<String, Object> {
    private final Map<String, Object> rawHashMap = new HashMap<String, Object>();

    public JsonObject() {
    }

    public JsonObject(JsonObject jsonObject, String ... names) {
        for (String name : names) {
            try {
                this.putOnce(name, jsonObject.getObj(name));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JsonObject(JsonTokener x) throws JsonException {
        this.init(x);
    }

    public JsonObject(Object source) {
        if (null != source) {
            if (source instanceof Map) {
                for (Map.Entry e : ((Map)source).entrySet()) {
                    Object value = e.getValue();
                    if (value == null) continue;
                    this.rawHashMap.put(Convert.toStr(e.getKey()), JsonCommand.wrap(value));
                }
            } else if (source instanceof String) {
                this.init((String)source);
            } else {
                this.populateMap(source);
            }
        }
    }

    public JsonObject(Object pojo, String[] names) {
        Class<?> c = pojo.getClass();
        for (String name : names) {
            try {
                this.putOpt(name, c.getField(name).get(pojo));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JsonObject(String source) throws JsonException {
        this(new JsonTokener(source));
    }

    public JsonElement gson() {
        return new JsonParser().parse(this.toString());
    }

    public com.google.gson.JsonObject getGsonJsonObject() {
        return null;
    }

    public boolean isNull(String key) {
        return JsonNull.NULL.equals(this.getObj(key));
    }

    public JsonArray toJSONArray(Collection<String> names) throws JsonException {
        if (CollectionCommand.isEmpty(names)) {
            return null;
        }
        JsonArray ja = new JsonArray();
        for (String name : names) {
            Object value = this.get(name);
            if (null == value) continue;
            ja.put(value);
        }
        return ja;
    }

    public <T> T toBean(Class<T> clazz) {
        return (T)this.toBean((T)clazz, false);
    }

    public <T> T toBean(Class<T> clazz, boolean ignoreError) {
        return this.toBean(ClassCommand.newInstance(clazz), ignoreError);
    }

    public <T> T toBean(T bean) {
        return this.toBean(bean, false);
    }

    public <T> T toBean(T bean, boolean ignoreError) {
        return InternalJsonUtil.toBean(this, bean, ignoreError);
    }

    @Override
    public int size() {
        return this.rawHashMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rawHashMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.rawHashMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.rawHashMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.rawHashMap.get(key);
    }

    @Override
    public JsonObject put(String key, Object value) throws JsonException {
        if (key == null) {
            throw new NullPointerException("Null key.");
        }
        if (value != null) {
            InternalJsonUtil.testValidity(value);
            this.rawHashMap.put(key, JsonCommand.wrap(value));
        } else {
            this.remove(key);
        }
        return this;
    }

    @Override
    public Object remove(Object key) {
        return this.rawHashMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.rawHashMap.putAll(m);
    }

    @Override
    public void clear() {
        this.rawHashMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.rawHashMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.rawHashMap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.rawHashMap.entrySet();
    }

    @Override
    public Object getObj(String key, Object defaultValue) {
        Object obj = this.rawHashMap.get(key);
        return null == obj ? defaultValue : obj;
    }

    public JsonObject putOnce(String key, Object value) throws JsonException {
        if (key != null && value != null) {
            if (this.rawHashMap.containsKey(key)) {
                throw new JsonException(StringCommand.format("Duplicate key \"{}\"", key));
            }
            this.put(key, value);
        }
        return this;
    }

    public JsonObject putOpt(String key, Object value) throws JsonException {
        if (key != null && value != null) {
            this.put(key, value);
        }
        return this;
    }

    public JsonObject accumulate(String key, Object value) throws JsonException {
        InternalJsonUtil.testValidity(value);
        Object object = this.getObj(key);
        if (object == null) {
            this.put(key, value instanceof JsonArray ? new JsonArray().put(value) : value);
        } else if (object instanceof JsonArray) {
            ((JsonArray)object).put(value);
        } else {
            this.put(key, (Object)new JsonArray().put(object).put(value));
        }
        return this;
    }

    public JsonObject append(String key, Object value) throws JsonException {
        InternalJsonUtil.testValidity(value);
        Object object = this.getObj(key);
        if (object == null) {
            this.put(key, (Object)new JsonArray().put(value));
        } else if (object instanceof JsonArray) {
            this.put(key, (Object)((JsonArray)object).put(value));
        } else {
            throw new JsonException("JsonObject [" + key + "] is not a JsonArray.");
        }
        return this;
    }

    public JsonObject increment(String key) throws JsonException {
        Object value = this.getObj(key);
        if (value == null) {
            this.put(key, (Object)1);
        } else if (value instanceof BigInteger) {
            this.put(key, (Object)((BigInteger)value).add(BigInteger.ONE));
        } else if (value instanceof BigDecimal) {
            this.put(key, (Object)((BigDecimal)value).add(BigDecimal.ONE));
        } else if (value instanceof Integer) {
            this.put(key, (Object)((Integer)value + 1));
        } else if (value instanceof Long) {
            this.put(key, (Object)((Long)value + 1L));
        } else if (value instanceof Double) {
            this.put(key, (Object)((Double)value + 1.0));
        } else if (value instanceof Float) {
            this.put(key, (Object)Float.valueOf(((Float)value).floatValue() + 1.0f));
        } else {
            throw new JsonException("Unable to increment [" + JsonCommand.quote(key) + "].");
        }
        return this;
    }

    @Override
    public boolean equals(Object other) {
        try {
            if (!(other instanceof JsonObject)) {
                return false;
            }
            Set<String> set = this.keySet();
            if (!set.equals(((JsonObject)other).keySet())) {
                return false;
            }
            for (String name : set) {
                Object valueThis = this.getObj(name);
                Object valueOther = ((JsonObject)other).getObj(name);
                if (!(valueThis instanceof JsonObject ? !((JsonObject)valueThis).equals(valueOther) : (valueThis instanceof JsonArray ? !((JsonArray)valueThis).equals(valueOther) : !valueThis.equals(valueOther)))) continue;
                return false;
            }
            return true;
        }
        catch (Throwable exception) {
            return false;
        }
    }

    public String toString() {
        try {
            return this.toJSONString(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Writer write(Writer writer) throws JsonException {
        return this.write(writer, 0, 0);
    }

    @Override
    public Writer write(Writer writer, int indentFactor, int indent) throws JsonException {
        try {
            boolean commanate = false;
            int length = this.size();
            Iterator<String> keys = this.keySet().iterator();
            writer.write(123);
            if (length == 1) {
                String key = keys.next();
                writer.write(JsonCommand.quote(key.toString()));
                writer.write(58);
                if (indentFactor > 0) {
                    writer.write(32);
                }
                InternalJsonUtil.writeValue(writer, this.rawHashMap.get(key), indentFactor, indent);
            } else if (length != 0) {
                int newindent = indent + indentFactor;
                while (keys.hasNext()) {
                    String key = keys.next();
                    if (commanate) {
                        writer.write(44);
                    }
                    if (indentFactor > 0) {
                        writer.write(10);
                    }
                    InternalJsonUtil.indent(writer, newindent);
                    writer.write(JsonCommand.quote(key.toString()));
                    writer.write(58);
                    if (indentFactor > 0) {
                        writer.write(32);
                    }
                    InternalJsonUtil.writeValue(writer, this.rawHashMap.get(key), indentFactor, newindent);
                    commanate = true;
                }
                if (indentFactor > 0) {
                    writer.write(10);
                }
                InternalJsonUtil.indent(writer, indent);
            }
            writer.write(125);
            return writer;
        }
        catch (IOException exception) {
            throw new JsonException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toJSONString(int indentFactor) throws JsonException {
        StringWriter w = new StringWriter();
        StringBuffer stringBuffer = w.getBuffer();
        synchronized (stringBuffer) {
            return this.write(w, indentFactor, 0).toString();
        }
    }

    private void populateMap(Object bean) {
        Class<?> clazz = bean.getClass();
        boolean includeSuperClass = clazz.getClassLoader() != null;
        Method[] methods = includeSuperClass ? clazz.getMethods() : clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            try {
                Method method = methods[i];
                if (!Modifier.isPublic(method.getModifiers())) continue;
                String name = method.getName();
                String key = "";
                if (name.startsWith("get")) {
                    key = "getClass".equals(name) || "getDeclaringClass".equals(name) ? "" : name.substring(3);
                } else if (name.startsWith("is")) {
                    key = name.substring(2);
                }
                if (key.length() <= 0 || !Character.isUpperCase(key.charAt(0)) || method.getParameterTypes().length != 0) continue;
                if (key.length() == 1) {
                    key = key.toLowerCase();
                } else if (!Character.isUpperCase(key.charAt(1))) {
                    key = key.substring(0, 1).toLowerCase() + key.substring(1);
                }
                Object result = method.invoke(bean, (Object[])null);
                if (result == null) continue;
                this.rawHashMap.put(key, JsonCommand.wrap(result));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void init(String source) {
        this.init(new JsonTokener(source));
    }

    private void init(JsonTokener x) {
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JsonObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JsonObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            this.putOnce(key, x.nextValue());
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }

    private String csv(Writer writer) {
        return null;
    }

    public String toTypeString(String type) {
        if ("csv".equalsIgnoreCase(type)) {
            String r = this.csv(new StringWriter());
            return r;
        }
        return this.toString();
    }
}

