/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.lang;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.gjgr.pig.chivalrous.core.lang.AssertCommand;
import org.gjgr.pig.chivalrous.core.lang.ObjectCommand;

public final class ByteCommand {
    private ByteCommand() {
    }

    public static short readShort(byte[] bytes, int offset) {
        return (short)(bytes[offset] << 8 | bytes[offset + 1] & 0xFF);
    }

    public static int read2ByteInt(byte[] bytes, int offset) {
        int i = 0;
        i |= bytes[offset] & 0xFF;
        i <<= 8;
        return i |= bytes[offset + 1] & 0xFF;
    }

    public static int readInt(byte[] bytes, int offset) {
        return (bytes[offset + 0] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    public static long readUnsignedInt(byte[] bytes, int offset) {
        return ((long)bytes[offset + 0] & 0xFFL) << 24 | ((long)bytes[offset + 1] & 0xFFL) << 16 | ((long)bytes[offset + 2] & 0xFFL) << 8 | (long)bytes[offset + 3] & 0xFFL;
    }

    public static long readLong(byte[] bytes, int offset) {
        return (long)(bytes[offset + 0] & 0xFF) << 56 | (long)(bytes[offset + 1] & 0xFF) << 48 | (long)(bytes[offset + 2] & 0xFF) << 40 | (long)(bytes[offset + 3] & 0xFF) << 32 | (long)(bytes[offset + 4] & 0xFF) << 24 | (long)(bytes[offset + 5] & 0xFF) << 16 | (long)(bytes[offset + 6] & 0xFF) << 8 | (long)bytes[offset + 7] & 0xFFL;
    }

    public static long readBytes(byte[] bytes, int offset, int numBytes) {
        int shift = 0;
        long value = 0L;
        for (int i = offset + numBytes - 1; i >= offset; --i) {
            value |= ((long)bytes[i] & 0xFFL) << shift;
            shift += 8;
        }
        return value;
    }

    public static void writeShort(byte[] bytes, short value, int offset) {
        bytes[offset] = (byte)(0xFF & value >> 8);
        bytes[offset + 1] = (byte)(0xFF & value);
    }

    public static void writeInt(byte[] bytes, int value, int offset) {
        bytes[offset] = (byte)(0xFF & value >> 24);
        bytes[offset + 1] = (byte)(0xFF & value >> 16);
        bytes[offset + 2] = (byte)(0xFF & value >> 8);
        bytes[offset + 3] = (byte)(0xFF & value);
    }

    public static void writeLong(byte[] bytes, long value, int offset) {
        bytes[offset] = (byte)(0xFFL & value >> 56);
        bytes[offset + 1] = (byte)(0xFFL & value >> 48);
        bytes[offset + 2] = (byte)(0xFFL & value >> 40);
        bytes[offset + 3] = (byte)(0xFFL & value >> 32);
        bytes[offset + 4] = (byte)(0xFFL & value >> 24);
        bytes[offset + 5] = (byte)(0xFFL & value >> 16);
        bytes[offset + 6] = (byte)(0xFFL & value >> 8);
        bytes[offset + 7] = (byte)(0xFFL & value);
    }

    public static void writeBytes(byte[] bytes, long value, int offset, int numBytes) {
        int shift = 0;
        for (int i = offset + numBytes - 1; i >= offset; --i) {
            bytes[i] = (byte)(0xFFL & value >> shift);
            shift += 8;
        }
    }

    public static byte[] byteArrayConcat(byte[] ... args) {
        int fulllength = 0;
        for (byte[] arrItem : args) {
            fulllength += arrItem.length;
        }
        byte[] retArray = new byte[fulllength];
        int start = 0;
        for (byte[] arrItem : args) {
            System.arraycopy(arrItem, 0, retArray, start, arrItem.length);
            start += arrItem.length;
        }
        return retArray;
    }

    public static byte[] intToByteArray(int number) {
        int temp = number;
        byte[] b = new byte[4];
        for (int i = b.length - 1; i > -1; --i) {
            b[i] = Integer.valueOf(temp & 0xFF).byteValue();
            temp >>= 8;
        }
        return b;
    }

    public static byte[] concat(byte[] array1, byte[] array2) {
        byte[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    public static byte[] concatAll(byte[] ... arrays) {
        if (arrays.length == 0) {
            return new byte[0];
        }
        if (arrays.length == 1) {
            return arrays[0];
        }
        byte[] cur = ByteCommand.concat(arrays[0], arrays[1]);
        for (int i = 2; i < arrays.length; ++i) {
            cur = ByteCommand.concat(cur, arrays[i]);
        }
        return cur;
    }

    public static byte[][] split(byte[] source, int c) {
        if (ObjectCommand.isEmpty((Object)source)) {
            return new byte[0][];
        }
        ArrayList<byte[]> bytes = new ArrayList<byte[]>();
        int offset = 0;
        for (int i = 0; i <= source.length; ++i) {
            if (i == source.length) {
                bytes.add(Arrays.copyOfRange(source, offset, i));
                break;
            }
            if (source[i] != c) continue;
            bytes.add(Arrays.copyOfRange(source, offset, i));
            offset = i + 1;
        }
        return (byte[][])bytes.toArray((T[])new byte[bytes.size()][]);
    }

    public static byte[][] mergeArrays(byte[] firstArray, byte[] ... additionalArrays) {
        AssertCommand.notNull(firstArray, "first array must not be null");
        AssertCommand.notNull(additionalArrays, "additional arrays must not be null");
        byte[][] result = new byte[additionalArrays.length + 1][];
        result[0] = firstArray;
        System.arraycopy(additionalArrays, 0, result, 1, additionalArrays.length);
        return result;
    }

    public static byte[] getBytes(ByteBuffer byteBuffer) {
        AssertCommand.notNull(byteBuffer, "ByteBuffer must not be null!");
        ByteBuffer duplicate = byteBuffer.duplicate();
        byte[] bytes = new byte[duplicate.remaining()];
        duplicate.get(bytes);
        return bytes;
    }

    public static boolean startsWith(byte[] haystack, byte[] prefix) {
        return ByteCommand.startsWith(haystack, prefix, 0);
    }

    public static boolean startsWith(byte[] haystack, byte[] prefix, int offset) {
        int to = offset;
        int prefixOffset = 0;
        int prefixLength = prefix.length;
        if (offset < 0 || offset > haystack.length - prefixLength) {
            return false;
        }
        while (--prefixLength >= 0) {
            if (haystack[to++] == prefix[prefixOffset++]) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(byte[] haystack, byte needle) {
        for (int i = 0; i < haystack.length; ++i) {
            if (haystack[i] != needle) continue;
            return i;
        }
        return -1;
    }

    public static ByteBuffer getByteBuffer(String theString) {
        return ByteCommand.getByteBuffer(theString, StandardCharsets.UTF_8);
    }

    public static ByteBuffer getByteBuffer(String theString, Charset charset) {
        AssertCommand.notNull(theString, "The String must not be null!");
        AssertCommand.notNull(charset, "The String must not be null!");
        return charset.encode(theString);
    }

    public static byte[] extractBytes(ByteBuffer buffer) {
        ByteBuffer duplicate = buffer.duplicate();
        byte[] bytes = new byte[duplicate.remaining()];
        duplicate.get(bytes);
        return bytes;
    }
}

