/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.gjgr.pig.chivalrous.core.convert.Convert;
import org.gjgr.pig.chivalrous.core.lang.ArrayCommand;
import org.gjgr.pig.chivalrous.core.lang.BoundedPriorityQueue;
import org.gjgr.pig.chivalrous.core.lang.Editor;
import org.gjgr.pig.chivalrous.core.lang.Matcher;
import org.gjgr.pig.chivalrous.core.lang.ObjectCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.util.PageUtil;

public class CollectionCommand {
    public static String convertToString(Collection<?> collection) {
        Validate.noNullElements(collection, (String)"colletion is null, can not convert to a String", (Object[])new Object[0]);
        return StringUtils.join(collection, (String)",");
    }

    public static List<String> convertToList(String listString) {
        Validate.notNull((Object)listString, (String)"String is null can not convert to a collection", (Object[])new Object[0]);
        return Arrays.asList(listString.split(","));
    }

    public static List<String> convertToList(String listString, String split) {
        Validate.notNull((Object)listString, (String)"String is null can not convert to a collection", (Object[])new Object[0]);
        return Arrays.asList(listString.split(split));
    }

    public static <K, V, T> void collectionToMap(Collection<T> collection, Map<K, V> map, MapAdder<K, V, T> adder) {
        if (collection != null && map != null && adder != null) {
            for (T element : collection) {
                adder.put(map, element);
            }
        }
    }

    public static <T> Collection<T> union(Collection<T> coll1, Collection<T> coll2) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (CollectionCommand.isEmpty(coll1)) {
            list.addAll(coll2);
        } else if (CollectionCommand.isEmpty(coll2)) {
            list.addAll(coll1);
        } else {
            Map<T, Integer> map1 = CollectionCommand.countMap(coll1);
            Map<T, Integer> map2 = CollectionCommand.countMap(coll2);
            HashSet elts = CollectionCommand.newHashSet(coll2);
            for (Object t : elts) {
                int mm = Math.max(Convert.toInt(map1.get(t), 0), Convert.toInt(map2.get(t), 0));
                int m = mm;
                for (int i = 0; i < m; ++i) {
                    list.add(t);
                }
            }
        }
        return list;
    }

    @SafeVarargs
    public static <T> Collection<T> union(Collection<T> coll1, Collection<T> coll2, Collection<T> ... otherColls) {
        Collection<T> union = CollectionCommand.union(coll1, coll2);
        for (Collection<T> coll : otherColls) {
            union = CollectionCommand.union(union, coll);
        }
        return union;
    }

    public static <T> Collection<T> intersection(Collection<T> coll1, Collection<T> coll2) {
        ArrayList list = new ArrayList();
        if (CollectionCommand.isNotEmpty(coll1) && CollectionCommand.isNotEmpty(coll2)) {
            Map<T, Integer> map1 = CollectionCommand.countMap(coll1);
            Map<T, Integer> map2 = CollectionCommand.countMap(coll2);
            HashSet elts = CollectionCommand.newHashSet(coll2);
            for (Object t : elts) {
                int m = Math.min(Convert.toInt(map1.get(t), 0), Convert.toInt(map2.get(t), 0));
                for (int i = 0; i < m; ++i) {
                    list.add(t);
                }
            }
        }
        return list;
    }

    @SafeVarargs
    public static <T> Collection<T> intersection(Collection<T> coll1, Collection<T> coll2, Collection<T> ... otherColls) {
        Collection<T> intersection = CollectionCommand.intersection(coll1, coll2);
        if (CollectionCommand.isEmpty(intersection)) {
            return intersection;
        }
        for (Collection<T> coll : otherColls) {
            if (!CollectionCommand.isEmpty(intersection = CollectionCommand.intersection(intersection, coll))) continue;
            return intersection;
        }
        return intersection;
    }

    public static <T> Collection<T> disjunction(Collection<T> coll1, Collection<T> coll2) {
        ArrayList list = new ArrayList();
        if (CollectionCommand.isNotEmpty(coll1) && CollectionCommand.isNotEmpty(coll2)) {
            Map<T, Integer> map1 = CollectionCommand.countMap(coll1);
            Map<T, Integer> map2 = CollectionCommand.countMap(coll2);
            HashSet elts = CollectionCommand.newHashSet(coll2);
            for (Object t : elts) {
                int m = Math.max(Convert.toInt(map1.get(t), 0), Convert.toInt(map2.get(t), 0)) - Math.min(Convert.toInt(map1.get(t), 0), Convert.toInt(map2.get(t), 0));
                for (int i = 0; i < m; ++i) {
                    list.add(t);
                }
            }
        }
        return list;
    }

    public static boolean containsAny(Collection<?> coll1, Collection<?> coll2) {
        if (CollectionCommand.isEmpty(coll1) || CollectionCommand.isEmpty(coll2)) {
            return false;
        }
        if (coll1.size() < coll2.size()) {
            for (Object object : coll1) {
                if (!coll2.contains(object)) continue;
                return true;
            }
        } else {
            for (Object object : coll2) {
                if (!coll1.contains(object)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> Map<T, Integer> countMap(Collection<T> collection) {
        HashMap<T, Integer> countMap = new HashMap<T, Integer>();
        for (T t : collection) {
            Integer count = (Integer)countMap.get(t);
            if (null == count) {
                countMap.put(t, 1);
                continue;
            }
            countMap.put(t, count + 1);
        }
        return countMap;
    }

    public static <T> String join(Iterable<T> iterable, String conjunction) {
        if (null == iterable) {
            return null;
        }
        return CollectionCommand.join(iterable.iterator(), conjunction);
    }

    public static <T> String join(Iterator<T> iterator, String conjunction) {
        if (null == iterator) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        while (iterator.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            T item = iterator.next();
            if (ArrayCommand.isArray(item)) {
                sb.append(ArrayCommand.join(ArrayCommand.wrap(item), conjunction));
                continue;
            }
            if (item instanceof Iterable) {
                sb.append(CollectionCommand.join((Iterable)item, conjunction));
                continue;
            }
            if (item instanceof Iterator) {
                sb.append(CollectionCommand.join((Iterator)item, conjunction));
                continue;
            }
            sb.append(item);
        }
        return sb.toString();
    }

    @SafeVarargs
    public static <T> List<T> sortPageAll(int pageNo, int numPerPage, Comparator<T> comparator, Collection<T> ... colls) {
        ArrayList<T> result = new ArrayList<T>();
        for (Collection<T> coll : colls) {
            result.addAll(coll);
        }
        Collections.sort(result, comparator);
        int resultSize = result.size();
        if (resultSize <= numPerPage) {
            return result;
        }
        int[] startEnd = PageUtil.transToStartEnd(pageNo, numPerPage);
        if (startEnd[1] > resultSize) {
            return new ArrayList();
        }
        return result.subList(startEnd[0], startEnd[1]);
    }

    @SafeVarargs
    public static <T> List<T> sortPageAll2(int pageNo, int numPerPage, Comparator<T> comparator, Collection<T> ... colls) {
        BoundedPriorityQueue<T> queue = new BoundedPriorityQueue<T>(pageNo * numPerPage);
        for (Collection<T> coll : colls) {
            queue.addAll(coll);
        }
        int resultSize = queue.size();
        if (resultSize <= numPerPage) {
            return queue.toList();
        }
        int[] startEnd = PageUtil.transToStartEnd(pageNo, numPerPage);
        if (startEnd[1] > resultSize) {
            return new ArrayList();
        }
        return queue.toList().subList(startEnd[0], startEnd[1]);
    }

    public static List<Map.Entry<Long, Long>> sortEntrySetToList(Set<Map.Entry<Long, Long>> set) {
        LinkedList<Map.Entry<Long, Long>> list = new LinkedList<Map.Entry<Long, Long>>(set);
        Collections.sort(list, new Comparator<Map.Entry<Long, Long>>(){

            @Override
            public int compare(Map.Entry<Long, Long> o1, Map.Entry<Long, Long> o2) {
                if (o1.getValue() > o2.getValue()) {
                    return 1;
                }
                if (o1.getValue() < o2.getValue()) {
                    return -1;
                }
                return 0;
            }
        });
        return list;
    }

    public static <T> List<T> popPart(Stack<T> surplusAlaDatas, int partSize) {
        if (surplusAlaDatas == null || surplusAlaDatas.size() <= 0) {
            return null;
        }
        ArrayList<T> currentAlaDatas = new ArrayList<T>();
        int size = surplusAlaDatas.size();
        if (size > partSize) {
            for (int i = 0; i < partSize; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        } else {
            for (int i = 0; i < size; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        }
        return currentAlaDatas;
    }

    public static <T> List<T> popPart(Deque<T> surplusAlaDatas, int partSize) {
        if (surplusAlaDatas == null || surplusAlaDatas.size() <= 0) {
            return null;
        }
        ArrayList<T> currentAlaDatas = new ArrayList<T>();
        int size = surplusAlaDatas.size();
        if (size > partSize) {
            for (int i = 0; i < partSize; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        } else {
            for (int i = 0; i < size; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        }
        return currentAlaDatas;
    }

    public static <T, K> HashMap<T, K> newHashMap() {
        return new HashMap();
    }

    public static <T, K> HashMap<T, K> newHashMap(int size, boolean isOrder) {
        int initialCapacity = (int)((double)size / 0.75);
        return isOrder ? new LinkedHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public static <T, K> HashMap<T, K> newHashMap(int size) {
        return CollectionCommand.newHashMap(size, false);
    }

    @SafeVarargs
    public static <T> HashSet<T> newHashSet(T ... ts) {
        HashSet<T> set = new HashSet<T>(Math.max((int)((float)ts.length / 0.75f) + 1, 16));
        for (T t : ts) {
            set.add(t);
        }
        return set;
    }

    @SafeVarargs
    public static <T> HashSet<T> newHashSet(boolean isSorted, T ... ts) {
        int initialCapacity = Math.max((int)((float)ts.length / 0.75f) + 1, 16);
        HashSet set = isSorted ? new LinkedHashSet(initialCapacity) : new HashSet(initialCapacity);
        for (T t : ts) {
            set.add(t);
        }
        return set;
    }

    public static <T> HashSet<T> newHashSet(Collection<T> collection) {
        return new HashSet<T>(collection);
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, Collection<T> collection) {
        return isSorted ? new LinkedHashSet() : new HashSet<T>(collection);
    }

    @SafeVarargs
    public static <T> ArrayList<T> newArrayList(T ... values) {
        ArrayList<T> arrayList = new ArrayList<T>(values.length);
        for (T t : values) {
            arrayList.add(t);
        }
        return arrayList;
    }

    public static <T> ArrayList<T> newArrayList(Collection<T> collection) {
        return new ArrayList<T>(collection);
    }

    public static <T> CopyOnWriteArrayList<T> newCopyOnWriteArrayList(Collection<T> collection) {
        return null == collection ? new CopyOnWriteArrayList() : new CopyOnWriteArrayList<T>(collection);
    }

    public static <T> ArrayList<T> distinct(Collection<T> collection) {
        if (CollectionCommand.isEmpty(collection)) {
            return new ArrayList();
        }
        if (collection instanceof Set) {
            return new ArrayList<T>(collection);
        }
        return new ArrayList<T>(new LinkedHashSet<T>(collection));
    }

    public static <T> List<T> sub(List<T> list, int start, int end) {
        int size;
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > (size = list.size())) {
            if (start >= size) {
                return null;
            }
            end = size;
        }
        return list.subList(start, end);
    }

    public static <T> List<T> sub(Collection<T> list, int start, int end) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return CollectionCommand.sub(new ArrayList<T>(list), start, end);
    }

    public static <T> List<List<T>> split(Collection<T> collection, int size) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        ArrayList<T> subList = new ArrayList<T>(size);
        for (T t : collection) {
            if (subList.size() > size) {
                result.add(subList);
                subList = new ArrayList(size);
            }
            subList.add(t);
        }
        result.add(subList);
        return result;
    }

    public static <T> Collection<T> filter(Collection<T> collection, Editor<T> editor) {
        Collection<T> collection2 = ObjectCommand.clone(collection);
        collection2.clear();
        for (T t : collection) {
            T modified = editor.edit(t);
            if (null == modified) continue;
            collection2.add(t);
        }
        return collection2;
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Editor<Map.Entry<K, V>> editor) {
        Map<K, V> map2 = ObjectCommand.clone(map);
        map2.clear();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Map.Entry<K, V> modified = editor.edit(entry);
            if (null == modified) continue;
            map2.put(entry.getKey(), entry.getValue());
        }
        return map2;
    }

    public static <T> int count(Iterable<T> iterable, Matcher<T> matcher) {
        int count = 0;
        for (T t : iterable) {
            if (null != matcher && !matcher.match(t)) continue;
            ++count;
        }
        return count;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return null == iterable || CollectionCommand.isEmpty(iterable.iterator());
    }

    public static boolean isEmpty(Iterator<?> Iterator2) {
        return null == Iterator2 || false == Iterator2.hasNext();
    }

    public static boolean isEmpty(Enumeration<?> enumeration) {
        return null == enumeration || false == enumeration.hasMoreElements();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return false == CollectionCommand.isEmpty(collection);
    }

    public static <T> boolean isNotEmpty(Map<?, ?> map) {
        return false == CollectionCommand.isEmpty(map);
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return null != iterable && CollectionCommand.isNotEmpty(iterable.iterator());
    }

    public static boolean isNotEmpty(Iterator<?> Iterator2) {
        return null != Iterator2 && Iterator2.hasNext();
    }

    public static boolean isNotEmpty(Enumeration<?> enumeration) {
        return null != enumeration && enumeration.hasMoreElements();
    }

    public static Map<String, String> zip(String keys, String values, String delimiter, boolean isOrder) {
        return ArrayCommand.zip(StringCommand.split(keys, delimiter), StringCommand.split(values, delimiter), isOrder);
    }

    public static Map<String, String> zip(String keys, String values, String delimiter) {
        return CollectionCommand.zip(keys, values, delimiter, false);
    }

    public static <T, K> Map<T, K> zip(Collection<T> keys, Collection<K> values) {
        if (CollectionCommand.isEmpty(keys) || CollectionCommand.isEmpty(values)) {
            return null;
        }
        ArrayList<T> keyList = new ArrayList<T>(keys);
        ArrayList<K> valueList = new ArrayList<K>(values);
        int size = Math.min(keys.size(), values.size());
        HashMap map = new HashMap((int)((double)size / 0.75));
        for (int i = 0; i < size; ++i) {
            map.put(keyList.get(i), valueList.get(i));
        }
        return map;
    }

    public static <T, K> HashMap<T, K> toMap(Collection<Map.Entry<T, K>> entryCollection) {
        HashMap<T, K> map = new HashMap<T, K>();
        for (Map.Entry<T, K> entry : entryCollection) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static <T> TreeSet<T> toTreeSet(Collection<T> collection, Comparator<T> comparator) {
        TreeSet<T> treeSet = new TreeSet<T>(comparator);
        for (T t : collection) {
            treeSet.add(t);
        }
        return treeSet;
    }

    public static <T> List<T> sort(Collection<T> collection, Comparator<T> comparator) {
        ArrayList<T> list = new ArrayList<T>(collection);
        Collections.sort(list, comparator);
        return list;
    }

    public static <E> Enumeration<E> asEnumeration(final Iterator<E> iter) {
        return new Enumeration<E>(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            @Override
            public E nextElement() {
                return iter.next();
            }
        };
    }

    public static <E> Iterator<E> asIterator(final Enumeration<E> e) {
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return e.hasMoreElements();
            }

            @Override
            public E next() {
                return e.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Iterator<T> iterator) {
        if (null != collection && null != iterator) {
            while (iterator.hasNext()) {
                collection.add(iterator.next());
            }
        }
        return collection;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Iterable<T> iterable) {
        return CollectionCommand.addAll(collection, iterable.iterator());
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Enumeration<T> enumeration) {
        if (null != collection && null != enumeration) {
            while (enumeration.hasMoreElements()) {
                collection.add(enumeration.nextElement());
            }
        }
        return collection;
    }

    public static <T> List<T> addAllIfNotContains(List<T> list, List<T> otherList) {
        for (T t : otherList) {
            if (list.contains(t)) continue;
            list.add(t);
        }
        return list;
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        if (null != iterable) {
            return CollectionCommand.getFirst(iterable.iterator());
        }
        return null;
    }

    public static <T> T getFirst(Iterator<T> iterator) {
        if (null != iterator && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static <T> void forEach(Iterator<T> iterator, Consumer<T> consumer) {
        int index = 0;
        while (iterator.hasNext()) {
            consumer.accept(iterator.next(), index);
            ++index;
        }
    }

    public static <T> void forEach(Enumeration<T> enumeration, Consumer<T> consumer) {
        int index = 0;
        while (enumeration.hasMoreElements()) {
            consumer.accept(enumeration.nextElement(), index);
            ++index;
        }
    }

    public static <K, V> void forEach(Map<K, V> map, KVConsumer<K, V> kvConsumer) {
        int index = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            kvConsumer.accept(entry.getKey(), entry.getValue(), index);
            ++index;
        }
    }

    public Map<String, String> buildMap(String[][] mapArray) {
        Validate.notNull((Object)mapArray, (String)"mapArray", (Object[])new Object[0]);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String[] array : mapArray) {
            Validate.isTrue((array != null && array.length == 2 ? 1 : 0) != 0, (String)"Each row should contain and only contain 2 elements.", (Object[])new Object[0]);
            map.put(array[0], array[1]);
        }
        return map;
    }

    public static interface KVConsumer<K, V> {
        public void accept(K var1, V var2, int var3);
    }

    public static interface Consumer<T> {
        public void accept(T var1, int var2);
    }

    public static interface MapAdder<K, V, T> {
        public void put(Map<K, V> var1, T var2);
    }

    static interface StringConstants {
        public static final String MILIAO_STANDARD_SEPERATOR = ",";
    }
}

