/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.lang;

import org.gjgr.pig.chivalrous.core.lang.StringCommand;

public final class Console {
    private Console() {
    }

    public static void log() {
        System.out.println();
    }

    public static void log(Object obj) {
        if (obj instanceof Throwable) {
            Throwable e = (Throwable)obj;
            Console.log(e, e.getMessage(), new Object[0]);
        } else {
            Console.log("{}", obj);
        }
    }

    public static void log(String template, Object ... values) {
        Console.log(null, template, values);
    }

    public static void log(Throwable t, String template, Object ... values) {
        System.out.println(StringCommand.format(template, values));
        if (null != t) {
            t.printStackTrace();
            System.out.flush();
        }
    }

    public static void error() {
        System.err.println();
    }

    public static void error(Object obj) {
        if (obj instanceof Throwable) {
            Throwable e = (Throwable)obj;
            Console.error(e, e.getMessage(), new Object[0]);
        } else {
            Console.error("{}", obj);
        }
    }

    public static void error(String template, Object ... values) {
        Console.error(null, template, values);
    }

    public static void error(Throwable t, String template, Object ... values) {
        System.err.println(StringCommand.format(template, values));
        if (null != t) {
            t.printStackTrace(System.err);
            System.err.flush();
        }
    }
}

