/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.lang;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Objects;
import org.apache.commons.lang3.Validate;

public class EnumCommand {
    public <E extends Enum<E>> EnumSet<E> parse(Class<E> clazz, String input, String separator) {
        Validate.notNull((Object)input, (String)"input", (Object[])new Object[0]);
        Validate.notNull((Object)separator, (String)"separator", (Object[])new Object[0]);
        String[] values = input.split(separator);
        ArrayList<E> list = new ArrayList<E>();
        for (String value : values) {
            list.add(Enum.valueOf(clazz, value.trim()));
        }
        return EnumSet.copyOf(list);
    }

    public int intEnum(String string) {
        return Objects.hashCode(string);
    }

    public static enum StringEnum {
        Never("Never");

        private final String value;

        private StringEnum(String value) {
            this.value = value;
        }

        public static String getEnumKey(String key) {
            for (LongEnum e : LongEnum.values()) {
                if (!key.equals(e.value)) continue;
                return e.name();
            }
            return null;
        }

        public String getValue() {
            return this.value;
        }

        public String getNegativeValue() {
            return new StringBuilder(this.getValue()).reverse().toString();
        }

        public String getKey() {
            return this.name();
        }

        public String toString() {
            return this.getValue() + "";
        }
    }

    public static enum DoubleEnum {
        Never(-1.0);

        private final Double value;

        private DoubleEnum(Double value) {
            this.value = value;
        }

        public static String getEnumKey(Double key) {
            for (LongEnum e : LongEnum.values()) {
                if (!key.equals(e.value)) continue;
                return e.name();
            }
            return null;
        }

        public Double getValue() {
            return this.value;
        }

        public Double getNegativeValue() {
            return -this.value.doubleValue();
        }

        public String getKey() {
            return this.name();
        }

        public String toString() {
            return this.getValue() + "";
        }
    }

    public static enum LongEnum {
        Never(1L);

        private final Long value;

        private LongEnum(Long value) {
            this.value = value;
        }

        private LongEnum(String value) {
            try {
                this.value = 0L;
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("could not build enum. length should not more than 9");
            }
        }

        public static String getEnumKey(Long key) {
            for (LongEnum e : LongEnum.values()) {
                if (!key.equals(e.value)) continue;
                return e.name();
            }
            return null;
        }

        public Long getValue() {
            return this.value;
        }

        public Long getNegativeValue() {
            return -this.value.longValue();
        }

        public String getKey() {
            return this.name();
        }

        public String toString() {
            return this.getValue() + "";
        }
    }
}

