/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.lang;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gjgr.pig.chivalrous.core.exceptions.ThrowingFunction;
import org.gjgr.pig.chivalrous.core.exceptions.UtilException;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.io.file.FileCommand;
import org.gjgr.pig.chivalrous.core.io.stream.FastByteArrayOutputStream;
import org.gjgr.pig.chivalrous.core.io.stream.StreamCommand;
import org.gjgr.pig.chivalrous.core.lang.ArrayCommand;
import org.gjgr.pig.chivalrous.core.lang.AssertCommand;
import org.gjgr.pig.chivalrous.core.lang.ClassCommand;
import org.gjgr.pig.chivalrous.core.lang.Nullable;
import org.gjgr.pig.chivalrous.core.lang.Ordered;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.util.TypeConverter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ObjectCommand {
    private static final int INITIAL_HASH = 7;
    private static final int MULTIPLIER = 31;
    private static final String EMPTY_STRING = "";
    private static final String NULL_STRING = "null";
    private static final String ARRAY_START = "{";
    private static final String ARRAY_END = "}";
    private static final String EMPTY_ARRAY = "{}";
    private static final String ARRAY_ELEMENT_SEPARATOR = ", ";
    private static final String DEFAULT_DELIMITER = ",";

    private ObjectCommand() {
    }

    public static boolean typeCoerceEquals(TypeConverter converter, Object leftValue, Object rightValue) {
        return ObjectCommand.typeCoerceEquals(converter, leftValue, rightValue, false);
    }

    public static boolean typeCoerceEquals(TypeConverter converter, Object leftValue, Object rightValue, boolean ignoreCase) {
        if (leftValue == null && rightValue == null) {
            return true;
        }
        if (leftValue == null || rightValue == null) {
            return false;
        }
        boolean answer = ObjectCommand.equal(leftValue, rightValue, ignoreCase);
        if (answer) {
            return true;
        }
        if (leftValue.getClass().isInstance(rightValue)) {
            return false;
        }
        Object value = converter.tryConvertTo(rightValue.getClass(), leftValue);
        answer = ObjectCommand.equal(value, rightValue, ignoreCase);
        if (answer) {
            return true;
        }
        value = converter.tryConvertTo(leftValue.getClass(), rightValue);
        answer = ObjectCommand.equal(leftValue, value, ignoreCase);
        return answer;
    }

    public static boolean typeCoerceNotEquals(TypeConverter converter, Object leftValue, Object rightValue) {
        return !ObjectCommand.typeCoerceEquals(converter, leftValue, rightValue);
    }

    public static int typeCoerceCompare(TypeConverter converter, Object leftValue, Object rightValue) {
        Object value;
        Long leftNum = converter.tryConvertTo(Long.class, leftValue);
        Long rightNum = converter.tryConvertTo(Long.class, rightValue);
        if (leftNum != null && rightNum != null) {
            return leftNum.compareTo(rightNum);
        }
        Double leftDouble = converter.tryConvertTo(Double.class, leftValue);
        Double rightDouble = converter.tryConvertTo(Double.class, rightValue);
        if (leftDouble != null && rightDouble != null) {
            return leftDouble.compareTo(rightDouble);
        }
        if (rightValue instanceof String && !(leftValue instanceof String)) {
            return ObjectCommand.typeCoerceCompare(converter, rightValue, leftValue) * -1;
        }
        if (rightValue instanceof Comparable && (value = converter.tryConvertTo(rightValue.getClass(), leftValue)) != null) {
            return ((Comparable)rightValue).compareTo(value) * -1;
        }
        if (leftValue instanceof Comparable && (value = converter.tryConvertTo(leftValue.getClass(), rightValue)) != null) {
            return ((Comparable)leftValue).compareTo(value);
        }
        return ObjectCommand.compare(leftValue, rightValue);
    }

    public static boolean equal(Object a, Object b) {
        return ObjectCommand.equal(a, b, false);
    }

    public static boolean equalIgnoreCase(Object a, Object b) {
        return ObjectCommand.equal(a, b, true);
    }

    public static boolean equal(Object a, Object b, boolean ignoreCase) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (ignoreCase && a instanceof String && b instanceof String) {
            return ((String)a).equalsIgnoreCase((String)b);
        }
        if (a.getClass().isArray() && b.getClass().isArray()) {
            return Objects.deepEquals(a, b);
        }
        return a.equals(b);
    }

    public static boolean equalByteArray(byte[] a, byte[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean isEqualToAny(Object object, Object ... values) {
        for (Object value : values) {
            if (!ObjectCommand.equal(object, value)) continue;
            return true;
        }
        return false;
    }

    public static int compare(Object a, Object b) {
        return ObjectCommand.compare(a, b, false);
    }

    public static int compare(Object a, Object b, boolean ignoreCase) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Ordered && b instanceof Ordered) {
            return ((Ordered)a).getOrder() - ((Ordered)b).getOrder();
        }
        if (ignoreCase && a instanceof String && b instanceof String) {
            return ((String)a).compareToIgnoreCase((String)b);
        }
        if (a instanceof Comparable) {
            Comparable comparable = (Comparable)a;
            return comparable.compareTo(b);
        }
        int answer = a.getClass().getName().compareTo(b.getClass().getName());
        if (answer == 0) {
            answer = a.hashCode() - b.hashCode();
        }
        return answer;
    }

    public static Boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        if (value instanceof Integer) {
            return (Integer)value > 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public static <T> T notNull(T value, String name) {
        if (value == null) {
            throw new IllegalArgumentException(name + " must be specified");
        }
        return value;
    }

    public static <T> T notNull(T value, String name, Object on) {
        if (on == null) {
            ObjectCommand.notNull(value, name);
        } else if (value == null) {
            throw new IllegalArgumentException(name + " must be specified on: " + on);
        }
        return value;
    }

    @Deprecated
    public static String notEmpty(String value, String name) {
        return StringCommand.notEmpty(value, name);
    }

    @Deprecated
    public static String notEmpty(String value, String name, Object on) {
        return StringCommand.notEmpty(value, name, on);
    }

    public static boolean isNotEmpty(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            String text = (String)value;
            return text.trim().length() > 0;
        }
        if (value instanceof Collection) {
            return !((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return !((Map)value).isEmpty();
        }
        return true;
    }

    public static Optional<Object> firstNotNull(Object ... values) {
        for (Object value : values) {
            if (value == null) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static <T> T supplyIfEmpty(T value, Supplier<T> supplier) {
        ObjectCommand.notNull(supplier, "Supplier");
        if (ObjectCommand.isNotEmpty(value)) {
            return value;
        }
        return supplier.get();
    }

    public static <T> void ifNotEmpty(T value, Consumer<T> consumer) {
        if (ObjectCommand.isNotEmpty(value)) {
            consumer.accept(value);
        }
    }

    public static <I, R, T extends Throwable> Optional<R> applyIfNotEmpty(I value, ThrowingFunction<I, R, T> function) throws T {
        if (ObjectCommand.isNotEmpty(value)) {
            return Optional.ofNullable(function.apply(value));
        }
        return Optional.empty();
    }

    public static <I, R, T extends Throwable> R applyIfNotEmpty(I value, ThrowingFunction<I, R, T> consumer, Supplier<R> orElse) throws T {
        if (ObjectCommand.isNotEmpty(value)) {
            return consumer.apply(value);
        }
        return orElse.get();
    }

    @Deprecated
    public static String[] splitOnCharacter(String value, String needle, int count) {
        return StringCommand.splitOnCharacter(value, needle, count);
    }

    @Deprecated
    public static String removeStartingCharacters(String text, char ch) {
        return StringCommand.removeStartingCharacters(text, ch);
    }

    @Deprecated
    public static String capitalize(String text) {
        return StringCommand.capitalize(text);
    }

    @Deprecated
    public static String after(String text, String after) {
        return StringCommand.after(text, after);
    }

    @Deprecated
    public static <T> Optional<T> after(String text, String after, Function<String, T> mapper) {
        return StringCommand.after(text, after, mapper);
    }

    @Deprecated
    public static String before(String text, String before) {
        return StringCommand.before(text, before);
    }

    @Deprecated
    public static <T> Optional<T> before(String text, String before, Function<String, T> mapper) {
        return StringCommand.before(text, before, mapper);
    }

    @Deprecated
    public static String between(String text, String after, String before) {
        return StringCommand.between(text, after, before);
    }

    @Deprecated
    public static <T> Optional<T> between(String text, String after, String before, Function<String, T> mapper) {
        return StringCommand.between(text, after, before, mapper);
    }

    @Deprecated
    public static String betweenOuterPair(String text, char before, char after) {
        return StringCommand.betweenOuterPair(text, before, after);
    }

    @Deprecated
    public static <T> Optional<T> betweenOuterPair(String text, char before, char after, Function<String, T> mapper) {
        return StringCommand.betweenOuterPair(text, before, after, mapper);
    }

    public static boolean matches(List<?> list) {
        if (!list.isEmpty()) {
            Object value = list.get(0);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return true;
        }
        return false;
    }

    public static String getSystemProperty(String name, String defaultValue) {
        try {
            return System.getProperty(name, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean getSystemProperty(String name, Boolean defaultValue) {
        String result = ObjectCommand.getSystemProperty(name, defaultValue.toString());
        return Boolean.parseBoolean(result);
    }

    public static String name(Class<?> type) {
        return type != null ? type.getName() : null;
    }

    public static String className(Object value) {
        return ObjectCommand.name(value != null ? value.getClass() : null);
    }

    public static String classCanonicalName(Object value) {
        if (value != null) {
            return value.getClass().getCanonicalName();
        }
        return null;
    }

    public static Class<?> loadClass(String name) {
        return ObjectCommand.loadClass(name, ObjectCommand.class.getClassLoader());
    }

    public static Class<?> loadClass(String name, ClassLoader loader) {
        return ObjectCommand.loadClass(name, loader, false);
    }

    public static Class<?> loadClass(String name, ClassLoader loader, boolean needToWarn) {
        if (ObjectCommand.isEmpty(name = ObjectCommand.normalizeClassName(name))) {
            return null;
        }
        Class<?> clazz = ObjectCommand.loadSimpleType(name);
        if (clazz == null) {
            clazz = ObjectCommand.doLoadClass(name, Thread.currentThread().getContextClassLoader());
        }
        if (clazz == null) {
            clazz = ObjectCommand.doLoadClass(name, loader);
        }
        if (clazz == null) {
            clazz = ObjectCommand.doLoadClass(name, ObjectCommand.class.getClassLoader());
        }
        return clazz;
    }

    public static Class<?> loadSimpleType(String name) {
        if ("java.lang.byte[]".equals(name) || "byte[]".equals(name)) {
            return byte[].class;
        }
        if ("java.lang.Byte[]".equals(name) || "Byte[]".equals(name)) {
            return Byte[].class;
        }
        if ("java.lang.Object[]".equals(name) || "Object[]".equals(name)) {
            return Object[].class;
        }
        if ("java.lang.String[]".equals(name) || "String[]".equals(name)) {
            return String[].class;
        }
        if ("java.lang.String".equals(name) || "String".equals(name)) {
            return String.class;
        }
        if ("java.lang.Boolean".equals(name) || "Boolean".equals(name)) {
            return Boolean.class;
        }
        if ("boolean".equals(name)) {
            return Boolean.TYPE;
        }
        if ("java.lang.Integer".equals(name) || "Integer".equals(name)) {
            return Integer.class;
        }
        if ("int".equals(name)) {
            return Integer.TYPE;
        }
        if ("java.lang.Long".equals(name) || "Long".equals(name)) {
            return Long.class;
        }
        if ("long".equals(name)) {
            return Long.TYPE;
        }
        if ("java.lang.Short".equals(name) || "Short".equals(name)) {
            return Short.class;
        }
        if ("short".equals(name)) {
            return Short.TYPE;
        }
        if ("java.lang.Byte".equals(name) || "Byte".equals(name)) {
            return Byte.class;
        }
        if ("byte".equals(name)) {
            return Byte.TYPE;
        }
        if ("java.lang.Float".equals(name) || "Float".equals(name)) {
            return Float.class;
        }
        if ("float".equals(name)) {
            return Float.TYPE;
        }
        if ("java.lang.Double".equals(name) || "Double".equals(name)) {
            return Double.class;
        }
        if ("double".equals(name)) {
            return Double.TYPE;
        }
        if ("java.lang.Character".equals(name) || "Character".equals(name)) {
            return Character.class;
        }
        if ("char".equals(name)) {
            return Character.TYPE;
        }
        return null;
    }

    private static Class<?> doLoadClass(String name, ClassLoader loader) {
        StringCommand.notEmpty(name, "name");
        if (loader == null) {
            return null;
        }
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static InputStream loadResourceAsStream(String name) {
        return ObjectCommand.loadResourceAsStream(name, null);
    }

    public static InputStream loadResourceAsStream(String name, ClassLoader loader) {
        ClassLoader contextClassLoader;
        InputStream in = null;
        String resolvedName = ObjectCommand.resolveUriPath(name);
        if (loader != null) {
            in = loader.getResourceAsStream(resolvedName);
        }
        if (in == null && (contextClassLoader = Thread.currentThread().getContextClassLoader()) != null) {
            in = contextClassLoader.getResourceAsStream(resolvedName);
        }
        if (in == null) {
            in = ObjectCommand.class.getClassLoader().getResourceAsStream(resolvedName);
        }
        if (in == null) {
            in = ObjectCommand.class.getResourceAsStream(resolvedName);
        }
        return in;
    }

    public static URL loadResourceAsURL(String name) {
        return ObjectCommand.loadResourceAsURL(name, null);
    }

    public static URL loadResourceAsURL(String name, ClassLoader loader) {
        ClassLoader contextClassLoader;
        URL url = null;
        String resolvedName = ObjectCommand.resolveUriPath(name);
        if (loader != null) {
            url = loader.getResource(resolvedName);
        }
        if (url == null && (contextClassLoader = Thread.currentThread().getContextClassLoader()) != null) {
            url = contextClassLoader.getResource(resolvedName);
        }
        if (url == null) {
            url = ObjectCommand.class.getClassLoader().getResource(resolvedName);
        }
        if (url == null) {
            url = ObjectCommand.class.getResource(resolvedName);
        }
        return url;
    }

    public static Enumeration<URL> loadResourcesAsURL(String packageName) {
        return ObjectCommand.loadResourcesAsURL(packageName, null);
    }

    public static Enumeration<URL> loadResourcesAsURL(String packageName, ClassLoader loader) {
        ClassLoader contextClassLoader;
        Enumeration<URL> url = null;
        if (loader != null) {
            try {
                url = loader.getResources(packageName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (url == null && (contextClassLoader = Thread.currentThread().getContextClassLoader()) != null) {
            try {
                url = contextClassLoader.getResources(packageName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (url == null) {
            try {
                url = ObjectCommand.class.getClassLoader().getResources(packageName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return url;
    }

    private static String resolveUriPath(String name) {
        return FileCommand.compactPath(name, '/');
    }

    public static Object invokeMethod(Method method, Object instance, Object ... parameters) {
        try {
            return method.invoke(instance, parameters);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isOverridingMethod(Method source, Method target) {
        return ObjectCommand.isOverridingMethod(source, target, true);
    }

    public static boolean isOverridingMethod(Method source, Method target, boolean exact) {
        return ObjectCommand.isOverridingMethod(target.getDeclaringClass(), source, target, exact);
    }

    public static boolean isOverridingMethod(Class<?> inheritingClass, Method source, Method target, boolean exact) {
        if (source.equals(target)) {
            return true;
        }
        if (target.getDeclaringClass().isAssignableFrom(source.getDeclaringClass())) {
            return false;
        }
        if (!source.getDeclaringClass().isAssignableFrom(inheritingClass) || !target.getDeclaringClass().isAssignableFrom(inheritingClass)) {
            return false;
        }
        if (!source.getName().equals(target.getName())) {
            return false;
        }
        if (exact) {
            if (!source.getReturnType().equals(target.getReturnType())) {
                return false;
            }
        } else if (!source.getReturnType().isAssignableFrom(target.getReturnType())) {
            boolean b1 = source.isBridge();
            boolean b2 = target.isBridge();
            if (!b1 && !b2) {
                return false;
            }
        }
        if (source.getParameterCount() != target.getParameterCount()) {
            return false;
        }
        Class<?>[] sourceTypes = source.getParameterTypes();
        Class<?>[] targetTypes = target.getParameterTypes();
        for (int i = 0; i < source.getParameterCount(); ++i) {
            if (exact) {
                if (sourceTypes[i].equals(targetTypes[i])) continue;
                return false;
            }
            if (sourceTypes[i].isAssignableFrom(targetTypes[i])) continue;
            boolean b1 = source.isBridge();
            boolean b2 = target.isBridge();
            if (b1 || b2) continue;
            return false;
        }
        return true;
    }

    public static List<Method> findMethodsWithAnnotation(Class<?> type, Class<? extends Annotation> annotationType) {
        return ObjectCommand.findMethodsWithAnnotation(type, annotationType, false);
    }

    public static List<Method> findMethodsWithAnnotation(Class<?> type, Class<? extends Annotation> annotationType, boolean checkMetaAnnotations) {
        ArrayList<Method> answer = new ArrayList<Method>();
        do {
            Method[] methods;
            for (Method method : methods = type.getDeclaredMethods()) {
                if (!ObjectCommand.hasAnnotation(method, annotationType, checkMetaAnnotations)) continue;
                answer.add(method);
            }
        } while ((type = type.getSuperclass()) != null);
        return answer;
    }

    public static boolean hasAnnotation(AnnotatedElement elem, Class<? extends Annotation> annotationType, boolean checkMetaAnnotations) {
        if (elem.isAnnotationPresent(annotationType)) {
            return true;
        }
        if (checkMetaAnnotations) {
            for (Annotation a : elem.getAnnotations()) {
                for (Annotation meta : a.annotationType().getAnnotations()) {
                    if (!meta.annotationType().getName().equals(annotationType.getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String asString(Object[] objects) {
        if (objects == null) {
            return NULL_STRING;
        }
        StringBuilder buffer = new StringBuilder(ARRAY_START);
        int counter = 0;
        for (Object object : objects) {
            if (counter++ > 0) {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            String text = object == null ? NULL_STRING : object.toString();
            buffer.append(text);
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static boolean isAssignableFrom(Class<?> a, Class<?> b) {
        a = ObjectCommand.convertPrimitiveTypeToWrapperType(a);
        b = ObjectCommand.convertPrimitiveTypeToWrapperType(b);
        return a.isAssignableFrom(b);
    }

    public static boolean isPrimitiveArrayType(Class<?> clazz) {
        if (clazz != null && clazz.isArray()) {
            return clazz.getComponentType().isPrimitive();
        }
        return false;
    }

    public static int arrayLength(Object[] pojo) {
        return pojo.length;
    }

    public static Class<?> convertPrimitiveTypeToWrapperType(Class<?> type) {
        Class<Object> rc = type;
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                rc = Integer.class;
            } else if (type == Long.TYPE) {
                rc = Long.class;
            } else if (type == Double.TYPE) {
                rc = Double.class;
            } else if (type == Float.TYPE) {
                rc = Float.class;
            } else if (type == Short.TYPE) {
                rc = Short.class;
            } else if (type == Byte.TYPE) {
                rc = Byte.class;
            } else if (type == Boolean.TYPE) {
                rc = Boolean.class;
            } else if (type == Character.TYPE) {
                rc = Character.class;
            }
        }
        return rc;
    }

    public static String getDefaultCharacterSet() {
        return Charset.defaultCharset().name();
    }

    public static String getPropertyName(Method method) {
        String propertyName = method.getName();
        if (propertyName.startsWith("set") && method.getParameterCount() == 1) {
            propertyName = propertyName.substring(3, 4).toLowerCase(Locale.ENGLISH) + propertyName.substring(4);
        }
        return propertyName;
    }

    public static boolean hasAnnotation(Annotation[] annotations, Class<?> type) {
        for (Annotation annotation : annotations) {
            if (!type.isInstance(annotation)) continue;
            return true;
        }
        return false;
    }

    public static <A extends Annotation> A getAnnotation(Object instance, Class<A> type) {
        return instance.getClass().getAnnotation(type);
    }

    @Deprecated
    public static void close(Closeable closeable, String name) {
        StreamCommand.close(closeable, name);
    }

    public static <T> T cast(Class<T> toType, Object value) {
        Class<?> newType;
        if (toType == Boolean.TYPE) {
            return (T)ObjectCommand.cast(Boolean.class, value);
        }
        if (toType.isPrimitive() && (newType = ObjectCommand.convertPrimitiveTypeToWrapperType(toType)) != toType) {
            return (T)ObjectCommand.cast(newType, value);
        }
        try {
            return toType.cast(value);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Failed to convert: " + value + " to type: " + toType.getName() + " due to: " + e, e);
        }
    }

    public static <T> T newInstance(Class<T> type) {
        try {
            return type.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Class<?> actualType, Class<T> expectedType) {
        try {
            Object value = actualType.newInstance();
            return ObjectCommand.cast(expectedType, value);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasDefaultPublicNoArgConstructor(Class<?> type) {
        for (Constructor<?> ctr : type.getConstructors()) {
            if (ctr.getParameterCount() != 0) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isJavaIdentifier(String name) {
        return StringCommand.isJavaIdentifier(name);
    }

    public static Object type(Object bean) {
        return bean != null ? bean.getClass() : null;
    }

    public static boolean evaluateValuePredicate(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            if ("true".equalsIgnoreCase((String)value)) {
                return true;
            }
            if ("false".equalsIgnoreCase((String)value)) {
                return false;
            }
        } else {
            if (value instanceof NodeList) {
                if (value instanceof Node && ((Node)value).hasAttributes()) {
                    return true;
                }
                NodeList list = (NodeList)value;
                return list.getLength() > 0;
            }
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                return col.size() > 0;
            }
        }
        return value != null;
    }

    @Deprecated
    public static String normalizeClassName(String name) {
        return StringCommand.normalizeClassName(name);
    }

    public static Iterable<Throwable> createExceptionIterable(Throwable exception) {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        for (Throwable current = exception; current != null; current = current.getCause()) {
            throwables.add(current);
        }
        Collections.reverse(throwables);
        return throwables;
    }

    public static Iterator<Throwable> createExceptionIterator(Throwable exception) {
        return ObjectCommand.createExceptionIterable(exception).iterator();
    }

    public static <T> T getException(Class<T> type, Throwable exception) {
        if (exception == null) {
            return null;
        }
        for (Throwable throwable : exception.getSuppressed()) {
            if (!type.isInstance(throwable)) continue;
            return type.cast(throwable);
        }
        for (Throwable throwable : ObjectCommand.createExceptionIterable(exception)) {
            if (!type.isInstance(throwable)) continue;
            return type.cast(throwable);
        }
        return null;
    }

    public static String getIdentityHashCode(Object object) {
        return "0x" + Integer.toHexString(System.identityHashCode(object));
    }

    public static String lookupConstantFieldValue(Class<?> clazz, String name) {
        if (clazz == null) {
            return null;
        }
        if (name.startsWith(DEFAULT_DELIMITER)) {
            name = name.substring(1);
        }
        for (Field field : clazz.getFields()) {
            if (!field.getName().equals(name)) continue;
            try {
                Object v = field.get(null);
                return v.toString();
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return null;
    }

    public static boolean isNaN(Object value) {
        if (value == null || !(value instanceof Number)) {
            return false;
        }
        return value.equals(Float.valueOf(Float.NaN)) || value.equals(Double.NaN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callWithTCCL(Callable<?> call, ClassLoader classloader) throws Exception {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            if (classloader != null) {
                Thread.currentThread().setContextClassLoader(classloader);
            }
            Object obj = call.call();
            return obj;
        }
        finally {
            if (tccl != null) {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
    }

    public static boolean isCheckedException(Throwable ex) {
        return !(ex instanceof RuntimeException) && !(ex instanceof Error);
    }

    public static boolean isCompatibleWithThrowsClause(Throwable ex, Class<?> ... declaredExceptions) {
        if (!ObjectCommand.isCheckedException(ex)) {
            return true;
        }
        if (declaredExceptions != null) {
            for (Class<?> declaredException : declaredExceptions) {
                if (!declaredException.isInstance(ex)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isArray(@Nullable Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    public static boolean isEmpty(@Nullable Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(@Nullable Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Optional) {
            return !((Optional)obj).isPresent();
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        return false;
    }

    @Nullable
    public static Object unwrapOptional(@Nullable Object obj) {
        if (obj instanceof Optional) {
            Optional optional = (Optional)obj;
            if (!optional.isPresent()) {
                return null;
            }
            Object result = optional.get();
            AssertCommand.isTrue(!(result instanceof Optional), "Multi-level Optional usage not supported");
            return result;
        }
        return obj;
    }

    public static boolean containsElement(@Nullable Object[] array, Object element) {
        if (array == null) {
            return false;
        }
        for (Object arrayEle : array) {
            if (!ObjectCommand.nullSafeEquals(arrayEle, element)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsConstant(Enum<?>[] enumValues, String constant) {
        return ObjectCommand.containsConstant(enumValues, constant, false);
    }

    public static boolean containsConstant(Enum<?>[] enumValues, String constant, boolean caseSensitive) {
        for (Enum<?> candidate : enumValues) {
            if (!(caseSensitive ? candidate.toString().equals(constant) : candidate.toString().equalsIgnoreCase(constant))) continue;
            return true;
        }
        return false;
    }

    public static <E extends Enum<?>> E caseInsensitiveValueOf(E[] enumValues, String constant) {
        for (E candidate : enumValues) {
            if (!((Enum)candidate).toString().equalsIgnoreCase(constant)) continue;
            return candidate;
        }
        throw new IllegalArgumentException("Constant [" + constant + "] does not exist in enum type " + enumValues.getClass().getComponentType().getName());
    }

    public static <A, O extends A> A[] addObjectToArray(@Nullable A[] array, @Nullable O obj) {
        Class compType = Object.class;
        if (array != null) {
            compType = array.getClass().getComponentType();
        } else if (obj != null) {
            compType = obj.getClass();
        }
        int newArrLength = array != null ? array.length + 1 : 1;
        Object[] newArr = (Object[])Array.newInstance(compType, newArrLength);
        if (array != null) {
            System.arraycopy(array, 0, newArr, 0, array.length);
        }
        newArr[newArr.length - 1] = obj;
        return newArr;
    }

    public static Object[] toObjectArray(@Nullable Object source) {
        if (source instanceof Object[]) {
            return (Object[])source;
        }
        if (source == null) {
            return new Object[0];
        }
        if (!source.getClass().isArray()) {
            throw new IllegalArgumentException("Source is not an array: " + source);
        }
        int length = Array.getLength(source);
        if (length == 0) {
            return new Object[0];
        }
        Class<?> wrapperType = Array.get(source, 0).getClass();
        Object[] newArray = (Object[])Array.newInstance(wrapperType, length);
        for (int i = 0; i < length; ++i) {
            newArray[i] = Array.get(source, i);
        }
        return newArray;
    }

    public static boolean nullSafeEquals(@Nullable Object o1, @Nullable Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            return ObjectCommand.arrayEquals(o1, o2);
        }
        return false;
    }

    private static boolean arrayEquals(Object o1, Object o2) {
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            return Arrays.equals((Object[])o1, (Object[])o2);
        }
        if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
            return Arrays.equals((boolean[])o1, (boolean[])o2);
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof char[] && o2 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        if (o1 instanceof double[] && o2 instanceof double[]) {
            return Arrays.equals((double[])o1, (double[])o2);
        }
        if (o1 instanceof float[] && o2 instanceof float[]) {
            return Arrays.equals((float[])o1, (float[])o2);
        }
        if (o1 instanceof int[] && o2 instanceof int[]) {
            return Arrays.equals((int[])o1, (int[])o2);
        }
        if (o1 instanceof long[] && o2 instanceof long[]) {
            return Arrays.equals((long[])o1, (long[])o2);
        }
        if (o1 instanceof short[] && o2 instanceof short[]) {
            return Arrays.equals((short[])o1, (short[])o2);
        }
        return false;
    }

    public static int nullSafeHashCode(@Nullable Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj.getClass().isArray()) {
            if (obj instanceof Object[]) {
                return ObjectCommand.nullSafeHashCode((Object[])obj);
            }
            if (obj instanceof boolean[]) {
                return ObjectCommand.nullSafeHashCode((boolean[])obj);
            }
            if (obj instanceof byte[]) {
                return ObjectCommand.nullSafeHashCode((byte[])obj);
            }
            if (obj instanceof char[]) {
                return ObjectCommand.nullSafeHashCode((char[])obj);
            }
            if (obj instanceof double[]) {
                return ObjectCommand.nullSafeHashCode((double[])obj);
            }
            if (obj instanceof float[]) {
                return ObjectCommand.nullSafeHashCode((float[])obj);
            }
            if (obj instanceof int[]) {
                return ObjectCommand.nullSafeHashCode((int[])obj);
            }
            if (obj instanceof long[]) {
                return ObjectCommand.nullSafeHashCode((long[])obj);
            }
            if (obj instanceof short[]) {
                return ObjectCommand.nullSafeHashCode((short[])obj);
            }
        }
        return obj.hashCode();
    }

    public static int nullSafeHashCode(@Nullable Object[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (Object element : array) {
            hash = 31 * hash + ObjectCommand.nullSafeHashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(@Nullable boolean[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (boolean element : array) {
            hash = 31 * hash + Boolean.hashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(@Nullable byte[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (byte element : array) {
            hash = 31 * hash + element;
        }
        return hash;
    }

    public static int nullSafeHashCode(@Nullable char[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (char element : array) {
            hash = 31 * hash + element;
        }
        return hash;
    }

    public static int nullSafeHashCode(@Nullable double[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (double element : array) {
            hash = 31 * hash + Double.hashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(@Nullable float[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (float element : array) {
            hash = 31 * hash + Float.hashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(@Nullable int[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (int element : array) {
            hash = 31 * hash + element;
        }
        return hash;
    }

    public static int nullSafeHashCode(@Nullable long[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (long element : array) {
            hash = 31 * hash + Long.hashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(@Nullable short[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (short element : array) {
            hash = 31 * hash + element;
        }
        return hash;
    }

    @Deprecated
    public static int hashCode(boolean bool) {
        return Boolean.hashCode(bool);
    }

    @Deprecated
    public static int hashCode(double dbl) {
        return Double.hashCode(dbl);
    }

    @Deprecated
    public static int hashCode(float flt) {
        return Float.hashCode(flt);
    }

    @Deprecated
    public static int hashCode(long lng) {
        return Long.hashCode(lng);
    }

    public static String identityToString(@Nullable Object obj) {
        if (obj == null) {
            return EMPTY_STRING;
        }
        return obj.getClass().getName() + "@" + ObjectCommand.getIdentityHexString(obj);
    }

    public static String getIdentityHexString(Object obj) {
        return Integer.toHexString(System.identityHashCode(obj));
    }

    public static String getDisplayString(@Nullable Object obj) {
        if (obj == null) {
            return EMPTY_STRING;
        }
        return ObjectCommand.nullSafeToString(obj);
    }

    public static String nullSafeClassName(@Nullable Object obj) {
        return obj != null ? obj.getClass().getName() : NULL_STRING;
    }

    public static String nullSafeToString(@Nullable Object obj) {
        if (obj == null) {
            return NULL_STRING;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Object[]) {
            return ObjectCommand.nullSafeToString((Object[])obj);
        }
        if (obj instanceof boolean[]) {
            return ObjectCommand.nullSafeToString((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return ObjectCommand.nullSafeToString((byte[])obj);
        }
        if (obj instanceof char[]) {
            return ObjectCommand.nullSafeToString((char[])obj);
        }
        if (obj instanceof double[]) {
            return ObjectCommand.nullSafeToString((double[])obj);
        }
        if (obj instanceof float[]) {
            return ObjectCommand.nullSafeToString((float[])obj);
        }
        if (obj instanceof int[]) {
            return ObjectCommand.nullSafeToString((int[])obj);
        }
        if (obj instanceof long[]) {
            return ObjectCommand.nullSafeToString((long[])obj);
        }
        if (obj instanceof short[]) {
            return ObjectCommand.nullSafeToString((short[])obj);
        }
        String str = obj.toString();
        return str != null ? str : EMPTY_STRING;
    }

    public static String nullSafeToString(@Nullable Object[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(String.valueOf(array[i]));
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(@Nullable boolean[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(array[i]);
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(@Nullable byte[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(array[i]);
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(@Nullable char[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append("'").append(array[i]).append("'");
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(@Nullable double[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(array[i]);
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(@Nullable float[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(array[i]);
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(@Nullable int[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(array[i]);
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(@Nullable long[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(array[i]);
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(@Nullable short[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(array[i]);
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static int length(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            int count = 0;
            while (iter.hasNext()) {
                ++count;
                iter.next();
            }
            return count;
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            int count = 0;
            while (enumeration.hasMoreElements()) {
                ++count;
                enumeration.nextElement();
            }
            return count;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj);
        }
        return -1;
    }

    public static boolean contains(Object obj, Object element) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            if (element == null) {
                return false;
            }
            return ((String)obj).contains(element.toString());
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).contains(element);
        }
        if (obj instanceof Map) {
            return ((Map)obj).values().contains(element);
        }
        if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!ObjectCommand.equal(o, element)) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            while (enumeration.hasMoreElements()) {
                Object o = enumeration.nextElement();
                if (!ObjectCommand.equal(o, element)) continue;
                return true;
            }
            return false;
        }
        if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                Object o = Array.get(obj, i);
                if (!ObjectCommand.equal(o, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNull(Object obj) {
        return null == obj;
    }

    public static boolean isNotNull(Object obj) {
        return null != obj;
    }

    public static <T> T clone(T obj) {
        T result = ArrayCommand.clone(obj);
        if (null == result) {
            result = obj instanceof Cloneable ? ClassCommand.invoke(obj, "clone", new Object[0]) : ObjectCommand.cloneByStream(obj);
        }
        return result;
    }

    public static <T> T cloneIfPossible(T obj) {
        Object clone = null;
        try {
            clone = ObjectCommand.clone(obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)(clone == null ? obj : clone);
    }

    public static <T> T cloneByStream(T obj) {
        Object object;
        if (null == obj || !(obj instanceof Serializable)) {
            return null;
        }
        FastByteArrayOutputStream byteOut = new FastByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(byteOut);
            out.writeObject(obj);
            out.flush();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteOut.toByteArray()));
            object = in.readObject();
        }
        catch (Exception e) {
            try {
                throw new UtilException(e);
            }
            catch (Throwable throwable) {
                IoCommand.close(out);
                throw throwable;
            }
        }
        IoCommand.close(out);
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object cloneAttribute(Object from, Object to) {
        Field[] fieldClone = null;
        Field[] fieldBeCloned = null;
        HashMap<String, Field> map = new HashMap<String, Field>();
        try {
            Class<?> classClone = from.getClass();
            Class<?> classBecloned = to.getClass();
            fieldClone = classClone.getDeclaredFields();
            fieldBeCloned = classBecloned.getDeclaredFields();
            for (int t = 0; t < fieldBeCloned.length; ++t) {
                map.put(fieldBeCloned[t].getName(), fieldBeCloned[t]);
            }
            for (int i = 0; i < fieldClone.length; ++i) {
                String fieldCloneName = fieldClone[i].getName();
                Field fie = (Field)map.get(fieldCloneName);
                if (fie == null) continue;
                Method method1 = classClone.getMethod(ObjectCommand.getMethodName(fieldCloneName), new Class[0]);
                Method method2 = classBecloned.getMethod(ObjectCommand.setMethodName(fieldCloneName), fie.getType());
                method2.invoke(to, method1.invoke(from, new Object[0]));
            }
        }
        catch (Exception exception) {
        }
        finally {
            fieldClone = null;
            fieldBeCloned = null;
            map.clear();
        }
        return to;
    }

    private static String getMethodName(String fieldName) {
        String head = fieldName.substring(0, 1).toUpperCase();
        String tail = fieldName.substring(1);
        return "get" + head + tail;
    }

    private static String setMethodName(String fieldName) {
        String head = fieldName.substring(0, 1).toUpperCase();
        String tail = fieldName.substring(1);
        return "set" + head + tail;
    }

    public static Map<String, Object> transBean2Map(Object obj, Boolean includeNull) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.equals("class")) continue;
                Method getter = property.getReadMethod();
                Object value = getter.invoke(obj, new Object[0]);
                if (!includeNull.booleanValue() && value == null) continue;
                map.put(key, value);
            }
        }
        catch (Exception e) {
            System.out.println("transBean2Map Error " + e);
        }
        return map;
    }

    public static <T> T transMap2Bean(Map<String, Object> map, Class<T> clazz) {
        return ObjectCommand.transMap2Bean(map, clazz, null);
    }

    public static <T> T transMap2Bean(Map<String, Object> map, Builder<T> builder) {
        return ObjectCommand.transMap2Bean(map, builder, null);
    }

    public static <T> T transMap2Bean(Map<String, Object> map, Class<T> clazz, String keyPrefix) {
        T obj = null;
        BeanInfo beanInfo = null;
        try {
            PropertyDescriptor[] propertyDescriptors;
            obj = clazz.newInstance();
            beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key;
                Object value;
                if ("class".equals(property.getName()) || (value = map.get(key = keyPrefix == null ? property.getName() : keyPrefix + property.getName())) == null) continue;
                Method setter = property.getWriteMethod();
                setter.invoke(obj, value);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static <T> T transMap2Bean(Map<String, Object> map, Builder<T> builder, String keyPrefix) {
        BeanInfo beanInfo = null;
        try {
            MethodDescriptor[] methodDescriptor;
            beanInfo = Introspector.getBeanInfo(builder.getClass());
            for (MethodDescriptor descriptor : methodDescriptor = beanInfo.getMethodDescriptors()) {
                Method bmethod;
                String key;
                Object value;
                if ("build".equals(descriptor.getName()) || (value = map.get(key = keyPrefix == null ? descriptor.getName() : keyPrefix + descriptor.getName())) == null || (bmethod = descriptor.getMethod()).getParameterCount() != 1 || !bmethod.getParameterTypes()[0].isAssignableFrom(value.getClass())) continue;
                bmethod.invoke(builder, value);
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return builder.build();
    }

    public static <S, T> T generateCopy(S source, Class<T> targetClazz) {
        T bean = null;
        try {
            bean = targetClazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (bean == null || source == null) {
            return null;
        }
        HashMap<String, PropertyDescriptor> filed2Descriptor = new HashMap<String, PropertyDescriptor>();
        try {
            BeanInfo sourceBeanInfo = Introspector.getBeanInfo(source.getClass());
            for (PropertyDescriptor descriptor : sourceBeanInfo.getPropertyDescriptors()) {
                filed2Descriptor.put(descriptor.getName(), descriptor);
            }
            BeanInfo targetBeanInfo = Introspector.getBeanInfo(targetClazz);
            for (PropertyDescriptor descriptor : targetBeanInfo.getPropertyDescriptors()) {
                PropertyDescriptor sourceDescriptor;
                if ("class".equals(descriptor.getName()) || (sourceDescriptor = (PropertyDescriptor)filed2Descriptor.get(descriptor.getName())) == null) continue;
                Object value = sourceDescriptor.getReadMethod().invoke(source, new Object[0]);
                descriptor.getWriteMethod().invoke(bean, value);
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return bean;
    }

    public static Map<String, Object> transBean2Map(Object obj) {
        return ObjectCommand.transBean2Map(obj, false);
    }

    public static <T> byte[] serialize(T obj) {
        if (null == obj || !(obj instanceof Serializable)) {
            return null;
        }
        FastByteArrayOutputStream byteOut = new FastByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(byteOut);
            oos.writeObject(obj);
            oos.flush();
        }
        catch (Exception e) {
            try {
                throw new UtilException(e);
            }
            catch (Throwable throwable) {
                IoCommand.close(oos);
                throw throwable;
            }
        }
        IoCommand.close(oos);
        return byteOut.toByteArray();
    }

    public static <T> T unserialize(byte[] bytes) {
        ObjectInputStream ois = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ois = new ObjectInputStream(bais);
            return (T)ois.readObject();
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static boolean isBasicType(Object object) {
        return ClassCommand.isBasicType(object.getClass());
    }

    public static boolean isValidIfNumber(Object obj) {
        return obj == null || !(obj instanceof Number) || !(obj instanceof Double ? ((Double)obj).isInfinite() || ((Double)obj).isNaN() : obj instanceof Float && (((Float)obj).isInfinite() || ((Float)obj).isNaN()));
    }

    public static interface Builder<T> {
        public T build();
    }
}

