/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.lang;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.gjgr.pig.chivalrous.core.lang.ClassCommand;
import org.gjgr.pig.chivalrous.core.lang.ObjectWrapper;
import org.gjgr.pig.chivalrous.log.SystemLogger;

public class ReturnCatchCommand {
    public static <T> T returnCatchWithEmpty(Integer traceIndex, ObjectWrapper<T> objectWrapper, T t, Object ... object) {
        long l = System.nanoTime();
        StackTraceElement s = Thread.currentThread().getStackTrace()[traceIndex];
        SystemLogger.info((String)"in function {} about {}, params info {} ", (Object[])new Object[]{s, l, Arrays.toString(object)});
        t = objectWrapper.wrapperWithEmpty(t);
        SystemLogger.info((String)"in function {} about {}, result info {}", (Object[])new Object[]{s, l, t});
        return t;
    }

    public static <T> T returnCatchWithEmpty(ObjectWrapper<T> objectWrapper, T t, Object ... objects) {
        return ReturnCatchCommand.returnCatchWithEmpty(2, objectWrapper, t, objects);
    }

    public static <T> T returnCatchWithNull(ObjectWrapper<T> objectWrapper, T t, Object ... objects) {
        return ReturnCatchCommand.returnCatchWithNull(2, objectWrapper, t, objects);
    }

    public static <T> T returnCatchWithNull(Integer traceIndex, ObjectWrapper<T> objectWrapper, T t, Object ... object) {
        long l = System.nanoTime();
        StackTraceElement s = Thread.currentThread().getStackTrace()[traceIndex];
        SystemLogger.info((String)"in function {} about {}, params info {} ", (Object[])new Object[]{s, l, Arrays.toString(object)});
        t = objectWrapper.wrapperWithNull(t);
        SystemLogger.info((String)"in function {} about {}, result info {}", (Object[])new Object[]{s, l, t});
        return t;
    }

    public static <T> T returnCatchNotNull(ObjectWrapper<T> objectWrapper, T t, Object ... objects) {
        return ReturnCatchCommand.returnCatchNotNull(2, objectWrapper, t, objects);
    }

    public static <T> T returnCatchNotNull(Integer traceIndex, ObjectWrapper<T> objectWrapper, T t, Object ... object) {
        long l = System.nanoTime();
        StackTraceElement s = Thread.currentThread().getStackTrace()[traceIndex];
        SystemLogger.info((String)"in function {} about {}, params info {} ", (Object[])new Object[]{s, l, Arrays.toString(object)});
        t = objectWrapper.wrapperNotNull(t);
        SystemLogger.info((String)"in function {} about {}, result info {}", (Object[])new Object[]{s, l, t});
        return t;
    }

    public static <T> T autoSwithReturnWithDefualt(Object object, ObjectWrapper<T> objectWrapper, Object ... objects) {
        return ReturnCatchCommand.autoSwithReturnWithDefualt(2, object, objectWrapper, objects);
    }

    public static <T> T autoSwithReturnWithDefualt(Integer traceIndex, Object object, ObjectWrapper<T> objectWrapper, Object ... objects) {
        StackTraceElement s = Thread.currentThread().getStackTrace()[2];
        try {
            Method method = object.getClass().getMethod(s.getMethodName(), ClassCommand.getClasses(objects));
            try {
                Object t = method.invoke(object, objects);
                if (t != null) {
                    if (Map.class.isAssignableFrom(t.getClass())) {
                        return (T)ReturnCatchCommand.returnCatchWithEmpty(traceIndex, objectWrapper, t, objects);
                    }
                    if (Collection.class.isAssignableFrom(t.getClass())) {
                        return (T)ReturnCatchCommand.returnCatchWithEmpty(traceIndex, objectWrapper, t, objects);
                    }
                    if (Number.class.isAssignableFrom(t.getClass())) {
                        return (T)ReturnCatchCommand.returnCatchNotNull(traceIndex, objectWrapper, t, objects);
                    }
                    return (T)ReturnCatchCommand.returnCatchWithNull(traceIndex, objectWrapper, t, objects);
                }
                return null;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new RuntimeException("not support the target class switch {}" + Arrays.toString(e.getStackTrace()) + " " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                throw new RuntimeException("not support the target class switch {}" + Arrays.toString(e.getStackTrace()) + " " + e.getMessage());
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new RuntimeException("not support the target class switch {}" + Arrays.toString(e.getStackTrace()) + " " + e.getMessage());
        }
    }
}

