/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.lang;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gjgr.pig.chivalrous.core.convert.Convert;
import org.gjgr.pig.chivalrous.core.date.DateTimeCommand;
import org.gjgr.pig.chivalrous.core.exceptions.ValidateException;
import org.gjgr.pig.chivalrous.core.lang.ObjectCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.util.RegexCommand;

public final class Validator {
    public static final Pattern GENERAL = Pattern.compile("^\\w+$");
    public static final Pattern NUMBERS = Pattern.compile("\\d+");
    public static final Pattern GROUP_VAR = Pattern.compile("\\$(\\d+)");
    public static final Pattern IPV4 = Pattern.compile("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b");
    public static final Pattern MONEY = Pattern.compile("^(\\d+(?:\\.\\d+)?)$");
    public static final Pattern EMAIL = Pattern.compile("(\\w|.)+@\\w+(\\.\\w+){1,2}");
    public static final Pattern MOBILE = Pattern.compile("1\\d{10}");
    public static final Pattern CITIZEN_ID = Pattern.compile("[1-9]\\d{5}[1-2]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}(\\d|X|x)");
    public static final Pattern ZIP_CODE = Pattern.compile("\\d{6}");
    public static final Pattern BIRTHDAY = Pattern.compile("^(\\d{2,4})([/\\-\\.\u5e74]?)(\\d{1,2})([/\\-\\.\u6708]?)(\\d{1,2})\u65e5?$");
    public static final Pattern URL = Pattern.compile("(https://|http://)?([\\w-]+\\.)+[\\w-]+(/[\\w- ./?%&=]*)?");
    public static final Pattern GENERAL_WITH_CHINESE = Pattern.compile("^[\\u0391-\\uFFE5\\w]+$");
    public static final Pattern UUID = Pattern.compile("^[0-9a-z]{8}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{12}$");
    public static final Pattern UUID_SIMPLE = Pattern.compile("^[0-9a-z]{32}$");

    private Validator() {
    }

    public static <T> boolean isEmpty(T value) {
        return null == value || value instanceof String && StringCommand.isEmpty((String)value);
    }

    public static <T> boolean isNotEmpty(T value) {
        return false == Validator.isEmpty(value);
    }

    public static <T> void validateNotEmpty(T value, String errorMsg) throws ValidateException {
        if (Validator.isEmpty(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean equal(Object t1, Object t2) {
        return ObjectCommand.equal(t1, t2);
    }

    public static <T> void validateEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        if (!Validator.equal(t1, t2)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static <T> void validateNotEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        if (Validator.equal(t1, t2)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static <T> void validateNotEmptyAndEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        Validator.validateNotEmpty(t1, errorMsg);
        Validator.validateEqual(t1, t2, errorMsg);
    }

    public static <T> void validateNotEmptyAndNotEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        Validator.validateNotEmpty(t1, errorMsg);
        Validator.validateNotEqual(t1, t2, errorMsg);
    }

    public static boolean isMactchRegex(String regex, String value) {
        return RegexCommand.isMatch(regex, value);
    }

    public static void validateMatchRegex(String regex, String value, String errorMsg) throws ValidateException {
        if (!Validator.isMactchRegex(regex, value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isMactchRegex(Pattern pattern, String value) {
        return RegexCommand.isMatch(pattern, value);
    }

    public static boolean isGeneral(String value) {
        return Validator.isMactchRegex(GENERAL, value);
    }

    public static void validateGeneral(String value, String errorMsg) throws ValidateException {
        if (!Validator.isGeneral(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isGeneral(String value, int min, int max) {
        String reg = "^\\w{" + min + "," + max + "}$";
        if (min < 0) {
            min = 0;
        }
        if (max <= 0) {
            reg = "^\\w{" + min + ",}$";
        }
        return Validator.isMactchRegex(reg, value);
    }

    public static void validateGeneral(String value, int min, int max, String errorMsg) throws ValidateException {
        if (!Validator.isGeneral(value, min, max)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isGeneral(String value, int min) {
        return Validator.isGeneral(value, min, 0);
    }

    public static void validateGeneral(String value, int min, String errorMsg) throws ValidateException {
        Validator.validateGeneral(value, min, 0, errorMsg);
    }

    public static boolean isNumber(String value) {
        if (StringCommand.isBlank(value)) {
            return false;
        }
        return Validator.isMactchRegex(NUMBERS, value);
    }

    public static void validateNumbers(String value, String errorMsg) throws ValidateException {
        if (!Validator.isNumber(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isMoney(String value) {
        return Validator.isMactchRegex(MONEY, value);
    }

    public static void validateMoney(String value, String errorMsg) throws ValidateException {
        if (!Validator.isMoney(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isZipCode(String value) {
        return Validator.isMactchRegex(ZIP_CODE, value);
    }

    public static void validateZipCode(String value, String errorMsg) throws ValidateException {
        if (!Validator.isZipCode(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isEmail(String value) {
        return Validator.isMactchRegex(EMAIL, value);
    }

    public static void validateEmail(String value, String errorMsg) throws ValidateException {
        if (!Validator.isEmail(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isMobile(String value) {
        return Validator.isMactchRegex(MOBILE, value);
    }

    public static void validateMobile(String value, String errorMsg) throws ValidateException {
        if (!Validator.isMobile(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isCitizenId(String value) {
        return Validator.isMactchRegex(CITIZEN_ID, value);
    }

    public static void validateCitizenIdNumber(String value, String errorMsg) throws ValidateException {
        if (!Validator.isCitizenId(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isBirthday(int year, int month, int day) {
        int thisYear = DateTimeCommand.thisYear();
        if (year < 1930 || year > thisYear) {
            return false;
        }
        if (month < 1 || month > 12) {
            return false;
        }
        if (day < 1 || day > 31) {
            return false;
        }
        if ((month == 4 || month == 6 || month == 9 || month == 11) && day == 31) {
            return false;
        }
        return month != 2 || day <= 29 && (day != 29 || false != DateTimeCommand.isLeapYear(year));
    }

    public static boolean isBirthday(String value) {
        Matcher matcher;
        if (Validator.isMactchRegex(BIRTHDAY, value) && (matcher = BIRTHDAY.matcher(value)).find()) {
            int year = Convert.toInt(matcher.group(1));
            int month = Convert.toInt(matcher.group(3));
            int day = Convert.toInt(matcher.group(5));
            return Validator.isBirthday(year, month, day);
        }
        return false;
    }

    public static void validateBirthday(String value, String errorMsg) throws ValidateException {
        if (!Validator.isBirthday(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isIpv4(String value) {
        return Validator.isMactchRegex(IPV4, value);
    }

    public static void validateIpv4(String value, String errorMsg) throws ValidateException {
        if (!Validator.isIpv4(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isUrl(String value) {
        try {
            new URL(value);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public static void validateUrl(String value, String errorMsg) throws ValidateException {
        if (!Validator.isUrl(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isChinese(String value) {
        return Validator.isMactchRegex("^[\u4e00-\u9fff]+$", value);
    }

    public static void validateChinese(String value, String errorMsg) throws ValidateException {
        if (!Validator.isChinese(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isGeneralWithChinese(String value) {
        return Validator.isMactchRegex(GENERAL_WITH_CHINESE, value);
    }

    public static void validateGeneralWithChinese(String value, String errorMsg) throws ValidateException {
        if (!Validator.isGeneralWithChinese(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isUUID(String value) {
        return Validator.isMactchRegex(UUID, value) || Validator.isMactchRegex(UUID_SIMPLE, value);
    }

    public static void validateUUID(String value, String errorMsg) throws ValidateException {
        if (!Validator.isUUID(value)) {
            throw new ValidateException(errorMsg);
        }
    }
}

