/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.log.dialect.jdk;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.log.AbstractLocationAwareLog;

public class JdkLog
extends AbstractLocationAwareLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private static final String FQCN_SELF = JdkLog.class.getName();
    private final transient Logger logger;

    public JdkLog(Logger logger) {
        this.logger = logger;
    }

    public JdkLog(Class<?> clazz) {
        this(clazz.getName());
    }

    public JdkLog(String name) {
        this(Logger.getLogger(name));
    }

    private static void fillCallerData(String callerFQCN, LogRecord record) {
        StackTraceElement[] steArray = new Throwable().getStackTrace();
        int found = -1;
        for (int i = 0; i < steArray.length; ++i) {
            String className = steArray[i].getClassName();
            if (!className.equals(callerFQCN)) continue;
            found = i;
            break;
        }
        if (found > -1 && found < steArray.length - 1) {
            StackTraceElement ste = steArray[found + 1];
            record.setSourceClassName(ste.getClassName());
            record.setSourceMethodName(ste.getMethodName());
        }
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public void log(org.gjgr.pig.chivalrous.core.log.level.Level level, String format, Object ... arguments) {
    }

    @Override
    public void log(org.gjgr.pig.chivalrous.core.log.level.Level level, Throwable t, String format, Object ... arguments) {
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.logIfEnabled(Level.FINEST, null, format, arguments);
    }

    @Override
    public void trace(Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(Level.FINEST, t, format, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.logIfEnabled(Level.FINE, null, format, arguments);
    }

    @Override
    public void debug(Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(Level.FINE, t, format, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.logIfEnabled(Level.INFO, null, format, arguments);
    }

    @Override
    public void info(Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(Level.INFO, t, format, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.logIfEnabled(Level.WARNING, null, format, arguments);
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(Level.WARNING, t, format, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.logIfEnabled(Level.SEVERE, null, format, arguments);
    }

    @Override
    public void error(Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(Level.SEVERE, t, format, arguments);
    }

    public void log(Level level, String format, Object ... arguments) {
        this.log(level, null, format, arguments);
    }

    public void log(Level level, Throwable t, String format, Object ... arguments) {
        this.log(FQCN_SELF, level, t, format, arguments);
    }

    public void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
    }

    private void logIfEnabled(Level level, Throwable throwable, String format, Object[] arguments) {
        this.logIfEnabled(FQCN_SELF, level, throwable, format, arguments);
    }

    private void logIfEnabled(String callerFQCN, Level level, Throwable throwable, String format, Object[] arguments) {
        if (this.logger.isLoggable(level)) {
            LogRecord record = new LogRecord(level, StringCommand.format(format, arguments));
            record.setLoggerName(this.getName());
            record.setThrown(throwable);
            JdkLog.fillCallerData(callerFQCN, record);
            this.logger.log(record);
        }
    }

    @Override
    public void log(String fqcn, org.gjgr.pig.chivalrous.core.log.level.Level level, Throwable t, String format, Object ... arguments) {
    }
}

