/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.log.dialect.jdk;

import java.io.InputStream;
import java.util.logging.LogManager;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.log.Log;
import org.gjgr.pig.chivalrous.core.log.LogFactory;
import org.gjgr.pig.chivalrous.core.log.dialect.jdk.JdkLog;

public class JdkLogFactory
extends LogFactory {
    public JdkLogFactory() {
        super("JDK Logging");
        this.readConfig();
    }

    @Override
    public Log getLog(String name) {
        return new JdkLog(name);
    }

    @Override
    public Log getLog(Class<?> clazz) {
        return new JdkLog(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfig() {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("logging.properties");
        if (null == in) {
            System.err.println("[WARN] Can not find [logging.properties], use [%JRE_HOME%/lib/logging.properties] as default!");
            return;
        }
        try {
            LogManager.getLogManager().readConfiguration(in);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                LogManager.getLogManager().readConfiguration();
            }
            catch (Exception e1) {
                e.printStackTrace();
            }
        }
        finally {
            IoCommand.close(in);
        }
    }
}

