/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.log.dialect.log4j2;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.log.AbstractLocationAwareLog;

public class Log4j2Log
extends AbstractLocationAwareLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private static final String FQCN = Log4j2Log.class.getName();
    private final transient Logger logger;

    public Log4j2Log(Logger logger) {
        this.logger = logger;
    }

    public Log4j2Log(Class<?> clazz) {
        this(LogManager.getLogger(clazz));
    }

    public Log4j2Log(String name) {
        this(LogManager.getLogger((String)name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public void log(org.gjgr.pig.chivalrous.core.log.level.Level level, String format, Object ... arguments) {
    }

    @Override
    public void log(org.gjgr.pig.chivalrous.core.log.level.Level level, Throwable t, String format, Object ... arguments) {
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.trace(null, format, arguments);
    }

    @Override
    public void trace(Throwable t, String format, Object ... arguments) {
        if (!this.logIfEnabled(Level.TRACE, t, format, arguments)) {
            this.logger.trace(StringCommand.format(format, arguments), t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.debug(null, format, arguments);
    }

    @Override
    public void debug(Throwable t, String format, Object ... arguments) {
        if (!this.logIfEnabled(Level.DEBUG, t, format, arguments)) {
            this.logger.debug(StringCommand.format(format, arguments), t);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.info(null, format, arguments);
    }

    @Override
    public void info(Throwable t, String format, Object ... arguments) {
        if (!this.logIfEnabled(Level.INFO, t, format, arguments)) {
            this.logger.info(StringCommand.format(format, arguments), t);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.warn(null, format, arguments);
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
        if (!this.logIfEnabled(Level.WARN, t, format, arguments)) {
            this.logger.warn(StringCommand.format(format, arguments), t);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.error(null, format, arguments);
    }

    @Override
    public void error(Throwable t, String format, Object ... arguments) {
        if (!this.logIfEnabled(Level.ERROR, t, format, arguments)) {
            this.logger.warn(StringCommand.format(format, arguments), t);
        }
    }

    public void log(Level level, String format, Object ... arguments) {
        this.log(level, null, format, arguments);
    }

    public void log(Level level, Throwable t, String format, Object ... arguments) {
        this.log(FQCN, level, t, format, arguments);
    }

    public void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
    }

    private boolean logIfEnabled(Level level, Throwable t, String msgTemplate, Object ... arguments) {
        return this.logIfEnabled(FQCN, level, t, msgTemplate, arguments);
    }

    private boolean logIfEnabled(String fqcn, Level level, Throwable t, String msgTemplate, Object ... arguments) {
        if (this.logger instanceof AbstractLogger) {
            ((AbstractLogger)this.logger).logIfEnabled(fqcn, level, null, StringCommand.format(msgTemplate, arguments), t);
            return true;
        }
        return false;
    }

    @Override
    public void log(String fqcn, org.gjgr.pig.chivalrous.core.log.level.Level level, Throwable t, String format, Object ... arguments) {
    }
}

