/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.mutable;

import org.gjgr.pig.chivalrous.core.math.NumberCommand;
import org.gjgr.pig.chivalrous.core.mutable.Mutable;

public class MutableByte
extends Number
implements Comparable<MutableByte>,
Mutable<Number> {
    private static final long serialVersionUID = -7982037656814990915L;
    private byte value;

    public MutableByte() {
    }

    public MutableByte(byte value) {
        this.value = value;
    }

    public MutableByte(Number value) {
        this(value.byteValue());
    }

    public MutableByte(String value) throws NumberFormatException {
        this.value = Byte.parseByte(value);
    }

    @Override
    public Byte get() {
        return this.value;
    }

    @Override
    public void set(Number value) {
        this.value = value.byteValue();
    }

    @Override
    public void set(byte value) {
        this.value = value;
    }

    public MutableByte increment() {
        this.value = (byte)(this.value + 1);
        return this;
    }

    public MutableByte decrement() {
        this.value = (byte)(this.value - 1);
        return this;
    }

    public MutableByte add(byte operand) {
        this.value = (byte)(this.value + operand);
        return this;
    }

    public MutableByte add(Number operand) {
        this.value = (byte)(this.value + operand.byteValue());
        return this;
    }

    public MutableByte subtract(byte operand) {
        this.value = (byte)(this.value - operand);
        return this;
    }

    public MutableByte subtract(Number operand) {
        this.value = (byte)(this.value - operand.byteValue());
        return this;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableByte) {
            return this.value == ((MutableByte)obj).byteValue();
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int compareTo(MutableByte other) {
        return NumberCommand.compare(this.value, other.value);
    }
}

