/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.net;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.gjgr.pig.chivalrous.core.exceptions.UtilException;
import org.gjgr.pig.chivalrous.core.lang.AssertCommand;
import org.gjgr.pig.chivalrous.core.lang.ClassCommand;
import org.gjgr.pig.chivalrous.core.lang.Nullable;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.net.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriCommand {
    private static Logger logger = LoggerFactory.getLogger(UriCommand.class);

    public static UriBuilder uriBuilder() {
        return new UriBuilder();
    }

    public static UriBuilder uriBuilder(String url) {
        URI uri = UriCommand.uri(url);
        UriBuilder uriBuilder = UriCommand.uriBuilder();
        uriBuilder.setUserInfo(uri.getUserInfo());
        uriBuilder.setHost(uri.getHost());
        uriBuilder.setPath(uri.getPath());
        uriBuilder.setScheme(uri.getScheme());
        uriBuilder.setPort(uri.getPort());
        uriBuilder.setFragment(uri.getFragment());
        uriBuilder.setCustomQuery(uri.getRawQuery());
        return uriBuilder;
    }

    public static URI uriWithoutQuery(URI uri) {
        String url = uri.toString();
        return UriCommand.uriWithoutQuery(url);
    }

    public static URI uriWithoutQuery(String url) {
        if (url.contains("?")) {
            url = url.substring(0, url.indexOf("?"));
        }
        return UriCommand.uri(url);
    }

    public static URI uri(UriBuilder uriBuilder) {
        try {
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String fixIllegalCharacterInUrl(String url) {
        url = url.replace(" ", "%20").replaceAll("#+", "#").replaceAll("\\r|\\n", "");
        int query = 0;
        query = url.contains("?") ? url.indexOf("?") : url.length();
        String uri = url.substring(0, query);
        if (query != url.length()) {
            String last = url.substring(query + 1);
            String code = last.replaceAll("\\|", "%7C").replaceAll("\\/", "%2F").replaceAll(",", "%2C").replaceAll(Pattern.quote("\""), "%22").replaceAll("\\{", "%7B").replaceAll("\\}", "%7D").replaceAll(":", "%3A");
            uri = uri + "?" + code;
        }
        return uri;
    }

    public static URI uri(String url) {
        url = UriCommand.fixIllegalCharacterInUrl(url);
        try {
            return new URI(url);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String paramString(String url) {
        url = UriCommand.fixIllegalCharacterInUrl(url);
        try {
            URI uri = new URI(url);
            String string = uri.getRawQuery();
            return string;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static Map<String, String> param(String param) {
        String[] strings = param.split("&");
        HashMap<String, String> stringMap = new HashMap<String, String>();
        if (strings.length > 0) {
            for (String s : strings) {
                String[] ss = s.split("=");
                if (ss.length != 2) continue;
                stringMap.put(ss[0], ss[1]);
            }
        }
        return stringMap;
    }

    public static Map<String, String> paramMap(String url) {
        try {
            URI uri = new URI(url);
            String string = uri.getRawQuery();
            return UriCommand.param(string);
        }
        catch (URISyntaxException e) {
            logger.error(e.getLocalizedMessage());
            return null;
        }
    }

    public static URL url(String url) {
        url = UriCommand.fixIllegalCharacterInUrl(url);
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new UtilException(e.getMessage(), e);
        }
    }

    public static String getPath(String uriStr) {
        URI uri = null;
        try {
            uri = new URI(uriStr);
        }
        catch (URISyntaxException e) {
            throw new UtilException(e);
        }
        return uri == null ? null : uri.getPath();
    }

    public static URL getURL(String resourceLocation) throws FileNotFoundException {
        AssertCommand.notNull(resourceLocation, "Resource location must not be null");
        if (resourceLocation.startsWith("classpath:")) {
            URL url;
            String path = resourceLocation.substring("classpath:".length());
            ClassLoader cl = ClassCommand.getDefaultClassLoader();
            URL uRL = url = cl != null ? cl.getResource(path) : ClassLoader.getSystemResource(path);
            if (url == null) {
                String description = "class path resource [" + path + "]";
                throw new FileNotFoundException(description + " cannot be resolved to URL because it does not exist");
            }
            return url;
        }
        try {
            return new URL(resourceLocation);
        }
        catch (MalformedURLException ex) {
            try {
                return new File(resourceLocation).toURI().toURL();
            }
            catch (MalformedURLException ex2) {
                throw new FileNotFoundException("Resource location [" + resourceLocation + "] is neither a URL not a well-formed file path");
            }
        }
    }

    public static URL getURLFromClassLocation(String pathBaseClassLoader) {
        return ClassCommand.getClassLoader().getResource(pathBaseClassLoader);
    }

    public static URL getURL(String path, Class<?> clazz) {
        return clazz.getResource(path);
    }

    public static URL getURL(File file) {
        AssertCommand.notNull(file, "File is null !");
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new UtilException("Error occured when get URL!", e);
        }
    }

    public static URL[] getURLs(File ... files) {
        URL[] urls = new URL[files.length];
        try {
            for (int i = 0; i < files.length; ++i) {
                urls[i] = files[i].toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new UtilException("Error occured when get URL!", e);
        }
        return urls;
    }

    public static String formatUrl(String url) {
        if (StringCommand.isBlank(url)) {
            return null;
        }
        if (url.startsWith("http://") || url.startsWith("https://")) {
            return url;
        }
        return "http://" + url;
    }

    public static String formatUrl(String url, String scheme) {
        if (StringCommand.isBlank(url)) {
            return null;
        }
        if (url.startsWith(scheme)) {
            return url;
        }
        return scheme + url;
    }

    public static String complateUrl(String baseUrl, String relativePath) {
        if (StringCommand.isBlank(baseUrl = UriCommand.formatUrl(baseUrl))) {
            return null;
        }
        try {
            URL absoluteUrl = new URL(baseUrl);
            URL parseUrl = new URL(absoluteUrl, relativePath);
            return parseUrl.toString();
        }
        catch (MalformedURLException e) {
            throw new UtilException(e);
        }
    }

    public static String encode(String url, String charset) {
        try {
            return URLEncoder.encode(url, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException(e);
        }
    }

    public static String encode(String url) {
        return UriCommand.encode(url, "UTF-8");
    }

    public static String decode(String url, String charset) {
        try {
            return URLDecoder.decode(url, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException(e);
        }
    }

    public static boolean isUrl(@Nullable String resourceLocation) {
        if (resourceLocation == null) {
            return false;
        }
        if (resourceLocation.startsWith("classpath:")) {
            return true;
        }
        try {
            new URL(resourceLocation);
            return true;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    public static String decode(String url) {
        return UriCommand.decode(url, "UTF-8");
    }

    public static URI toURI(URL url) {
        return UriCommand.toURI(url.toString());
    }

    public static URI toURI(String location) {
        try {
            return new URI(location.replace(" ", "%20"));
        }
        catch (URISyntaxException e) {
            throw new UtilException(e);
        }
    }

    public String encodeSpaces(String url) {
        String path = StringUtils.substringBefore((String)url, (String)"?");
        path = StringUtils.replace((String)path, (String)" ", (String)"%20");
        String qs = StringUtils.substringAfter((String)url, (String)"?");
        if (StringUtils.isNotBlank((CharSequence)qs)) {
            qs = StringUtils.replace((String)qs, (String)" ", (String)"+");
            url = path + "?" + qs;
        } else {
            url = path;
        }
        return url;
    }
}

