/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.net;

public enum UriScheme {
    HTTPS("https"),
    HTTP("http"),
    FILE("file");

    private final String scheme;

    private UriScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getProtocol() {
        return this.scheme + ":";
    }

    public String getProtocolWithNoAuthority() {
        return this.scheme + "://";
    }

    public String getValueWithNoAuthority(String url) {
        if (!url.contains("://")) {
            return this.scheme + "://" + url;
        }
        return url;
    }

    public String getValue(String url) {
        if (!url.contains(":")) {
            return this.scheme + ":" + url;
        }
        return url;
    }

    public String getValue(String authority, String url) {
        if (authority == null) {
            return this.getValueWithNoAuthority(url);
        }
        return this.getValue(authority + url);
    }
}

