/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.nio;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;

public final class CharsetCommand {
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String UTF_8 = "UTF-8";
    public static final String GBK = "GBK";
    public static final Charset CHARSET_ISO_8859_1 = StandardCharsets.ISO_8859_1;
    public static final Charset CHARSET_UTF_8 = StandardCharsets.UTF_8;
    public static final Charset CHARSET_GBK = Charset.forName("GBK");

    private CharsetCommand() {
    }

    public static Charset charset(String charsetName) {
        return StringCommand.isBlank(charsetName) ? Charset.defaultCharset() : Charset.forName(charsetName);
    }

    public static String convert(String source, String srcCharset, String destCharset) {
        return CharsetCommand.convert(source, Charset.forName(srcCharset), Charset.forName(destCharset));
    }

    public static String convert(String source, Charset srcCharset, Charset destCharset) {
        if (null == srcCharset) {
            srcCharset = StandardCharsets.ISO_8859_1;
        }
        if (null == destCharset) {
            destCharset = StandardCharsets.UTF_8;
        }
        if (StringCommand.isBlank(source) || srcCharset.equals(destCharset)) {
            return source;
        }
        return new String(source.getBytes(srcCharset), destCharset);
    }

    public static String systemCharset() {
        return CharsetCommand.defaultCharsetName();
    }

    public static String defaultCharsetName() {
        return Charset.defaultCharset().name();
    }

    public static Charset defaultCharset() {
        return Charset.defaultCharset();
    }

    public static Charset utf8() {
        return StandardCharsets.UTF_8;
    }

    public static Charset utf16() {
        return StandardCharsets.UTF_16;
    }

    public static Charset utf16Be() {
        return StandardCharsets.UTF_16BE;
    }

    public static Charset utf16Le() {
        return StandardCharsets.UTF_16LE;
    }

    public static Charset ascii() {
        return StandardCharsets.US_ASCII;
    }

    public static Charset iso88591() {
        return StandardCharsets.ISO_8859_1;
    }

    public static Charset gbk() {
        return Charset.forName(GBK);
    }
}

