/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.setting;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.io.file.FileCommand;
import org.gjgr.pig.chivalrous.core.io.resource.UrlResource;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.log.Log;
import org.gjgr.pig.chivalrous.core.log.LogFactory;
import org.gjgr.pig.chivalrous.core.nio.CharsetCommand;
import org.gjgr.pig.chivalrous.core.setting.dialect.BasicSetting;
import org.gjgr.pig.chivalrous.core.util.RegexCommand;

public class SettingLoader {
    private static final String COMMENT_FLAG_PRE = "#";
    private static final String ASSIGN_FLAG = "=";
    private static final char[] GROUP_SURROUND = new char[]{'[', ']'};
    private static Log log = LogFactory.get();
    private String reg_var = "\\$\\{(.*?)\\}";
    private Charset charset;
    private boolean isUseVariable;
    private BasicSetting setting;

    public SettingLoader(BasicSetting setting) {
        this(setting, CharsetCommand.CHARSET_UTF_8, false);
    }

    public SettingLoader(BasicSetting setting, Charset charset, boolean isUseVariable) {
        this.setting = setting;
        this.charset = charset;
        this.isUseVariable = isUseVariable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(UrlResource urlResource) {
        if (urlResource == null) {
            throw new NullPointerException("Null setting url define!");
        }
        log.debug("Load setting file [{}]", urlResource);
        InputStream settingStream = null;
        try {
            settingStream = urlResource.getStream();
            this.load(settingStream);
        }
        catch (Exception e) {
            log.error(e, "Load setting error!", new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            IoCommand.close(settingStream);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(InputStream settingStream) throws IOException {
        this.setting.clear();
        BufferedReader reader = null;
        try {
            String line;
            reader = IoCommand.getReader(settingStream, this.charset);
            String group = null;
            while ((line = reader.readLine()) != null) {
                if (StringCommand.isBlank(line = line.trim()) || line.startsWith(COMMENT_FLAG_PRE)) continue;
                if (line.charAt(0) == GROUP_SURROUND[0] && line.charAt(line.length() - 1) == GROUP_SURROUND[1]) {
                    group = line.substring(1, line.length() - 1).trim();
                    this.setting.getGroups().add(group);
                    continue;
                }
                String[] keyValue = line.split(ASSIGN_FLAG, 2);
                if (keyValue.length < 2) continue;
                String key = keyValue[0].trim();
                if (!StringCommand.isBlank(group)) {
                    key = group + "." + key;
                }
                String value = keyValue[1].trim();
                if (this.isUseVariable) {
                    value = this.replaceVar(value);
                }
                this.setting.put(key, value);
            }
        }
        catch (Throwable throwable) {
            IoCommand.close(reader);
            throw throwable;
        }
        IoCommand.close(reader);
        return true;
    }

    public void setVarRegex(String regex) {
        this.reg_var = regex;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(String absolutePath) {
        BufferedWriter writer = null;
        try {
            writer = FileCommand.bufferedWriter(absolutePath, this.charset, false);
            for (Map.Entry<Object, Object> entry : this.setting.entrySet()) {
                writer.write(StringCommand.format("{} {} {}", entry.getKey(), ASSIGN_FLAG, entry.getValue()));
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw new RuntimeException(StringCommand.format("Can not find file [{}]!", absolutePath), e);
                catch (IOException e2) {
                    throw new RuntimeException("Store Setting error!", e2);
                }
            }
            catch (Throwable throwable) {
                IoCommand.close(writer);
                throw throwable;
            }
        }
        IoCommand.close(writer);
    }

    public void autoReload() {
    }

    private String replaceVar(String value) {
        Set vars = RegexCommand.findAll(this.reg_var, value, 0, new HashSet());
        for (String var : vars) {
            Object varValue = this.setting.get(RegexCommand.get(this.reg_var, var, 1));
            if (null == varValue || !(value instanceof CharSequence)) continue;
            value = value.replace(var, (CharSequence)varValue);
        }
        return value;
    }
}

