/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.setting.dialect;

import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gjgr.pig.chivalrous.core.convert.Convert;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.io.resource.ClassPathResource;
import org.gjgr.pig.chivalrous.core.io.resource.UrlResource;
import org.gjgr.pig.chivalrous.core.io.watch.SimpleWatcher;
import org.gjgr.pig.chivalrous.core.io.watch.WatchMonitor;
import org.gjgr.pig.chivalrous.core.lang.AssertCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.log.StaticLog;
import org.gjgr.pig.chivalrous.core.nio.CharsetCommand;
import org.gjgr.pig.chivalrous.core.setting.AbsSetting;
import org.gjgr.pig.chivalrous.core.setting.SettingLoader;
import org.gjgr.pig.chivalrous.core.setting.SettingRuntimeException;

public class BasicSetting
extends AbsSetting
implements Map<Object, Object> {
    public static final Charset DEFAULT_CHARSET = CharsetCommand.CHARSET_UTF_8;
    private final LinkedList<String> groups = new LinkedList();
    private final Map<Object, Object> map = new ConcurrentHashMap<Object, Object>();
    protected Charset charset;
    protected boolean isUseVariable;
    protected URL settingUrl;
    private SettingLoader settingLoader;
    private WatchMonitor watchMonitor;

    public BasicSetting() {
    }

    public BasicSetting(String pathBaseClassLoader) {
        this(pathBaseClassLoader, DEFAULT_CHARSET, false);
    }

    public BasicSetting(String pathBaseClassLoader, Charset charset, boolean isUseVariable) {
        AssertCommand.notBlank(pathBaseClassLoader, "Blank setting path !");
        this.init(new ClassPathResource(pathBaseClassLoader), charset, isUseVariable);
    }

    public BasicSetting(File configFile, Charset charset, boolean isUseVariable) {
        AssertCommand.notNull(configFile, "Null setting file define!");
        this.init(new UrlResource(configFile), charset, isUseVariable);
    }

    public BasicSetting(String path, Class<?> clazz, Charset charset, boolean isUseVariable) {
        AssertCommand.notBlank(path, "Blank setting path !");
        this.init(new ClassPathResource(path, clazz), charset, isUseVariable);
    }

    public BasicSetting(URL url, Charset charset, boolean isUseVariable) {
        AssertCommand.notNull(url, "Null setting url define!");
        this.init(new UrlResource(url), charset, isUseVariable);
    }

    public boolean init(UrlResource urlResource, Charset charset, boolean isUseVariable) {
        if (urlResource == null) {
            throw new NullPointerException("Null setting url define!");
        }
        this.settingUrl = urlResource.getUrl();
        this.charset = charset;
        this.isUseVariable = isUseVariable;
        return this.load();
    }

    public synchronized boolean load() {
        if (null == this.settingLoader) {
            this.settingLoader = new SettingLoader(this, this.charset, this.isUseVariable);
        }
        return this.settingLoader.load(new UrlResource(this.settingUrl));
    }

    public void autoLoad(boolean autoReload) {
        if (autoReload) {
            if (null != this.watchMonitor) {
                this.watchMonitor.close();
            }
            try {
                this.watchMonitor = WatchMonitor.create(this.settingUrl, StandardWatchEventKinds.ENTRY_MODIFY);
                this.watchMonitor.setWatcher(new SimpleWatcher(){

                    @Override
                    public void onModify(WatchEvent<?> event) {
                        BasicSetting.this.load();
                    }
                }).start();
            }
            catch (Exception e) {
                throw new SettingRuntimeException(e, "Setting auto load not support url: [{}]", this.settingUrl);
            }
            StaticLog.debug("Auto load for [{}] listenning...", this.settingUrl);
        } else {
            IoCommand.close(this.watchMonitor);
            this.watchMonitor = null;
        }
    }

    public String getSettingPath() {
        return null == this.settingUrl ? null : this.settingUrl.getPath();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Object put(Object key, Object value) {
        return this.map.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> map) {
        this.map.putAll(map);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<Object> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Object getObj(String key, Object defaultValue) {
        Object value = this.map.get(key);
        if (null == value) {
            return defaultValue;
        }
        return value;
    }

    public Map<?, ?> getMap(String group) {
        if (StringCommand.isBlank(group)) {
            return this;
        }
        String groupDot = group.concat(".");
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        for (Object key : this.map.keySet()) {
            String keyStr = Convert.toStr(key);
            if (!StringCommand.isNotBlank(keyStr) || !keyStr.startsWith(groupDot)) continue;
            map2.put(StringCommand.removePrefix(keyStr, groupDot), this.map.get(key));
        }
        return map2;
    }

    public BasicSetting getSetting(String group) {
        BasicSetting setting = new BasicSetting();
        setting.putAll((Map<? extends Object, ? extends Object>)this.getMap(group));
        return setting;
    }

    public Properties getProperties(String group) {
        Properties properties = new Properties();
        properties.putAll(this.getMap(group));
        return properties;
    }

    public void store(String absolutePath) {
        if (null == this.settingLoader) {
            this.settingLoader = new SettingLoader(this, this.charset, this.isUseVariable);
        }
        this.settingLoader.store(absolutePath);
    }

    public void setVarRegex(String regex) {
        if (null == this.settingLoader) {
            throw new NullPointerException("SettingLoader is null !");
        }
        this.settingLoader.setVarRegex(regex);
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.putAll(this.map);
        return properties;
    }

    public LinkedList<String> getGroups() {
        return this.groups;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.charset == null ? 0 : this.charset.hashCode());
        result = 31 * result + (this.groups == null ? 0 : this.groups.hashCode());
        result = 31 * result + (this.isUseVariable ? 1231 : 1237);
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        result = 31 * result + (this.settingUrl == null ? 0 : this.settingUrl.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicSetting other = (BasicSetting)obj;
        if (this.charset == null ? other.charset != null : !this.charset.equals(other.charset)) {
            return false;
        }
        if (this.groups == null ? other.groups != null : !this.groups.equals(other.groups)) {
            return false;
        }
        if (this.isUseVariable != other.isUseVariable) {
            return false;
        }
        if (this.map == null ? other.map != null : !this.map.equals(other.map)) {
            return false;
        }
        return !(this.settingUrl == null ? other.settingUrl != null : !this.settingUrl.equals(other.settingUrl));
    }

    public String toString() {
        return this.map.toString();
    }
}

