/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.system;

import org.gjgr.pig.chivalrous.core.system.JavaSystemCommand;

public class JavaInfo {
    private final String JAVA_VERSION = JavaSystemCommand.get("java.version", false);
    private final float JAVA_VERSION_FLOAT = this.getJavaVersionAsFloat();
    private final int JAVA_VERSION_INT = this.getJavaVersionAsInt();
    private final String JAVA_VENDOR = JavaSystemCommand.get("java.vendor", false);
    private final String JAVA_VENDOR_URL = JavaSystemCommand.get("java.vendor.url", false);
    private final boolean IS_JAVA_1_1 = this.getJavaVersionMatches("1.1");
    private final boolean IS_JAVA_1_2 = this.getJavaVersionMatches("1.2");
    private final boolean IS_JAVA_1_3 = this.getJavaVersionMatches("1.3");
    private final boolean IS_JAVA_1_4 = this.getJavaVersionMatches("1.4");
    private final boolean IS_JAVA_1_5 = this.getJavaVersionMatches("1.5");
    private final boolean IS_JAVA_1_6 = this.getJavaVersionMatches("1.6");
    private final boolean IS_JAVA_1_7 = this.getJavaVersionMatches("1.7");
    private final boolean IS_JAVA_1_8 = this.getJavaVersionMatches("1.8");

    public final String getVersion() {
        return this.JAVA_VERSION;
    }

    public final float getVersionFloat() {
        return this.JAVA_VERSION_FLOAT;
    }

    public final int getVersionInt() {
        return this.JAVA_VERSION_INT;
    }

    private final float getJavaVersionAsFloat() {
        if (this.JAVA_VERSION == null) {
            return 0.0f;
        }
        String str = this.JAVA_VERSION.substring(0, 3);
        if (this.JAVA_VERSION.length() >= 5) {
            str = str + this.JAVA_VERSION.substring(4, 5);
        }
        return Float.parseFloat(str);
    }

    private final int getJavaVersionAsInt() {
        if (this.JAVA_VERSION == null) {
            return 0;
        }
        String str = this.JAVA_VERSION.substring(0, 1);
        str = str + this.JAVA_VERSION.substring(2, 3);
        str = this.JAVA_VERSION.length() >= 5 ? str + this.JAVA_VERSION.substring(4, 5) : str + "0";
        return Integer.parseInt(str);
    }

    public final String getVendor() {
        return this.JAVA_VENDOR;
    }

    public final String getVendorURL() {
        return this.JAVA_VENDOR_URL;
    }

    public final boolean isJava11() {
        return this.IS_JAVA_1_1;
    }

    public final boolean isJava12() {
        return this.IS_JAVA_1_2;
    }

    public final boolean isJava13() {
        return this.IS_JAVA_1_3;
    }

    public final boolean isJava14() {
        return this.IS_JAVA_1_4;
    }

    public final boolean isJava15() {
        return this.IS_JAVA_1_5;
    }

    public final boolean isJava16() {
        return this.IS_JAVA_1_6;
    }

    public final boolean isJava17() {
        return this.IS_JAVA_1_7;
    }

    public final boolean isJava18() {
        return this.IS_JAVA_1_8;
    }

    private final boolean getJavaVersionMatches(String versionPrefix) {
        if (this.JAVA_VERSION == null) {
            return false;
        }
        return this.JAVA_VERSION.startsWith(versionPrefix);
    }

    public final boolean isJavaVersionAtLeast(float requiredVersion) {
        return this.getVersionFloat() >= requiredVersion;
    }

    public final boolean isJavaVersionAtLeast(int requiredVersion) {
        return this.getVersionInt() >= requiredVersion;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        JavaSystemCommand.append(builder, "Java Version:    ", this.getVersion());
        JavaSystemCommand.append(builder, "Java Vendor:     ", this.getVendor());
        JavaSystemCommand.append(builder, "Java Vendor URL: ", this.getVendorURL());
        return builder.toString();
    }
}

