/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.system;

import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import org.gjgr.pig.chivalrous.core.convert.Convert;
import org.gjgr.pig.chivalrous.core.lang.Console;
import org.gjgr.pig.chivalrous.core.lang.Singleton;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.system.HostInfo;
import org.gjgr.pig.chivalrous.core.system.JavaInfo;
import org.gjgr.pig.chivalrous.core.system.JavaRuntimeInfo;
import org.gjgr.pig.chivalrous.core.system.JavaSpecInfo;
import org.gjgr.pig.chivalrous.core.system.JvmInfo;
import org.gjgr.pig.chivalrous.core.system.JvmSpecInfo;
import org.gjgr.pig.chivalrous.core.system.OsInfo;
import org.gjgr.pig.chivalrous.core.system.RuntimeInfo;
import org.gjgr.pig.chivalrous.core.system.UserInfo;

public final class JavaSystemCommand {
    public static final String SPECIFICATION_NAME = "java.specification.name";
    public static final String VERSION = "java.version";
    public static final String SPECIFICATION_VERSION = "java.specification.version";
    public static final String VENDOR = "java.vendor";
    public static final String SPECIFICATION_VENDOR = "java.specification.vendor";
    public static final String VENDOR_URL = "java.vendor.url";
    public static final String HOME = "java.home";
    public static final String LIBRARY_PATH = "java.library.path";
    public static final String TMPDIR = "java.io.tmpdir";
    public static final String COMPILER = "java.compiler";
    public static final String EXT_DIRS = "java.ext.dirs";
    public static final String VM_NAME = "java.vm.name";
    public static final String VM_SPECIFICATION_NAME = "java.vm.specification.name";
    public static final String VM_VERSION = "java.vm.version";
    public static final String VM_SPECIFICATION_VERSION = "java.vm.specification.version";
    public static final String VM_VENDEOR = "java.vm.vendor";
    public static final String VM_SPECIFICATION_VENDOR = "java.vm.specification.vendor";
    public static final String CLASS_VERSION = "java.class.version";
    public static final String CLASS_PATH = "java.class.path";
    public static final String OS_NAME = "os.name";
    public static final String OS_ARCH = "os.arch";
    public static final String OS_VERSION = "os.version";
    public static final String FILE_SEPRATOR = "file.separator";
    public static final String PATH_SEPRATOR = "path.separator";
    public static final String LINE_SEPRATOR = "line.separator";
    public static final String USER_NAME = "user.name";
    public static final String USER_HOME = "user.home";
    public static final String USER_DIR = "user.dir";

    private JavaSystemCommand() {
    }

    public static String get(String name, String defaultValue) {
        return StringCommand.nullToDefault(JavaSystemCommand.get(name, false), defaultValue);
    }

    public static String get(String name, boolean quiet) {
        try {
            return System.getProperty(name);
        }
        catch (SecurityException e) {
            if (!quiet) {
                Console.error("Caught a SecurityException reading the system property '{}'; the JavaSystemCommand property value will default to null.", name);
            }
            return null;
        }
    }

    public static String get(String key) {
        return JavaSystemCommand.get(key, null);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = JavaSystemCommand.get(key);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.trim().toLowerCase()).isEmpty()) {
            return true;
        }
        if ("true".equals(value) || "yes".equals(value) || "1".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "no".equals(value) || "0".equals(value)) {
            return false;
        }
        return defaultValue;
    }

    public static long getInt(String key, int defaultValue) {
        return Convert.toInt(JavaSystemCommand.get(key), defaultValue).intValue();
    }

    public static long getLong(String key, long defaultValue) {
        return Convert.toLong(JavaSystemCommand.get(key), defaultValue);
    }

    public static Properties props() {
        return System.getProperties();
    }

    public static long getCurrentPID() {
        return Long.parseLong(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
    }

    public static final JvmSpecInfo getJvmSpecInfo() {
        return Singleton.get(JvmSpecInfo.class, new Object[0]);
    }

    public static final JvmInfo getJvmInfo() {
        return Singleton.get(JvmInfo.class, new Object[0]);
    }

    public static final JavaSpecInfo getJavaSpecInfo() {
        return Singleton.get(JavaSpecInfo.class, new Object[0]);
    }

    public static final JavaInfo getJavaInfo() {
        return Singleton.get(JavaInfo.class, new Object[0]);
    }

    public static final JavaRuntimeInfo getJavaRuntimeInfo() {
        return Singleton.get(JavaRuntimeInfo.class, new Object[0]);
    }

    public static final OsInfo getOsInfo() {
        return Singleton.get(OsInfo.class, new Object[0]);
    }

    public static final UserInfo getUserInfo() {
        return Singleton.get(UserInfo.class, new Object[0]);
    }

    public static final HostInfo getHostInfo() {
        return Singleton.get(HostInfo.class, new Object[0]);
    }

    public static final RuntimeInfo getRuntimeInfo() {
        return Singleton.get(RuntimeInfo.class, new Object[0]);
    }

    public static final void dumpSystemInfo() {
        JavaSystemCommand.dumpSystemInfo(new PrintWriter(System.out));
    }

    public static final void dumpSystemInfo(PrintWriter out) {
        out.println("--------------");
        out.println(JavaSystemCommand.getJvmSpecInfo());
        out.println("--------------");
        out.println(JavaSystemCommand.getJvmInfo());
        out.println("--------------");
        out.println(JavaSystemCommand.getJavaSpecInfo());
        out.println("--------------");
        out.println(JavaSystemCommand.getJavaInfo());
        out.println("--------------");
        out.println(JavaSystemCommand.getJavaRuntimeInfo());
        out.println("--------------");
        out.println(JavaSystemCommand.getOsInfo());
        out.println("--------------");
        out.println(JavaSystemCommand.getUserInfo());
        out.println("--------------");
        out.println(JavaSystemCommand.getHostInfo());
        out.println("--------------");
        out.println(JavaSystemCommand.getRuntimeInfo());
        out.println("--------------");
        out.flush();
    }

    protected static void append(StringBuilder builder, String caption, Object value) {
        builder.append(caption).append(StringCommand.nullToDefault(Convert.toStr(value), "[n/a]")).append("\n");
    }
}

