/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.thread;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadDataFormat {
    private static Logger logger = LoggerFactory.getLogger(ThreadDataFormat.class);
    private ThreadLocal<DateFormat> threadLocal = new ThreadLocal();
    private String pattern = "yyyy-MM-dd HH:mm:ss";
    private String timeZone = "Asia/Shanghai";
    private String locale = "en-US";

    private ThreadDataFormat() {
    }

    private ThreadDataFormat(String pattern) {
        this.pattern = pattern;
    }

    private ThreadDataFormat(String pattern, String timeZone) {
        this(pattern);
        this.timeZone = timeZone;
    }

    private ThreadDataFormat(String pattern, String timeZone, String locale) {
        this(pattern, timeZone);
        this.locale = locale;
    }

    public static ThreadDataFormat getInstance(String pattern) {
        return new ThreadDataFormat(pattern);
    }

    public static ThreadDataFormat getInstance(String pattern, String timeZone) {
        return new ThreadDataFormat(pattern, timeZone);
    }

    public static ThreadDataFormat getInstance(String pattern, String timeZone, String locale) {
        return new ThreadDataFormat(pattern, timeZone, locale);
    }

    private Locale makeLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        String[] countryTolang = this.locale.split("_");
        if (countryTolang.length == 1) {
            return new Locale(this.locale);
        }
        return new Locale(countryTolang[0], countryTolang[1]);
    }

    private DateFormat getDateFormat(boolean refresh) {
        DateFormat df = this.threadLocal.get();
        if (df == null || refresh) {
            df = new SimpleDateFormat(this.pattern, this.makeLocale());
            df.setTimeZone(TimeZone.getTimeZone(this.timeZone));
            this.threadLocal.set(df);
        }
        return df;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        this.getDateFormat(true);
    }

    public void setLocale(String locale) {
        this.locale = locale;
        this.getDateFormat(true);
    }

    public Date parse(String dateTime) {
        try {
            return this.getDateFormat(false).parse(dateTime);
        }
        catch (ParseException e) {
            logger.error("parse {} error, msg {}", (Object)dateTime, (Object)e.getMessage());
            return null;
        }
    }

    public String format(Date date) {
        return this.getDateFormat(false).format(date);
    }
}

