/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.gjgr.pig.chivalrous.core.exceptions.UtilException;
import org.gjgr.pig.chivalrous.core.io.file.FileCommand;

public final class ImageCommand {
    public static String IMAGE_TYPE_GIF = "gif";
    public static String IMAGE_TYPE_JPG = "jpg";
    public static String IMAGE_TYPE_JPEG = "jpeg";
    public static String IMAGE_TYPE_BMP = "bmp";
    public static String IMAGE_TYPE_PNG = "png";
    public static String IMAGE_TYPE_PSD = "psd";

    private ImageCommand() {
    }

    public static final void scale(File srcImageFile, File destImageFile, int scale, boolean flag) {
        try {
            BufferedImage src = ImageIO.read(srcImageFile);
            int width = src.getWidth();
            int height = src.getHeight();
            if (flag) {
                width *= scale;
                height *= scale;
            } else {
                width /= scale;
                height /= scale;
            }
            Image image = src.getScaledInstance(width, height, 1);
            BufferedImage tag = new BufferedImage(width, height, 1);
            Graphics g = tag.getGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            ImageIO.write((RenderedImage)tag, IMAGE_TYPE_JPEG, destImageFile);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static final void scale(File srcImageFile, File destImageFile, int height, int width, Color fixedColor) {
        try {
            double ratio = 0.0;
            BufferedImage bi = ImageIO.read(srcImageFile);
            Image itemp = bi.getScaledInstance(width, height, 4);
            if (bi.getHeight() > height || bi.getWidth() > width) {
                ratio = bi.getHeight() > bi.getWidth() ? new Integer(height).doubleValue() / (double)bi.getHeight() : new Integer(width).doubleValue() / (double)bi.getWidth();
                AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(ratio, ratio), null);
                itemp = op.filter(bi, null);
            }
            if (null != fixedColor) {
                BufferedImage image = new BufferedImage(width, height, 1);
                Graphics2D g = image.createGraphics();
                g.setColor(fixedColor);
                g.fillRect(0, 0, width, height);
                if (width == itemp.getWidth(null)) {
                    g.drawImage(itemp, 0, (height - itemp.getHeight(null)) / 2, itemp.getWidth(null), itemp.getHeight(null), fixedColor, null);
                } else {
                    g.drawImage(itemp, (width - itemp.getWidth(null)) / 2, 0, itemp.getWidth(null), itemp.getHeight(null), fixedColor, null);
                }
                g.dispose();
                itemp = image;
            }
            ImageIO.write((RenderedImage)((BufferedImage)itemp), IMAGE_TYPE_JPEG, destImageFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final void cut(File srcImageFile, File destImageFile, int x, int y, int width, int height) {
        try {
            BufferedImage bi = ImageIO.read(srcImageFile);
            int srcWidth = bi.getHeight();
            int srcHeight = bi.getWidth();
            if (srcWidth > 0 && srcHeight > 0) {
                Image image = bi.getScaledInstance(srcWidth, srcHeight, 1);
                CropImageFilter cropFilter = new CropImageFilter(x, y, width, height);
                Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropFilter));
                BufferedImage tag = new BufferedImage(width, height, 1);
                Graphics g = tag.getGraphics();
                g.drawImage(img, 0, 0, width, height, null);
                g.dispose();
                ImageIO.write((RenderedImage)tag, IMAGE_TYPE_JPEG, destImageFile);
            }
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static final void cutByRowsAndCols(File srcImageFile, File descDir, int rows, int cols) {
        try {
            if (rows <= 0 || rows > 20) {
                rows = 2;
            }
            if (cols <= 0 || cols > 20) {
                cols = 2;
            }
            BufferedImage bi = ImageIO.read(srcImageFile);
            int srcWidth = bi.getHeight();
            int srcHeight = bi.getWidth();
            if (srcWidth > 0 && srcHeight > 0) {
                Image image = bi.getScaledInstance(srcWidth, srcHeight, 1);
                int destWidth = srcWidth;
                int destHeight = srcHeight;
                destWidth = srcWidth % cols == 0 ? srcWidth / cols : (int)Math.floor(srcWidth / cols) + 1;
                destHeight = srcHeight % rows == 0 ? srcHeight / rows : (int)Math.floor(srcWidth / rows) + 1;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        CropImageFilter cropFilter = new CropImageFilter(j * destWidth, i * destHeight, destWidth, destHeight);
                        Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropFilter));
                        BufferedImage tag = new BufferedImage(destWidth, destHeight, 1);
                        Graphics g = tag.getGraphics();
                        g.drawImage(img, 0, 0, null);
                        g.dispose();
                        ImageIO.write((RenderedImage)tag, IMAGE_TYPE_JPEG, new File(descDir, "_r" + i + "_c" + j + ".jpg"));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static final void cut(File srcImageFile, File descDir, int destWidth, int destHeight) {
        try {
            if (destWidth <= 0) {
                destWidth = 200;
            }
            if (destHeight <= 0) {
                destHeight = 150;
            }
            BufferedImage bi = ImageIO.read(srcImageFile);
            int srcWidth = bi.getHeight();
            int srcHeight = bi.getWidth();
            if (srcWidth > destWidth && srcHeight > destHeight) {
                Image image = bi.getScaledInstance(srcWidth, srcHeight, 1);
                int cols = 0;
                int rows = 0;
                cols = srcWidth % destWidth == 0 ? srcWidth / destWidth : (int)Math.floor(srcWidth / destWidth) + 1;
                rows = srcHeight % destHeight == 0 ? srcHeight / destHeight : (int)Math.floor(srcHeight / destHeight) + 1;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        CropImageFilter cropFilter = new CropImageFilter(j * destWidth, i * destHeight, destWidth, destHeight);
                        Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropFilter));
                        BufferedImage tag = new BufferedImage(destWidth, destHeight, 1);
                        Graphics g = tag.getGraphics();
                        g.drawImage(img, 0, 0, null);
                        g.dispose();
                        ImageIO.write((RenderedImage)tag, "JPEG", new File(descDir, "_r" + i + "_c" + j + ".jpg"));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void convert(File srcImageFile, String formatName, File destImageFile) {
        try {
            BufferedImage src = ImageIO.read(srcImageFile);
            ImageIO.write((RenderedImage)src, formatName, destImageFile);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static final void gray(File srcImageFile, File destImageFile) {
        try {
            BufferedImage src = ImageIO.read(srcImageFile);
            ColorSpace cs = ColorSpace.getInstance(1003);
            ColorConvertOp op = new ColorConvertOp(cs, null);
            src = op.filter(src, null);
            ImageIO.write((RenderedImage)src, IMAGE_TYPE_JPEG, destImageFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final void pressText(String pressText, File srcImageFile, File destImageFile, String fontName, int fontStyle, Color color, int fontSize, int x, int y, float alpha) {
        try {
            BufferedImage src = ImageIO.read(srcImageFile);
            int width = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, width, height, null);
            g.setColor(color);
            g.setFont(new Font(fontName, fontStyle, fontSize));
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            g.drawString(pressText, (width - ImageCommand.getLength(pressText) * fontSize) / 2 + x, (height - fontSize) / 2 + y);
            g.dispose();
            ImageIO.write((RenderedImage)image, IMAGE_TYPE_JPEG, destImageFile);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static final void pressImage(File pressImgFile, File srcImageFile, File destImageFile, int x, int y, float alpha) {
        try {
            BufferedImage src = ImageIO.read(srcImageFile);
            int width = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, width, height, null);
            BufferedImage pressImg = ImageIO.read(pressImgFile);
            int pressImgWidth = ((Image)pressImg).getWidth(null);
            int pressImgHeight = ((Image)pressImg).getHeight(null);
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            g.drawImage(pressImg, x += (width - pressImgWidth) / 2, y += (height - pressImgHeight) / 2, pressImgWidth, pressImgHeight, null);
            g.dispose();
            ImageIO.write((RenderedImage)image, "JPEG", destImageFile);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    private static final int getLength(String text) {
        int length = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (new String(text.charAt(i) + "").getBytes().length > 1) {
                length += 2;
                continue;
            }
            ++length;
        }
        return length / 2;
    }

    public static BufferedImage webpImageInfo(String fileName) {
        BufferedImage bufferedImage = null;
        try {
            FileInputStream file = new FileInputStream(FileCommand.file(fileName));
            byte[] bytes = new byte[30];
            file.read(bytes, 0, bytes.length);
            int width = (bytes[27] & 0xFF) << 8 | bytes[26] & 0xFF;
            int height = (bytes[29] & 0xFF) << 8 | bytes[28] & 0xFF;
            bufferedImage = new BufferedImage(width, height, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            bufferedImage = new BufferedImage(-1, -1, 0);
        }
        return bufferedImage;
    }

    public static BufferedImage commonImage(String url) {
        try {
            InputStream inputStream = FileCommand.inputStream(url);
            return ImageIO.read(inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("not found or did not support type, for url " + url);
        }
    }
}

