/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gjgr.pig.chivalrous.core.convert.Convert;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.Holder;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.lang.Validator;

public final class RegexCommand {
    public static final String RE_CHINESE = "[\u4e00-\u9fff]";
    public static final Pattern GROUP_VAR = Pattern.compile("\\$(\\d+)");
    public static final Set<Character> RE_KEYS = CollectionCommand.newHashSet(Character.valueOf('$'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('.'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('?'), Character.valueOf('\\'), Character.valueOf('^'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|'));

    private RegexCommand() {
    }

    public static String get(String regex, String content, int groupIndex) {
        if (null == content || null == regex) {
            return null;
        }
        Pattern pattern = Pattern.compile(regex, 32);
        return RegexCommand.get(pattern, content, groupIndex);
    }

    public static String get(Pattern pattern, String content, int groupIndex) {
        if (null == content || null == pattern) {
            return null;
        }
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(groupIndex);
        }
        return null;
    }

    public static String extractMulti(Pattern pattern, String content, String template) {
        if (null == content || null == pattern || null == template) {
            return null;
        }
        HashSet<String> varNums = RegexCommand.findAll(GROUP_VAR, template, 1, new HashSet());
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            for (String var : varNums) {
                int group = Integer.parseInt(var);
                template = template.replace("$" + var, matcher.group(group));
            }
            return template;
        }
        return null;
    }

    public static String extractMulti(String regex, String content, String template) {
        if (null == content || null == regex || null == template) {
            return null;
        }
        Pattern pattern = Pattern.compile(regex, 32);
        return RegexCommand.extractMulti(pattern, content, template);
    }

    public static String extractMultiAndDelPre(Pattern pattern, Holder<String> contentHolder, String template) {
        if (null == contentHolder || null == pattern || null == template) {
            return null;
        }
        HashSet<String> varNums = RegexCommand.findAll(GROUP_VAR, template, 1, new HashSet());
        String content = (String)contentHolder.get();
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            for (String var : varNums) {
                int group = Integer.parseInt(var);
                template = template.replace("$" + var, matcher.group(group));
            }
            contentHolder.set(StringCommand.sub(content, matcher.end(), content.length()));
            return template;
        }
        return null;
    }

    public static String extractMultiAndDelPre(String regex, Holder<String> contentHolder, String template) {
        if (null == contentHolder || null == regex || null == template) {
            return null;
        }
        Pattern pattern = Pattern.compile(regex, 32);
        return RegexCommand.extractMultiAndDelPre(pattern, contentHolder, template);
    }

    public static String delFirst(String regex, String content) {
        if (null == content || null == regex) {
            return content;
        }
        return content.replaceFirst(regex, "");
    }

    public static String delPre(String regex, String content) {
        if (null == content || null == regex) {
            return content;
        }
        Matcher matcher = Pattern.compile(regex, 32).matcher(content);
        if (matcher.find()) {
            return StringCommand.sub(content, matcher.end(), content.length());
        }
        return content;
    }

    public static <T extends Collection<String>> T findAll(String regex, String content, int group, T collection) {
        if (null == regex) {
            return null;
        }
        Pattern pattern = Pattern.compile(regex, 32);
        return RegexCommand.findAll(pattern, content, group, collection);
    }

    public static <T extends Collection<String>> T findAll(Pattern pattern, String content, int group, T collection) {
        if (null == pattern || null == content) {
            return null;
        }
        if (null == collection) {
            throw new NullPointerException("Null collection paramMap provided!");
        }
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            collection.add((String)matcher.group(group));
        }
        return collection;
    }

    public static int count(String regex, String content) {
        if (null == regex) {
            return 0;
        }
        Pattern pattern = Pattern.compile(regex, 32);
        return RegexCommand.count(pattern, content);
    }

    public static int count(Pattern pattern, String content) {
        if (null == pattern || null == content) {
            return 0;
        }
        int count = 0;
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public static Integer getFirstNumber(String StringWithNumber) {
        return Convert.toInt(RegexCommand.get(Validator.NUMBERS, StringWithNumber, 0), null);
    }

    public static boolean isMatch(String regex, String content) {
        if (content == null) {
            return false;
        }
        if (StringCommand.isEmpty(regex)) {
            return true;
        }
        return Pattern.matches(regex, content);
    }

    public static boolean isMatch(Pattern pattern, String content) {
        if (content == null || pattern == null) {
            return false;
        }
        return pattern.matcher(content).matches();
    }

    public static String replaceAll(String content, String regex, String replacementTemplate) {
        Pattern pattern = Pattern.compile(regex, 32);
        return RegexCommand.replaceAll(content, pattern, replacementTemplate);
    }

    public static String replaceAll(String content, Pattern pattern, String replacementTemplate) {
        if (StringCommand.isEmpty(content)) {
            return content;
        }
        Matcher matcher = pattern.matcher(content);
        boolean result = matcher.find();
        if (result) {
            Set varNums = RegexCommand.findAll(GROUP_VAR, replacementTemplate, 1, new HashSet());
            StringBuffer sb = new StringBuffer();
            do {
                String replacement = replacementTemplate;
                for (String var : varNums) {
                    int group = Integer.parseInt(var);
                    replacement = replacement.replace("$" + var, matcher.group(group));
                }
                matcher.appendReplacement(sb, RegexCommand.escape(replacement));
            } while (result = matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return content;
    }

    public static String escape(String content) {
        if (StringCommand.isBlank(content)) {
            return content;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < content.length(); ++i) {
            char current = content.charAt(i);
            if (RE_KEYS.contains(Character.valueOf(current))) {
                builder.append('\\');
            }
            builder.append(current);
        }
        return builder.toString();
    }
}

