/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.xml;

import org.gjgr.pig.chivalrous.core.json.InternalJsonUtil;
import org.gjgr.pig.chivalrous.core.json.JsonException;
import org.gjgr.pig.chivalrous.core.json.bean.JsonArray;
import org.gjgr.pig.chivalrous.core.json.bean.JsonObject;
import org.gjgr.pig.chivalrous.core.xml.XmlTokener;

public class XmlBetweenJsonObject {
    public static final Character AMP = Character.valueOf('&');
    public static final Character APOS = Character.valueOf('\'');
    public static final Character BANG = Character.valueOf('!');
    public static final Character EQ = Character.valueOf('=');
    public static final Character GT = Character.valueOf('>');
    public static final Character LT = Character.valueOf('<');
    public static final Character QUEST = Character.valueOf('?');
    public static final Character QUOT = Character.valueOf('\"');
    public static final Character SLASH = Character.valueOf('/');

    public static String escape(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        int length = string.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static void noSpace(String string) throws JsonException {
        int length = string.length();
        if (length == 0) {
            throw new JsonException("Empty string.");
        }
        for (int i = 0; i < length; ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            throw new JsonException("'" + string + "' contains a space character.");
        }
    }

    private static boolean parse(XmlTokener x, JsonObject context, String name, boolean keepStrings) throws JsonException {
        String string;
        JsonObject jsonobject = null;
        Object token = x.nextToken();
        if (token == BANG) {
            char c = x.next();
            if (c == '-') {
                if (x.next() == '-') {
                    x.skipPast("-->");
                    return false;
                }
                x.back();
            } else if (c == '[') {
                token = x.nextToken();
                if ("CDATA".equals(token) && x.next() == '[') {
                    String string2 = x.nextCDATA();
                    if (string2.length() > 0) {
                        context.accumulate("content", string2);
                    }
                    return false;
                }
                throw x.syntaxError("Expected 'CDATA['");
            }
            int i = 1;
            do {
                if ((token = x.nextMeta()) == null) {
                    throw x.syntaxError("Missing '>' after '<!'.");
                }
                if (token == LT) {
                    ++i;
                    continue;
                }
                if (token != GT) continue;
                --i;
            } while (i > 0);
            return false;
        }
        if (token == QUEST) {
            x.skipPast("?>");
            return false;
        }
        if (token == SLASH) {
            token = x.nextToken();
            if (name == null) {
                throw x.syntaxError("Mismatched close tag " + token);
            }
            if (!token.equals(name)) {
                throw x.syntaxError("Mismatched " + name + " and " + token);
            }
            if (x.nextToken() != GT) {
                throw x.syntaxError("Misshaped close tag");
            }
            return true;
        }
        if (token instanceof Character) {
            throw x.syntaxError("Misshaped tag");
        }
        String tagName = (String)token;
        token = null;
        jsonobject = new JsonObject();
        while (true) {
            if (token == null) {
                token = x.nextToken();
            }
            if (!(token instanceof String)) break;
            string = (String)token;
            token = x.nextToken();
            if (token == EQ) {
                token = x.nextToken();
                if (!(token instanceof String)) {
                    throw x.syntaxError("Missing value");
                }
                jsonobject.accumulate(string, keepStrings ? token : InternalJsonUtil.stringToValue((String)token));
                token = null;
                continue;
            }
            jsonobject.accumulate(string, "");
        }
        if (token == SLASH) {
            if (x.nextToken() != GT) {
                throw x.syntaxError("Misshaped tag");
            }
            if (jsonobject.size() > 0) {
                context.accumulate(tagName, jsonobject);
            } else {
                context.accumulate(tagName, "");
            }
            return false;
        }
        if (token == GT) {
            while (true) {
                if ((token = x.nextContent()) == null) {
                    if (tagName != null) {
                        throw x.syntaxError("Unclosed tag " + tagName);
                    }
                    return false;
                }
                if (token instanceof String) {
                    string = (String)token;
                    if (string.length() <= 0) continue;
                    jsonobject.accumulate("content", keepStrings ? token : InternalJsonUtil.stringToValue(string));
                    continue;
                }
                if (token == LT && XmlBetweenJsonObject.parse(x, jsonobject, tagName, keepStrings)) break;
            }
            if (jsonobject.size() == 0) {
                context.accumulate(tagName, "");
            } else if (jsonobject.size() == 1 && jsonobject.get("content") != null) {
                context.accumulate(tagName, jsonobject.get("content"));
            } else {
                context.accumulate(tagName, jsonobject);
            }
            return false;
        }
        throw x.syntaxError("Misshaped tag");
    }

    public static JsonObject toJSONObject(String string) throws JsonException {
        return XmlBetweenJsonObject.toJSONObject(string, false);
    }

    public static JsonObject toJSONObject(String string, boolean keepStrings) throws JsonException {
        JsonObject jo = new JsonObject();
        XmlTokener x = new XmlTokener(string);
        while (x.more() && x.skipPast("<")) {
            XmlBetweenJsonObject.parse(x, jo, null, keepStrings);
        }
        return jo;
    }

    public static String toString(Object object) throws JsonException {
        return XmlBetweenJsonObject.toString(object, null);
    }

    public static String toString(Object object, String tagName) throws JsonException {
        String string;
        StringBuilder sb = new StringBuilder();
        if (object instanceof JsonObject) {
            if (tagName != null) {
                sb.append('<');
                sb.append(tagName);
                sb.append('>');
            }
            JsonObject jo = (JsonObject)object;
            for (String key : jo.keySet()) {
                JsonArray ja;
                String string2;
                Object value = jo.get(key);
                if (value == null) {
                    value = "";
                } else if (value.getClass().isArray()) {
                    value = new JsonArray(value);
                }
                String string3 = string2 = value instanceof String ? (String)value : null;
                if ("content".equals(key)) {
                    if (value instanceof JsonArray) {
                        ja = (JsonArray)value;
                        int i = 0;
                        for (Object val : ja) {
                            if (i > 0) {
                                sb.append('\n');
                            }
                            sb.append(XmlBetweenJsonObject.escape(val.toString()));
                            ++i;
                        }
                        continue;
                    }
                    sb.append(XmlBetweenJsonObject.escape(value.toString()));
                    continue;
                }
                if (value instanceof JsonArray) {
                    ja = (JsonArray)value;
                    for (Object val : ja) {
                        if (val instanceof JsonArray) {
                            sb.append('<');
                            sb.append(key);
                            sb.append('>');
                            sb.append(XmlBetweenJsonObject.toString(val));
                            sb.append("</");
                            sb.append(key);
                            sb.append('>');
                            continue;
                        }
                        sb.append(XmlBetweenJsonObject.toString(val, key));
                    }
                    continue;
                }
                if ("".equals(value)) {
                    sb.append('<');
                    sb.append(key);
                    sb.append("/>");
                    continue;
                }
                sb.append(XmlBetweenJsonObject.toString(value, key));
            }
            if (tagName != null) {
                sb.append("</");
                sb.append(tagName);
                sb.append('>');
            }
            return sb.toString();
        }
        if (object != null) {
            if (object.getClass().isArray()) {
                object = new JsonArray(object);
            }
            if (object instanceof JsonArray) {
                JsonArray ja = (JsonArray)object;
                for (Object val : ja) {
                    sb.append(XmlBetweenJsonObject.toString(val, tagName == null ? "array" : tagName));
                }
                return sb.toString();
            }
        }
        String string4 = string = object == null ? "null" : XmlBetweenJsonObject.escape(object.toString());
        return tagName == null ? "\"" + string + "\"" : (string.length() == 0 ? "<" + tagName + "/>" : "<" + tagName + ">" + string + "</" + tagName + ">");
    }
}

