/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.xml;

import java.util.HashMap;
import org.gjgr.pig.chivalrous.core.json.JsonException;
import org.gjgr.pig.chivalrous.core.json.JsonTokener;
import org.gjgr.pig.chivalrous.core.xml.XmlBetweenJsonObject;

public class XmlTokener
extends JsonTokener {
    public static final HashMap<String, Character> entity = new HashMap(8);

    public XmlTokener(String s) {
        super(s);
    }

    public String nextCDATA() throws JsonException {
        int i;
        StringBuilder sb = new StringBuilder();
        do {
            char c = this.next();
            if (this.end()) {
                throw this.syntaxError("Unclosed CDATA");
            }
            sb.append(c);
        } while ((i = sb.length() - 3) < 0 || sb.charAt(i) != ']' || sb.charAt(i + 1) != ']' || sb.charAt(i + 2) != '>');
        sb.setLength(i);
        return sb.toString();
    }

    public Object nextContent() throws JsonException {
        char c;
        while (Character.isWhitespace(c = this.next())) {
        }
        if (c == '\u0000') {
            return null;
        }
        if (c == '<') {
            return XmlBetweenJsonObject.LT;
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            if (c == '<' || c == '\u0000') {
                this.back();
                return sb.toString().trim();
            }
            if (c == '&') {
                sb.append(this.nextEntity(c));
            } else {
                sb.append(c);
            }
            c = this.next();
        }
    }

    public Object nextEntity(char ampersand) throws JsonException {
        char c;
        StringBuilder sb = new StringBuilder();
        while (Character.isLetterOrDigit(c = this.next()) || c == '#') {
            sb.append(Character.toLowerCase(c));
        }
        if (c != ';') {
            throw this.syntaxError("Missing ';' in XmlBetweenJsonObject entity: &" + sb);
        }
        String string = sb.toString();
        Character object = entity.get(string);
        return object != null ? object : ampersand + string + ";";
    }

    public boolean nextMeta(char c, char q) {
        do {
            if ((c = this.next()) != '\u0000') continue;
            throw this.syntaxError("Unterminated string");
        } while (c != q);
        return Boolean.TRUE;
    }

    public boolean nextMeta(char c) {
        c = this.next();
        if (Character.isWhitespace(c)) {
            return Boolean.TRUE;
        }
        switch (c) {
            case '\u0000': 
            case '!': 
            case '\"': 
            case '\'': 
            case '/': 
            case '<': 
            case '=': 
            case '>': 
            case '?': {
                this.back();
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public Object nextMeta() throws JsonException {
        char c;
        while (Character.isWhitespace(c = this.next())) {
        }
        switch (c) {
            case '\u0000': {
                throw this.syntaxError("Misshaped meta tag");
            }
            case '<': {
                return XmlBetweenJsonObject.LT;
            }
            case '>': {
                return XmlBetweenJsonObject.GT;
            }
            case '/': {
                return XmlBetweenJsonObject.SLASH;
            }
            case '=': {
                return XmlBetweenJsonObject.EQ;
            }
            case '!': {
                return XmlBetweenJsonObject.BANG;
            }
            case '?': {
                return XmlBetweenJsonObject.QUEST;
            }
            case '\"': 
            case '\'': {
                char q = c;
                return this.nextMeta(c, q);
            }
        }
        return this.nextMeta(c);
    }

    public String nextToken(char c) {
        char q = c;
        StringBuilder sb = new StringBuilder();
        while (true) {
            if ((c = this.next()) == '\u0000') {
                throw this.syntaxError("Unterminated string");
            }
            if (c == q) {
                return sb.toString();
            }
            if (c == '&') {
                sb.append(this.nextEntity(c));
                continue;
            }
            sb.append(c);
        }
    }

    public Object nextToken() throws JsonException {
        char c;
        while (Character.isWhitespace(c = this.next())) {
        }
        switch (c) {
            case '\u0000': {
                throw this.syntaxError("Misshaped element");
            }
            case '<': {
                throw this.syntaxError("Misplaced '<'");
            }
            case '>': {
                return XmlBetweenJsonObject.GT;
            }
            case '/': {
                return XmlBetweenJsonObject.SLASH;
            }
            case '=': {
                return XmlBetweenJsonObject.EQ;
            }
            case '!': {
                return XmlBetweenJsonObject.BANG;
            }
            case '?': {
                return XmlBetweenJsonObject.QUEST;
            }
            case '\"': 
            case '\'': {
                return this.nextToken(c);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(c);
        c = this.next();
        if (Character.isWhitespace(c)) {
            return sb.toString();
        }
        switch (c) {
            case '\u0000': {
                return sb.toString();
            }
            case '!': 
            case '/': 
            case '=': 
            case '>': 
            case '?': 
            case '[': 
            case ']': {
                this.back();
                return sb.toString();
            }
            case '\"': 
            case '\'': 
            case '<': {
                throw this.syntaxError("Bad character in a name");
            }
        }
        return null;
    }

    public boolean skipPast(String to) throws JsonException {
        char c;
        int i;
        int offset = 0;
        int length = to.length();
        char[] circle = new char[length];
        for (i = 0; i < length; ++i) {
            c = this.next();
            if (c == '\u0000') {
                return false;
            }
            circle[i] = c;
        }
        while (true) {
            int j = offset;
            boolean b = true;
            for (i = 0; i < length; ++i) {
                if (circle[j] != to.charAt(i)) {
                    b = false;
                    break;
                }
                if (++j < length) continue;
                j -= length;
            }
            if (b) {
                return true;
            }
            c = this.next();
            if (c == '\u0000') {
                return false;
            }
            circle[offset] = c;
            if (++offset < length) continue;
            offset -= length;
        }
    }

    static {
        entity.put("amp", XmlBetweenJsonObject.AMP);
        entity.put("apos", XmlBetweenJsonObject.APOS);
        entity.put("gt", XmlBetweenJsonObject.GT);
        entity.put("lt", XmlBetweenJsonObject.LT);
        entity.put("quot", XmlBetweenJsonObject.QUOT);
    }
}

