/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.bloom;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.BitSet;
import org.gjgr.pig.chivalrous.core.bloom.BloomFilter;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.io.file.FileCommand;
import org.gjgr.pig.chivalrous.core.math.HashCommand;

public class BitSetBloomFilter
implements BloomFilter {
    private BitSet bitSet;
    private int bitSetSize;
    private int addedElements;
    private int hashFunctionNumber;

    public BitSetBloomFilter(int c, int n, int k) {
        this.hashFunctionNumber = k;
        this.bitSetSize = (int)Math.ceil(c * k);
        this.addedElements = n;
        this.bitSet = new BitSet(this.bitSetSize);
    }

    public static int[] createHashes(String str, int hashNumber) {
        int[] result = new int[hashNumber];
        for (int i = 0; i < hashNumber; ++i) {
            result[i] = BitSetBloomFilter.hash(str, i);
        }
        return result;
    }

    public static int hash(String str, int k) {
        switch (k) {
            case 0: {
                return HashCommand.rsHash(str);
            }
            case 1: {
                return HashCommand.jsHash(str);
            }
            case 2: {
                return HashCommand.elfHash(str);
            }
            case 3: {
                return HashCommand.bkdrHash(str);
            }
            case 4: {
                return HashCommand.apHash(str);
            }
            case 5: {
                return HashCommand.djbHash(str);
            }
            case 6: {
                return HashCommand.sdbmHash(str);
            }
            case 7: {
                return HashCommand.pjwHash(str);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String path, String charset) throws IOException {
        BufferedReader reader = FileCommand.bufferedReader(path, charset);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.add(line);
            }
        }
        finally {
            IoCommand.close(reader);
        }
    }

    @Override
    public boolean contains(String str) {
        int[] positions;
        for (int i : positions = BitSetBloomFilter.createHashes(str, this.hashFunctionNumber)) {
            int position = Math.abs(i % this.bitSetSize);
            if (this.bitSet.get(position)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(String str) {
        if (this.contains(str)) {
            return false;
        }
        int[] positions = BitSetBloomFilter.createHashes(str, this.hashFunctionNumber);
        for (int i = 0; i < positions.length; ++i) {
            int position = Math.abs(positions[i] % this.bitSetSize);
            this.bitSet.set(position, true);
        }
        return true;
    }

    public double getFalsePositiveProbability() {
        return Math.pow(1.0 - Math.exp((double)(-this.hashFunctionNumber) * (double)this.addedElements / (double)this.bitSetSize), this.hashFunctionNumber);
    }
}

