/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.cache.file;

import java.io.File;
import org.gjgr.pig.chivalrous.core.cache.Cache;
import org.gjgr.pig.chivalrous.core.cache.file.FileCache;
import org.gjgr.pig.chivalrous.core.cache.impl.LRUCache;

public class LRUFileCache
extends FileCache {
    public LRUFileCache(int capacity) {
        this(capacity, capacity / 2, 0L);
    }

    public LRUFileCache(int capacity, int maxFileSize) {
        this(capacity, maxFileSize, 0L);
    }

    public LRUFileCache(int capacity, int maxFileSize, long timeout) {
        super(capacity, maxFileSize, timeout);
    }

    @Override
    protected Cache<File, byte[]> initCache() {
        LRUCache<File, byte[]> cache = new LRUCache<File, byte[]>(this.capacity, this.timeout){

            @Override
            public boolean isFull() {
                return LRUFileCache.this.usedSize > this.capacity;
            }

            @Override
            protected void onRemove(File key, byte[] cachedObject) {
                LRUFileCache.this.usedSize -= cachedObject.length;
            }
        };
        return cache;
    }
}

