/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.cache.impl;

import java.util.HashMap;
import java.util.Iterator;
import org.gjgr.pig.chivalrous.core.cache.impl.AbstractCache;
import org.gjgr.pig.chivalrous.core.cache.impl.CacheObj;

public class LFUCache<K, V>
extends AbstractCache<K, V> {
    public LFUCache(int capacity) {
        this(capacity, 0L);
    }

    public LFUCache(int capacity, long timeout) {
        this.capacity = capacity;
        this.timeout = timeout;
        this.cacheMap = new HashMap(capacity + 1);
    }

    @Override
    protected int pruneCache() {
        int count = 0;
        CacheObj comin = null;
        Iterator values = this.cacheMap.values().iterator();
        while (values.hasNext()) {
            CacheObj co = (CacheObj)values.next();
            if (co.isExpired()) {
                values.remove();
                this.onRemove(co.key, co.obj);
                ++count;
                continue;
            }
            if (comin != null && co.accessCount >= comin.accessCount) continue;
            comin = co;
        }
        if (this.isFull() && comin != null) {
            long minAccessCount = comin.accessCount;
            values = this.cacheMap.values().iterator();
            while (values.hasNext()) {
                CacheObj co1 = (CacheObj)values.next();
                co1.accessCount -= minAccessCount;
                if (co1.accessCount > 0L) continue;
                values.remove();
                this.onRemove(co1.key, co1.obj);
                ++count;
            }
        }
        return count;
    }
}

