/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.cache.impl;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gjgr.pig.chivalrous.core.cache.impl.AbstractCache;
import org.gjgr.pig.chivalrous.core.cache.impl.CacheObj;

public class LRUCache<K, V>
extends AbstractCache<K, V> {
    public LRUCache(int capacity) {
        this(capacity, 0L);
    }

    public LRUCache(int capacity, long timeout) {
        this.capacity = capacity;
        this.timeout = timeout;
        this.cacheMap = new LinkedHashMap<K, CacheObj<K, V>>(capacity + 1, 1.0f, true){
            private static final long serialVersionUID = -1806954614512571136L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, CacheObj<K, V>> eldest) {
                if (LRUCache.this.capacity == 0) {
                    return false;
                }
                return this.size() > LRUCache.this.capacity;
            }
        };
    }

    @Override
    protected int pruneCache() {
        if (!this.isPruneExpiredActive()) {
            return 0;
        }
        int count = 0;
        Iterator values = this.cacheMap.values().iterator();
        while (values.hasNext()) {
            CacheObj co = (CacheObj)values.next();
            if (!co.isExpired()) continue;
            values.remove();
            this.onRemove(co.key, co.obj);
            ++count;
        }
        return count;
    }
}

