/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.command;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gjgr.pig.chivalrous.core.command.CommandPackageCovert;
import org.gjgr.pig.chivalrous.core.command.SimpleJavaCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public abstract class JavaCommand
implements Runnable,
CommandLine.IExitCodeExceptionMapper {
    public static CommandLine commandLine = new CommandLine(SimpleJavaCommand.class);
    public static HashMap<String, CommandLine> commandLines = new HashMap();
    @CommandLine.Option(names={"-d", "--debug"}, required=false, defaultValue="false", description={"debug status"})
    String debug;
    @CommandLine.Option(names={"-i", "--input"}, paramLabel="INPUT", description={"spark input path"})
    String input;
    @CommandLine.Option(names={"-o", "--output"}, paramLabel="OUTPUT", description={"spark output path"})
    String output;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec = null;
    private static final Logger logger;

    protected CommandLine.Model.CommandSpec getSpec() {
        return this.spec;
    }

    public Map<String, Class<?>> commandLoader(String packages) {
        Map<String, Class<?>> classMap = null;
        if (packages != null) {
            classMap = this.scanCommand(packages, CommandLine.Command.class);
        } else {
            logger.info("used default creat instance");
            classMap = new HashMap();
        }
        classMap.putAll(this.loadCommand());
        return classMap;
    }

    public Map<String, Class<?>> loadCommand() {
        HashMap clazzMap = new HashMap();
        Reflections reflections = new Reflections("com.xiaomi.beelab", new Scanner[0]);
        Set sets = reflections.getSubTypesOf(JavaCommand.class);
        for (Class clazz : sets) {
            CommandLine.Command command = clazz.getAnnotation(CommandLine.Command.class);
            if (command == null || command.subcommands().length <= 0) continue;
            clazzMap.put(command.name(), clazz);
            if (!StringCommand.join(Arrays.asList(command.description()), " ").contains("auto")) continue;
            commandLines.put(command.name(), new CommandLine((Object)clazz));
        }
        return clazzMap;
    }

    public <A extends Annotation> Map<String, Class<?>> scanCommand(String packages, Class<A> theClass) {
        HashMap clazzMap = new HashMap();
        Reflections reflections = new Reflections(packages, new Scanner[0]);
        Set sets = reflections.getTypesAnnotatedWith(theClass);
        for (Class clazz : sets) {
            A command = clazz.getAnnotation(theClass);
            if (command.annotationType() == CommandLine.Command.class) {
                CommandLine.Command command1 = (CommandLine.Command)command;
                if (command1.subcommands().length > 0) {
                    clazzMap.put(command1.name(), clazz);
                    continue;
                }
                logger.info("found method Annotation class {}, Annotation command name {}", theClass, (Object)command1.name());
                continue;
            }
            logger.info("need to do");
        }
        return clazzMap;
    }

    public Map<String, Class<?>> scanCommand(String packages) {
        HashMap clazzMap = new HashMap();
        Reflections reflections = new Reflections(packages, new Scanner[0]);
        Set sets = reflections.getTypesAnnotatedWith(CommandLine.Command.class);
        for (Class clazz : sets) {
            CommandLine.Command command = clazz.getAnnotation(CommandLine.Command.class);
            clazzMap.put(command.name(), clazz);
        }
        HashSet<String> subs = new HashSet<String>();
        for (Map.Entry entry : clazzMap.entrySet()) {
            CommandLine.Command command = ((Class)entry.getValue()).getAnnotation(CommandLine.Command.class);
            for (Class sub : command.subcommands()) {
                CommandLine.Command subCommand = sub.getAnnotation(CommandLine.Command.class);
                subs.add(subCommand.name());
            }
        }
        for (String sub : subs) {
            clazzMap.remove(sub);
        }
        return clazzMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(String packages, String[] args) {
        int code = -1;
        String[] inputArgs = (String[])args.clone();
        try {
            Map<String, Class<?>> map = this.commandLoader(packages);
            if (commandLines.containsKey(inputArgs[0])) {
                commandLine = commandLines.get(inputArgs[0]);
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(args));
                list.remove(inputArgs[0]);
                inputArgs = list.toArray(new String[0]);
            } else if (!map.containsKey(inputArgs[0])) {
                commandLine.execute(args);
                System.exit(101);
            } else {
                commandLine = new CommandLine(map.get(inputArgs[0]));
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(args));
                list.remove(inputArgs[0]);
                inputArgs = list.toArray(new String[0]);
            }
            code = commandLine.execute(inputArgs);
        }
        catch (Error e) {
            logger.error("throw a Error {}", (Throwable)e);
            code = -1024;
        }
        catch (Exception e) {
            logger.error("throw a Exception {}", (Throwable)e);
            code = -2048;
        }
        finally {
            if (code == -1) {
                logger.error("application cli exit code: {}", (Object)code);
                throw new RuntimeException("task error exception");
            }
            if (code != 0) {
                logger.error("found the task faild {}", (Object)commandLine.getErr());
                throw new RuntimeException("task error code not 0 exception");
            }
            logger.info("task work finished code: {}", (Object)code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(String[] args) {
        CommandPackageCovert convert = null;
        try {
            convert = (CommandPackageCovert)CommandLine.populateCommand((Object)new CommandPackageCovert(), (String[])args);
        }
        catch (Exception e) {
            convert = new CommandPackageCovert();
        }
        finally {
            if (convert.pagckages != null) {
                for (String s : convert.pagckages) {
                    this.launch(s, convert.args);
                }
            } else {
                this.launch(null, args);
            }
        }
    }

    public int getExitCode(Throwable throwable) {
        if (throwable instanceof Exception) {
            return -1;
        }
        return 1;
    }

    static {
        commandLines.put(commandLine.getCommandName(), commandLine);
        logger = LoggerFactory.getLogger(JavaCommand.class);
    }
}

